/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.UnsupportedAppUsage;
import android.net.DnsResolver;
import android.net.IpPrefix;
import android.net.Network;
import android.net.TcpRepairWindow;
import android.net.shared.Inet4AddressUtils;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import java.io.FileDescriptor;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;

public class NetworkUtils {
    private static final String TAG = "NetworkUtils";
    private static final int[] ADDRESS_FAMILIES = new int[]{OsConstants.AF_INET, OsConstants.AF_INET6};

    public static native void attachDropAllBPFFilter(FileDescriptor var0) throws SocketException;

    public static native void detachBPFFilter(FileDescriptor var0) throws SocketException;

    public static native void setupRaSocket(FileDescriptor var0, int var1) throws SocketException;

    public static native boolean bindProcessToNetwork(int var0);

    public static native int getBoundNetworkForProcess();

    @Deprecated
    public static native boolean bindProcessToNetworkForHostResolution(int var0);

    public static native int bindSocketToNetwork(int var0, int var1);

    @UnsupportedAppUsage
    public static boolean protectFromVpn(FileDescriptor fd) {
        return NetworkUtils.protectFromVpn(fd.getInt$());
    }

    public static native boolean protectFromVpn(int var0);

    public static native boolean queryUserAccess(int var0, int var1);

    public static native FileDescriptor resNetworkSend(int var0, byte[] var1, int var2, int var3) throws ErrnoException;

    public static native FileDescriptor resNetworkQuery(int var0, String var1, int var2, int var3, int var4) throws ErrnoException;

    public static native DnsResolver.DnsResponse resNetworkResult(FileDescriptor var0) throws ErrnoException;

    public static native void resNetworkCancel(FileDescriptor var0);

    public static native Network getDnsNetwork() throws ErrnoException;

    public static native TcpRepairWindow getTcpRepairWindow(FileDescriptor var0) throws ErrnoException;

    @Deprecated
    @UnsupportedAppUsage
    public static InetAddress intToInetAddress(int hostAddress) {
        return Inet4AddressUtils.intToInet4AddressHTL(hostAddress);
    }

    @Deprecated
    public static int inetAddressToInt(Inet4Address inetAddr) throws IllegalArgumentException {
        return Inet4AddressUtils.inet4AddressToIntHTL(inetAddr);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static int prefixLengthToNetmaskInt(int prefixLength) throws IllegalArgumentException {
        return Inet4AddressUtils.prefixLengthToV4NetmaskIntHTL(prefixLength);
    }

    public static int netmaskIntToPrefixLength(int netmask) {
        return Integer.bitCount(netmask);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static int netmaskToPrefixLength(Inet4Address netmask) {
        return Inet4AddressUtils.netmaskToPrefixLength(netmask);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28)
    public static InetAddress numericToInetAddress(String addrString) throws IllegalArgumentException {
        return InetAddress.parseNumericAddress((String)addrString);
    }

    public static void maskRawAddress(byte[] array2, int prefixLength) {
        if (prefixLength < 0 || prefixLength > array2.length * 8) {
            throw new RuntimeException("IP address with " + array2.length + " bytes has invalid prefix length " + prefixLength);
        }
        int offset = prefixLength / 8;
        int remainder = prefixLength % 8;
        byte mask = (byte)(255 << 8 - remainder);
        if (offset < array2.length) {
            array2[offset] = (byte)(array2[offset] & mask);
        }
        ++offset;
        while (offset < array2.length) {
            array2[offset] = 0;
            ++offset;
        }
    }

    public static InetAddress getNetworkPart(InetAddress address, int prefixLength) {
        byte[] array2 = address.getAddress();
        NetworkUtils.maskRawAddress(array2, prefixLength);
        InetAddress netPart = null;
        try {
            netPart = InetAddress.getByAddress(array2);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("getNetworkPart error - " + e.toString());
        }
        return netPart;
    }

    @UnsupportedAppUsage
    public static int getImplicitNetmask(Inet4Address address) {
        return Inet4AddressUtils.getImplicitNetmask(address);
    }

    public static Pair<InetAddress, Integer> parseIpAndMask(String ipAndMaskString) {
        InetAddress address = null;
        int prefixLength = -1;
        try {
            String[] pieces = ipAndMaskString.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            address = InetAddress.parseNumericAddress((String)pieces[0]);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (address == null || prefixLength == -1) {
            throw new IllegalArgumentException("Invalid IP address and mask " + ipAndMaskString);
        }
        return new Pair<Object, Integer>(address, prefixLength);
    }

    public static boolean addressTypeMatches(InetAddress left, InetAddress right) {
        return left instanceof Inet4Address && right instanceof Inet4Address || left instanceof Inet6Address && right instanceof Inet6Address;
    }

    public static InetAddress hexToInet6Address(String addrHexString) throws IllegalArgumentException {
        try {
            return NetworkUtils.numericToInetAddress(String.format(Locale.US, "%s:%s:%s:%s:%s:%s:%s:%s", addrHexString.substring(0, 4), addrHexString.substring(4, 8), addrHexString.substring(8, 12), addrHexString.substring(12, 16), addrHexString.substring(16, 20), addrHexString.substring(20, 24), addrHexString.substring(24, 28), addrHexString.substring(28, 32)));
        }
        catch (Exception e) {
            Log.e(TAG, "error in hexToInet6Address(" + addrHexString + "): " + e);
            throw new IllegalArgumentException(e);
        }
    }

    public static String[] makeStrings(Collection<InetAddress> addrs) {
        String[] result = new String[addrs.size()];
        int i = 0;
        for (InetAddress addr : addrs) {
            result[i++] = addr.getHostAddress();
        }
        return result;
    }

    @UnsupportedAppUsage
    public static String trimV4AddrZeros(String addr) {
        if (addr == null) {
            return null;
        }
        String[] octets = addr.split("\\.");
        if (octets.length != 4) {
            return addr;
        }
        StringBuilder builder = new StringBuilder(16);
        String result = null;
        for (int i = 0; i < 4; ++i) {
            try {
                if (octets[i].length() > 3) {
                    return addr;
                }
                builder.append(Integer.parseInt(octets[i]));
            }
            catch (NumberFormatException e) {
                return addr;
            }
            if (i >= 3) continue;
            builder.append('.');
        }
        result = builder.toString();
        return result;
    }

    private static TreeSet<IpPrefix> deduplicatePrefixSet(TreeSet<IpPrefix> src) {
        TreeSet<IpPrefix> dst = new TreeSet<IpPrefix>(src.comparator());
        block0: for (IpPrefix newPrefix : src) {
            for (IpPrefix existingPrefix : dst) {
                if (!existingPrefix.containsPrefix(newPrefix)) continue;
                continue block0;
            }
            dst.add(newPrefix);
        }
        return dst;
    }

    public static long routedIPv4AddressCount(TreeSet<IpPrefix> prefixes) {
        long routedIPCount = 0L;
        for (IpPrefix prefix : NetworkUtils.deduplicatePrefixSet(prefixes)) {
            if (!prefix.isIPv4()) {
                Log.wtf(TAG, "Non-IPv4 prefix in routedIPv4AddressCount");
            }
            int rank = 32 - prefix.getPrefixLength();
            routedIPCount += 1L << rank;
        }
        return routedIPCount;
    }

    public static BigInteger routedIPv6AddressCount(TreeSet<IpPrefix> prefixes) {
        BigInteger routedIPCount = BigInteger.ZERO;
        for (IpPrefix prefix : NetworkUtils.deduplicatePrefixSet(prefixes)) {
            if (!prefix.isIPv6()) {
                Log.wtf(TAG, "Non-IPv6 prefix in routedIPv6AddressCount");
            }
            int rank = 128 - prefix.getPrefixLength();
            routedIPCount = routedIPCount.add(BigInteger.ONE.shiftLeft(rank));
        }
        return routedIPCount;
    }

    public static boolean isWeaklyValidatedHostname(String hostname) {
        String weakHostnameRegex = "^[a-zA-Z0-9_.-]+$";
        if (!hostname.matches("^[a-zA-Z0-9_.-]+$")) {
            return false;
        }
        for (int address_family : ADDRESS_FAMILIES) {
            if (Os.inet_pton(address_family, hostname) == null) continue;
            return false;
        }
        return true;
    }
}

