/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.KeepalivePacketData;
import android.net.SocketKeepalive;
import android.net.TcpKeepalivePacketDataParcelable;
import android.net.util.IpUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.OsConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class TcpKeepalivePacketData
extends KeepalivePacketData
implements Parcelable {
    private static final String TAG = "TcpKeepalivePacketData";
    public final int tcpSeq;
    public final int tcpAck;
    public final int tcpWnd;
    public final int tcpWndScale;
    public final int ipTos;
    public final int ipTtl;
    private static final int IPV4_HEADER_LENGTH = 20;
    private static final int IPV6_HEADER_LENGTH = 40;
    private static final int TCP_HEADER_LENGTH = 20;
    public static final Parcelable.Creator<TcpKeepalivePacketData> CREATOR = new Parcelable.Creator<TcpKeepalivePacketData>(){

        @Override
        public TcpKeepalivePacketData createFromParcel(Parcel in) {
            return new TcpKeepalivePacketData(in);
        }

        public TcpKeepalivePacketData[] newArray(int size) {
            return new TcpKeepalivePacketData[size];
        }
    };

    private TcpKeepalivePacketData(TcpKeepalivePacketDataParcelable tcpDetails, byte[] data) throws SocketKeepalive.InvalidPacketException, UnknownHostException {
        super(InetAddress.getByAddress(tcpDetails.srcAddress), tcpDetails.srcPort, InetAddress.getByAddress(tcpDetails.dstAddress), tcpDetails.dstPort, data);
        this.tcpSeq = tcpDetails.seq;
        this.tcpAck = tcpDetails.ack;
        this.tcpWnd = tcpDetails.rcvWnd;
        this.tcpWndScale = tcpDetails.rcvWndScale;
        this.ipTos = tcpDetails.tos;
        this.ipTtl = tcpDetails.ttl;
    }

    public static TcpKeepalivePacketData tcpKeepalivePacket(TcpKeepalivePacketDataParcelable tcpDetails) throws SocketKeepalive.InvalidPacketException {
        try {
            if (tcpDetails.srcAddress == null || tcpDetails.dstAddress == null || tcpDetails.srcAddress.length != 4 || tcpDetails.dstAddress.length != 4) {
                throw new SocketKeepalive.InvalidPacketException(-21);
            }
            byte[] packet = TcpKeepalivePacketData.buildV4Packet(tcpDetails);
            return new TcpKeepalivePacketData(tcpDetails, packet);
        }
        catch (UnknownHostException e) {
            throw new SocketKeepalive.InvalidPacketException(-21);
        }
    }

    private static byte[] buildV4Packet(TcpKeepalivePacketDataParcelable tcpDetails) {
        int length = 40;
        ByteBuffer buf = ByteBuffer.allocate(40);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)69);
        buf.put((byte)tcpDetails.tos);
        buf.putShort((short)40);
        buf.putInt(16384);
        buf.put((byte)tcpDetails.ttl);
        buf.put((byte)OsConstants.IPPROTO_TCP);
        int ipChecksumOffset = buf.position();
        buf.putShort((short)0);
        buf.put(tcpDetails.srcAddress);
        buf.put(tcpDetails.dstAddress);
        buf.putShort((short)tcpDetails.srcPort);
        buf.putShort((short)tcpDetails.dstPort);
        buf.putInt(tcpDetails.seq);
        buf.putInt(tcpDetails.ack);
        buf.putShort((short)20496);
        buf.putShort((short)(tcpDetails.rcvWnd >> tcpDetails.rcvWndScale));
        int tcpChecksumOffset = buf.position();
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putShort(ipChecksumOffset, IpUtils.ipChecksum(buf, 0));
        buf.putShort(tcpChecksumOffset, IpUtils.tcpChecksum(buf, 0, 20, 20));
        return buf.array();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TcpKeepalivePacketData)) {
            return false;
        }
        TcpKeepalivePacketData other = (TcpKeepalivePacketData)o;
        return this.srcAddress.equals(other.srcAddress) && this.dstAddress.equals(other.dstAddress) && this.srcPort == other.srcPort && this.dstPort == other.dstPort && this.tcpAck == other.tcpAck && this.tcpSeq == other.tcpSeq && this.tcpWnd == other.tcpWnd && this.tcpWndScale == other.tcpWndScale && this.ipTos == other.ipTos && this.ipTtl == other.ipTtl;
    }

    public int hashCode() {
        return Objects.hash(this.srcAddress, this.dstAddress, this.srcPort, this.dstPort, this.tcpAck, this.tcpSeq, this.tcpWnd, this.tcpWndScale, this.ipTos, this.ipTtl);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeInt(this.tcpSeq);
        out.writeInt(this.tcpAck);
        out.writeInt(this.tcpWnd);
        out.writeInt(this.tcpWndScale);
        out.writeInt(this.ipTos);
        out.writeInt(this.ipTtl);
    }

    private TcpKeepalivePacketData(Parcel in) {
        super(in);
        this.tcpSeq = in.readInt();
        this.tcpAck = in.readInt();
        this.tcpWnd = in.readInt();
        this.tcpWndScale = in.readInt();
        this.ipTos = in.readInt();
        this.ipTtl = in.readInt();
    }

    public TcpKeepalivePacketDataParcelable toStableParcelable() {
        TcpKeepalivePacketDataParcelable parcel = new TcpKeepalivePacketDataParcelable();
        parcel.srcAddress = this.srcAddress.getAddress();
        parcel.srcPort = this.srcPort;
        parcel.dstAddress = this.dstAddress.getAddress();
        parcel.dstPort = this.dstPort;
        parcel.seq = this.tcpSeq;
        parcel.ack = this.tcpAck;
        parcel.rcvWnd = this.tcpWnd;
        parcel.rcvWndScale = this.tcpWndScale;
        parcel.tos = this.ipTos;
        parcel.ttl = this.ipTtl;
        return parcel;
    }

    public String toString() {
        return "saddr: " + this.srcAddress + " daddr: " + this.dstAddress + " sport: " + this.srcPort + " dport: " + this.dstPort + " seq: " + this.tcpSeq + " ack: " + this.tcpAck + " wnd: " + this.tcpWnd + " wndScale: " + this.tcpWndScale + " tos: " + this.ipTos + " ttl: " + this.ipTtl;
    }
}

