/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IConnectivityManager;
import android.net.Network;
import android.net.SocketKeepalive;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.util.concurrent.Executor;

final class TcpSocketKeepalive
extends SocketKeepalive {
    TcpSocketKeepalive(IConnectivityManager service, Network network, ParcelFileDescriptor pfd, Executor executor, SocketKeepalive.Callback callback) {
        super(service, network, pfd, executor, callback);
    }

    @Override
    void startImpl(int intervalSec) {
        this.mExecutor.execute(() -> {
            try {
                FileDescriptor fd = this.mPfd.getFileDescriptor();
                this.mService.startTcpKeepalive(this.mNetwork, fd, intervalSec, this.mCallback);
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error starting packet keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }

    @Override
    void stopImpl() {
        this.mExecutor.execute(() -> {
            try {
                if (this.mSlot != null) {
                    this.mService.stopKeepalive(this.mNetwork, this.mSlot);
                }
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error stopping packet keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }
}

