/*
 * Decompiled with CFR 0.152.
 */
package android.net.apf;

import android.annotation.SystemApi;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public final class ApfCapabilities
implements Parcelable {
    public final int apfVersionSupported;
    public final int maximumApfProgramSize;
    public final int apfPacketFormat;
    public static final Parcelable.Creator<ApfCapabilities> CREATOR = new Parcelable.Creator<ApfCapabilities>(){

        @Override
        public ApfCapabilities createFromParcel(Parcel in) {
            return new ApfCapabilities(in);
        }

        public ApfCapabilities[] newArray(int size) {
            return new ApfCapabilities[size];
        }
    };

    public ApfCapabilities(int apfVersionSupported, int maximumApfProgramSize, int apfPacketFormat) {
        this.apfVersionSupported = apfVersionSupported;
        this.maximumApfProgramSize = maximumApfProgramSize;
        this.apfPacketFormat = apfPacketFormat;
    }

    private ApfCapabilities(Parcel in) {
        this.apfVersionSupported = in.readInt();
        this.maximumApfProgramSize = in.readInt();
        this.apfPacketFormat = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.apfVersionSupported);
        dest.writeInt(this.maximumApfProgramSize);
        dest.writeInt(this.apfPacketFormat);
    }

    public String toString() {
        return String.format("%s{version: %d, maxSize: %d, format: %d}", this.getClass().getSimpleName(), this.apfVersionSupported, this.maximumApfProgramSize, this.apfPacketFormat);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApfCapabilities)) {
            return false;
        }
        ApfCapabilities other = (ApfCapabilities)obj;
        return this.apfVersionSupported == other.apfVersionSupported && this.maximumApfProgramSize == other.maximumApfProgramSize && this.apfPacketFormat == other.apfPacketFormat;
    }

    public boolean hasDataAccess() {
        return this.apfVersionSupported >= 4;
    }

    public static boolean getApfDrop8023Frames() {
        return Resources.getSystem().getBoolean(0x1110021);
    }

    public static int[] getApfEtherTypeBlackList() {
        return Resources.getSystem().getIntArray(0x1070010);
    }
}

