/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.INetworkStackStatusCallback;
import android.net.dhcp.DhcpServingParamsParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDhcpServer
extends IInterface {
    public static final int VERSION = 3;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_INVALID_ARGUMENT = 2;
    public static final int STATUS_UNKNOWN_ERROR = 3;

    public void start(INetworkStackStatusCallback var1) throws RemoteException;

    public void updateParams(DhcpServingParamsParcel var1, INetworkStackStatusCallback var2) throws RemoteException;

    public void stop(INetworkStackStatusCallback var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDhcpServer {
        private static final String DESCRIPTOR = "android.net.dhcp.IDhcpServer";
        static final int TRANSACTION_start = 1;
        static final int TRANSACTION_updateParams = 2;
        static final int TRANSACTION_stop = 3;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDhcpServer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDhcpServer) {
                return (IDhcpServer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    INetworkStackStatusCallback _arg0 = INetworkStackStatusCallback.Stub.asInterface(data.readStrongBinder());
                    this.start(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    DhcpServingParamsParcel _arg0 = 0 != data.readInt() ? DhcpServingParamsParcel.CREATOR.createFromParcel(data) : null;
                    INetworkStackStatusCallback _arg1 = INetworkStackStatusCallback.Stub.asInterface(data.readStrongBinder());
                    this.updateParams(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    INetworkStackStatusCallback _arg0 = INetworkStackStatusCallback.Stub.asInterface(data.readStrongBinder());
                    this.stop(_arg0);
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDhcpServer impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDhcpServer getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDhcpServer {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            public static IDhcpServer sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(INetworkStackStatusCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().start(cb);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateParams(DhcpServingParamsParcel params, INetworkStackStatusCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateParams(params, cb);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop(INetworkStackStatusCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stop(cb);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(Stub.DESCRIPTOR);
                        this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }
        }
    }

    public static class Default
    implements IDhcpServer {
        @Override
        public void start(INetworkStackStatusCallback cb) throws RemoteException {
        }

        @Override
        public void updateParams(DhcpServingParamsParcel params, INetworkStackStatusCallback cb) throws RemoteException {
        }

        @Override
        public void stop(INetworkStackStatusCallback cb) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return -1;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

