/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.DhcpResultsParcelable;
import android.net.LinkProperties;
import android.net.ip.IIpClient;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IIpClientCallbacks
extends IInterface {
    public static final int VERSION = 3;

    public void onIpClientCreated(IIpClient var1) throws RemoteException;

    public void onPreDhcpAction() throws RemoteException;

    public void onPostDhcpAction() throws RemoteException;

    public void onNewDhcpResults(DhcpResultsParcelable var1) throws RemoteException;

    public void onProvisioningSuccess(LinkProperties var1) throws RemoteException;

    public void onProvisioningFailure(LinkProperties var1) throws RemoteException;

    public void onLinkPropertiesChange(LinkProperties var1) throws RemoteException;

    public void onReachabilityLost(String var1) throws RemoteException;

    public void onQuit() throws RemoteException;

    public void installPacketFilter(byte[] var1) throws RemoteException;

    public void startReadPacketFilter() throws RemoteException;

    public void setFallbackMulticastFilter(boolean var1) throws RemoteException;

    public void setNeighborDiscoveryOffload(boolean var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIpClientCallbacks {
        private static final String DESCRIPTOR = "android.net.ip.IIpClientCallbacks";
        static final int TRANSACTION_onIpClientCreated = 1;
        static final int TRANSACTION_onPreDhcpAction = 2;
        static final int TRANSACTION_onPostDhcpAction = 3;
        static final int TRANSACTION_onNewDhcpResults = 4;
        static final int TRANSACTION_onProvisioningSuccess = 5;
        static final int TRANSACTION_onProvisioningFailure = 6;
        static final int TRANSACTION_onLinkPropertiesChange = 7;
        static final int TRANSACTION_onReachabilityLost = 8;
        static final int TRANSACTION_onQuit = 9;
        static final int TRANSACTION_installPacketFilter = 10;
        static final int TRANSACTION_startReadPacketFilter = 11;
        static final int TRANSACTION_setFallbackMulticastFilter = 12;
        static final int TRANSACTION_setNeighborDiscoveryOffload = 13;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIpClientCallbacks asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IIpClientCallbacks) {
                return (IIpClientCallbacks)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IIpClient _arg0 = IIpClient.Stub.asInterface(data.readStrongBinder());
                    this.onIpClientCreated(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onPreDhcpAction();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onPostDhcpAction();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    DhcpResultsParcelable _arg0 = 0 != data.readInt() ? DhcpResultsParcelable.CREATOR.createFromParcel(data) : null;
                    this.onNewDhcpResults(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    LinkProperties _arg0 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    this.onProvisioningSuccess(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    LinkProperties _arg0 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    this.onProvisioningFailure(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    LinkProperties _arg0 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    this.onLinkPropertiesChange(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onReachabilityLost(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    this.onQuit();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    this.installPacketFilter(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    this.startReadPacketFilter();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setFallbackMulticastFilter(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setNeighborDiscoveryOffload(_arg0);
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IIpClientCallbacks impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IIpClientCallbacks getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IIpClientCallbacks {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            public static IIpClientCallbacks sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIpClientCreated(IIpClient ipClient) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(ipClient != null ? ipClient.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onIpClientCreated(ipClient);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPreDhcpAction() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPreDhcpAction();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPostDhcpAction() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPostDhcpAction();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewDhcpResults(DhcpResultsParcelable dhcpResults) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (dhcpResults != null) {
                        _data.writeInt(1);
                        dhcpResults.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNewDhcpResults(dhcpResults);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProvisioningSuccess(LinkProperties newLp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (newLp != null) {
                        _data.writeInt(1);
                        newLp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProvisioningSuccess(newLp);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProvisioningFailure(LinkProperties newLp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (newLp != null) {
                        _data.writeInt(1);
                        newLp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProvisioningFailure(newLp);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLinkPropertiesChange(LinkProperties newLp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (newLp != null) {
                        _data.writeInt(1);
                        newLp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onLinkPropertiesChange(newLp);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReachabilityLost(String logMsg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(logMsg);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onReachabilityLost(logMsg);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQuit() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onQuit();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void installPacketFilter(byte[] filter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(filter);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().installPacketFilter(filter);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void startReadPacketFilter() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startReadPacketFilter();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFallbackMulticastFilter(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setFallbackMulticastFilter(enabled);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNeighborDiscoveryOffload(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setNeighborDiscoveryOffload(enable);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(Stub.DESCRIPTOR);
                        this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }
        }
    }

    public static class Default
    implements IIpClientCallbacks {
        @Override
        public void onIpClientCreated(IIpClient ipClient) throws RemoteException {
        }

        @Override
        public void onPreDhcpAction() throws RemoteException {
        }

        @Override
        public void onPostDhcpAction() throws RemoteException {
        }

        @Override
        public void onNewDhcpResults(DhcpResultsParcelable dhcpResults) throws RemoteException {
        }

        @Override
        public void onProvisioningSuccess(LinkProperties newLp) throws RemoteException {
        }

        @Override
        public void onProvisioningFailure(LinkProperties newLp) throws RemoteException {
        }

        @Override
        public void onLinkPropertiesChange(LinkProperties newLp) throws RemoteException {
        }

        @Override
        public void onReachabilityLost(String logMsg) throws RemoteException {
        }

        @Override
        public void onQuit() throws RemoteException {
        }

        @Override
        public void installPacketFilter(byte[] filter) throws RemoteException {
        }

        @Override
        public void startReadPacketFilter() throws RemoteException {
        }

        @Override
        public void setFallbackMulticastFilter(boolean enabled) throws RemoteException {
        }

        @Override
        public void setNeighborDiscoveryOffload(boolean enable) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return -1;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

