/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.INetd;
import android.net.InterfaceConfigurationParcel;
import android.net.LinkAddress;
import android.net.util.SharedLog;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.OsConstants;
import java.net.Inet4Address;
import java.net.InetAddress;

public class InterfaceController {
    private static final boolean DBG = false;
    private final String mIfName;
    private final INetd mNetd;
    private final SharedLog mLog;

    public InterfaceController(String ifname, INetd netd, SharedLog log) {
        this.mIfName = ifname;
        this.mNetd = netd;
        this.mLog = log;
    }

    private boolean setInterfaceAddress(LinkAddress addr) {
        InterfaceConfigurationParcel ifConfig = new InterfaceConfigurationParcel();
        ifConfig.ifName = this.mIfName;
        ifConfig.ipv4Addr = addr.getAddress().getHostAddress();
        ifConfig.prefixLength = addr.getPrefixLength();
        ifConfig.hwAddr = "";
        ifConfig.flags = new String[0];
        try {
            this.mNetd.interfaceSetCfg(ifConfig);
        }
        catch (RemoteException | ServiceSpecificException e) {
            this.logError("Setting IPv4 address to %s/%d failed: %s", ifConfig.ipv4Addr, ifConfig.prefixLength, e);
            return false;
        }
        return true;
    }

    public boolean setIPv4Address(LinkAddress address) {
        if (!(address.getAddress() instanceof Inet4Address)) {
            return false;
        }
        return this.setInterfaceAddress(address);
    }

    public boolean clearIPv4Address() {
        return this.setInterfaceAddress(new LinkAddress("0.0.0.0/0"));
    }

    private boolean setEnableIPv6(boolean enabled) {
        try {
            this.mNetd.interfaceSetEnableIPv6(this.mIfName, enabled);
        }
        catch (RemoteException | ServiceSpecificException e) {
            this.logError("%s IPv6 failed: %s", enabled ? "enabling" : "disabling", e);
            return false;
        }
        return true;
    }

    public boolean enableIPv6() {
        return this.setEnableIPv6(true);
    }

    public boolean disableIPv6() {
        return this.setEnableIPv6(false);
    }

    public boolean setIPv6PrivacyExtensions(boolean enabled) {
        try {
            this.mNetd.interfaceSetIPv6PrivacyExtensions(this.mIfName, enabled);
        }
        catch (RemoteException | ServiceSpecificException e) {
            this.logError("error %s IPv6 privacy extensions: %s", enabled ? "enabling" : "disabling", e);
            return false;
        }
        return true;
    }

    public boolean setIPv6AddrGenModeIfSupported(int mode) {
        block3: {
            try {
                this.mNetd.setIPv6AddrGenMode(this.mIfName, mode);
            }
            catch (RemoteException e) {
                this.logError("Unable to set IPv6 addrgen mode: %s", e);
                return false;
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == OsConstants.EOPNOTSUPP) break block3;
                this.logError("Unable to set IPv6 addrgen mode: %s", e);
                return false;
            }
        }
        return true;
    }

    public boolean addAddress(LinkAddress addr) {
        return this.addAddress(addr.getAddress(), addr.getPrefixLength());
    }

    public boolean addAddress(InetAddress ip, int prefixLen) {
        try {
            this.mNetd.interfaceAddAddress(this.mIfName, ip.getHostAddress(), prefixLen);
        }
        catch (RemoteException | ServiceSpecificException e) {
            this.logError("failed to add %s/%d: %s", ip, prefixLen, e);
            return false;
        }
        return true;
    }

    public boolean removeAddress(InetAddress ip, int prefixLen) {
        try {
            this.mNetd.interfaceDelAddress(this.mIfName, ip.getHostAddress(), prefixLen);
        }
        catch (RemoteException | ServiceSpecificException e) {
            this.logError("failed to remove %s/%d: %s", ip, prefixLen, e);
            return false;
        }
        return true;
    }

    public boolean clearAllAddresses() {
        try {
            this.mNetd.interfaceClearAddrs(this.mIfName);
        }
        catch (Exception e) {
            this.logError("Failed to clear addresses: %s", e);
            return false;
        }
        return true;
    }

    private void logError(String fmt, Object ... args) {
        this.mLog.e(String.format(fmt, args));
    }
}

