/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.NattKeepalivePacketData;
import android.net.ProxyInfo;
import android.net.TcpKeepalivePacketData;
import android.net.ip.IIpClient;
import android.net.shared.ProvisioningConfiguration;
import android.net.util.KeepalivePacketDataUtil;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;

public class IpClientManager {
    private final IIpClient mIpClient;
    private final String mTag;

    public IpClientManager(IIpClient ipClient, String tag) {
        this.mIpClient = ipClient;
        this.mTag = tag;
    }

    public IpClientManager(IIpClient ipClient) {
        this(ipClient, IpClientManager.class.getSimpleName());
    }

    private void log(String s, Throwable e) {
        Log.e(this.mTag, s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completedPreDhcpAction() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.completedPreDhcpAction();
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error completing PreDhcpAction", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public boolean confirmConfiguration() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.confirmConfiguration();
            return true;
        }
        catch (RemoteException e) {
            this.log("Error confirming IpClient configuration", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readPacketFilterComplete(byte[] data) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.readPacketFilterComplete(data);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error notifying IpClient of packet filter read", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.shutdown();
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error shutting down IpClient", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startProvisioning(ProvisioningConfiguration prov) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.startProvisioning(prov.toStableParcelable());
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error starting IpClient provisioning", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.stop();
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error stopping IpClient", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTcpBufferSizes(String tcpBufferSizes) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.setTcpBufferSizes(tcpBufferSizes);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error setting IpClient TCP buffer sizes", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHttpProxy(ProxyInfo proxyInfo) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.setHttpProxy(proxyInfo);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error setting IpClient proxy", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMulticastFilter(boolean enabled) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.setMulticastFilter(enabled);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error setting multicast filter", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKeepalivePacketFilter(int slot, TcpKeepalivePacketData pkt) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.addKeepalivePacketFilter(slot, pkt.toStableParcelable());
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error adding Keepalive Packet Filter ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKeepalivePacketFilter(int slot, NattKeepalivePacketData pkt) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.addNattKeepalivePacketFilter(slot, KeepalivePacketDataUtil.toStableParcelable(pkt));
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error adding Keepalive Packet Filter ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKeepalivePacketFilter(int slot) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.removeKeepalivePacketFilter(slot);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error removing Keepalive Packet Filter ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setL2KeyAndGroupHint(String l2Key, String groupHint) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mIpClient.setL2KeyAndGroupHint(l2Key, groupHint);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Failed setL2KeyAndGroupHint", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }
}

