/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.DhcpResultsParcelable;
import android.net.LinkProperties;
import android.net.NetworkStackClient;
import android.net.ip.IIpClient;
import android.net.ip.IIpClientCallbacks;
import android.net.ip.IpClientCallbacks;
import android.net.shared.IpConfigurationParcelableUtil;
import android.os.ConditionVariable;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class IpClientUtil {
    public static final String DUMP_ARG = "ipclient";

    public static void makeIpClient(Context context, String ifName, IpClientCallbacks callback) {
        NetworkStackClient.getInstance().makeIpClient(ifName, new IpClientCallbacksProxy(callback));
    }

    public static void dumpIpClient(IIpClient connector, FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("IpClient logs have moved to dumpsys network_stack");
    }

    private static class IpClientCallbacksProxy
    extends IIpClientCallbacks.Stub {
        protected final IpClientCallbacks mCb;

        public IpClientCallbacksProxy(IpClientCallbacks cb) {
            this.mCb = cb;
        }

        @Override
        public void onIpClientCreated(IIpClient ipClient) {
            this.mCb.onIpClientCreated(ipClient);
        }

        @Override
        public void onPreDhcpAction() {
            this.mCb.onPreDhcpAction();
        }

        @Override
        public void onPostDhcpAction() {
            this.mCb.onPostDhcpAction();
        }

        @Override
        public void onNewDhcpResults(DhcpResultsParcelable dhcpResults) {
            this.mCb.onNewDhcpResults(IpConfigurationParcelableUtil.fromStableParcelable(dhcpResults));
        }

        @Override
        public void onProvisioningSuccess(LinkProperties newLp) {
            this.mCb.onProvisioningSuccess(newLp);
        }

        @Override
        public void onProvisioningFailure(LinkProperties newLp) {
            this.mCb.onProvisioningFailure(newLp);
        }

        @Override
        public void onLinkPropertiesChange(LinkProperties newLp) {
            this.mCb.onLinkPropertiesChange(newLp);
        }

        @Override
        public void onReachabilityLost(String logMsg) {
            this.mCb.onReachabilityLost(logMsg);
        }

        @Override
        public void onQuit() {
            this.mCb.onQuit();
        }

        @Override
        public void installPacketFilter(byte[] filter) {
            this.mCb.installPacketFilter(filter);
        }

        @Override
        public void startReadPacketFilter() {
            this.mCb.startReadPacketFilter();
        }

        @Override
        public void setFallbackMulticastFilter(boolean enabled) {
            this.mCb.setFallbackMulticastFilter(enabled);
        }

        @Override
        public void setNeighborDiscoveryOffload(boolean enable) {
            this.mCb.setNeighborDiscoveryOffload(enable);
        }

        @Override
        public int getInterfaceVersion() {
            return 3;
        }
    }

    public static class WaitForProvisioningCallbacks
    extends IpClientCallbacks {
        private final ConditionVariable mCV = new ConditionVariable();
        private LinkProperties mCallbackLinkProperties;

        public LinkProperties waitForProvisioning() {
            this.mCV.block();
            return this.mCallbackLinkProperties;
        }

        @Override
        public void onProvisioningSuccess(LinkProperties newLp) {
            this.mCallbackLinkProperties = newLp;
            this.mCV.open();
        }

        @Override
        public void onProvisioningFailure(LinkProperties newLp) {
            this.mCallbackLinkProperties = null;
            this.mCV.open();
        }
    }
}

