/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.TrafficStats;
import android.net.util.InterfaceParams;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructTimeval;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoBridge;

public class RouterAdvertisementDaemon {
    private static final String TAG = RouterAdvertisementDaemon.class.getSimpleName();
    private static final byte ICMPV6_ND_ROUTER_SOLICIT = RouterAdvertisementDaemon.asByte(133);
    private static final byte ICMPV6_ND_ROUTER_ADVERT = RouterAdvertisementDaemon.asByte(134);
    private static final int MIN_RA_HEADER_SIZE = 16;
    private static final int MIN_RTR_ADV_INTERVAL_SEC = 300;
    private static final int MAX_RTR_ADV_INTERVAL_SEC = 600;
    private static final int DEFAULT_LIFETIME = 3600;
    private static final int MIN_DELAY_BETWEEN_RAS_SEC = 3;
    private static final int MAX_URGENT_RTR_ADVERTISEMENTS = 5;
    private static final int DAY_IN_SECONDS = 86400;
    private static final byte[] ALL_NODES = new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private final InterfaceParams mInterface;
    private final InetSocketAddress mAllNodes;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final byte[] mRA = new byte[1280];
    @GuardedBy(value={"mLock"})
    private int mRaLength;
    @GuardedBy(value={"mLock"})
    private final DeprecatedInfoTracker mDeprecatedInfoTracker;
    @GuardedBy(value={"mLock"})
    private RaParams mRaParams;
    private volatile FileDescriptor mSocket;
    private volatile MulticastTransmitter mMulticastTransmitter;
    private volatile UnicastResponder mUnicastResponder;

    public RouterAdvertisementDaemon(InterfaceParams ifParams) {
        this.mInterface = ifParams;
        this.mAllNodes = new InetSocketAddress(RouterAdvertisementDaemon.getAllNodesForScopeId(this.mInterface.index), 0);
        this.mDeprecatedInfoTracker = new DeprecatedInfoTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildNewRa(RaParams deprecatedParams, RaParams newParams) {
        Object object = this.mLock;
        synchronized (object) {
            if (deprecatedParams != null) {
                this.mDeprecatedInfoTracker.putPrefixes(deprecatedParams.prefixes);
                this.mDeprecatedInfoTracker.putDnses(deprecatedParams.dnses);
            }
            if (newParams != null) {
                this.mDeprecatedInfoTracker.removePrefixes(newParams.prefixes);
                this.mDeprecatedInfoTracker.removeDnses(newParams.dnses);
            }
            this.mRaParams = newParams;
            this.assembleRaLocked();
        }
        this.maybeNotifyMulticastTransmitter();
    }

    public boolean start() {
        if (!this.createSocket()) {
            return false;
        }
        this.mMulticastTransmitter = new MulticastTransmitter();
        this.mMulticastTransmitter.start();
        this.mUnicastResponder = new UnicastResponder();
        this.mUnicastResponder.start();
        return true;
    }

    public void stop() {
        this.closeSocket();
        this.maybeNotifyMulticastTransmitter();
        this.mMulticastTransmitter = null;
        this.mUnicastResponder = null;
    }

    @GuardedBy(value={"mLock"})
    private void assembleRaLocked() {
        ByteBuffer ra = ByteBuffer.wrap(this.mRA);
        ra.order(ByteOrder.BIG_ENDIAN);
        boolean haveRaParams = this.mRaParams != null;
        boolean shouldSendRA = false;
        try {
            RouterAdvertisementDaemon.putHeader(ra, haveRaParams && this.mRaParams.hasDefaultRoute, haveRaParams ? this.mRaParams.hopLimit : (byte)65);
            RouterAdvertisementDaemon.putSlla(ra, this.mInterface.macAddr.toByteArray());
            this.mRaLength = ra.position();
            if (haveRaParams) {
                RouterAdvertisementDaemon.putMtu(ra, this.mRaParams.mtu);
                this.mRaLength = ra.position();
                for (IpPrefix ipp : this.mRaParams.prefixes) {
                    RouterAdvertisementDaemon.putPio(ra, ipp, 3600, 3600);
                    this.mRaLength = ra.position();
                    shouldSendRA = true;
                }
                if (this.mRaParams.dnses.size() > 0) {
                    RouterAdvertisementDaemon.putRdnss(ra, this.mRaParams.dnses, 3600);
                    this.mRaLength = ra.position();
                    shouldSendRA = true;
                }
            }
            for (IpPrefix ipp : this.mDeprecatedInfoTracker.getPrefixes()) {
                RouterAdvertisementDaemon.putPio(ra, ipp, 0, 0);
                this.mRaLength = ra.position();
                shouldSendRA = true;
            }
            Set<Inet6Address> deprecatedDnses = this.mDeprecatedInfoTracker.getDnses();
            if (!deprecatedDnses.isEmpty()) {
                RouterAdvertisementDaemon.putRdnss(ra, deprecatedDnses, 0);
                this.mRaLength = ra.position();
                shouldSendRA = true;
            }
        }
        catch (BufferOverflowException e) {
            Log.e(TAG, "Could not construct new RA: " + e);
        }
        if (!shouldSendRA) {
            this.mRaLength = 0;
        }
    }

    private void maybeNotifyMulticastTransmitter() {
        MulticastTransmitter m = this.mMulticastTransmitter;
        if (m != null) {
            m.hup();
        }
    }

    private static Inet6Address getAllNodesForScopeId(int scopeId) {
        try {
            return Inet6Address.getByAddress("ff02::1", ALL_NODES, scopeId);
        }
        catch (UnknownHostException uhe) {
            Log.wtf(TAG, "Failed to construct ff02::1 InetAddress: " + uhe);
            return null;
        }
    }

    private static byte asByte(int value) {
        return (byte)value;
    }

    private static short asShort(int value) {
        return (short)value;
    }

    private static void putHeader(ByteBuffer ra, boolean hasDefaultRoute, byte hopLimit) {
        ra.put(ICMPV6_ND_ROUTER_ADVERT).put(RouterAdvertisementDaemon.asByte(0)).putShort(RouterAdvertisementDaemon.asShort(0)).put(hopLimit).put(hasDefaultRoute ? RouterAdvertisementDaemon.asByte(8) : RouterAdvertisementDaemon.asByte(0)).putShort(hasDefaultRoute ? RouterAdvertisementDaemon.asShort(3600) : RouterAdvertisementDaemon.asShort(0)).putInt(0).putInt(0);
    }

    private static void putSlla(ByteBuffer ra, byte[] slla) {
        if (slla == null || slla.length != 6) {
            return;
        }
        boolean ND_OPTION_SLLA = true;
        boolean SLLA_NUM_8OCTETS = true;
        ra.put((byte)1).put((byte)1).put(slla);
    }

    private static void putExpandedFlagsOption(ByteBuffer ra) {
        int ND_OPTION_EFO = 26;
        boolean EFO_NUM_8OCTETS = true;
        ra.put((byte)26).put((byte)1).putShort(RouterAdvertisementDaemon.asShort(0)).putInt(0);
    }

    private static void putMtu(ByteBuffer ra, int mtu) {
        int ND_OPTION_MTU = 5;
        boolean MTU_NUM_8OCTETS = true;
        ra.put((byte)5).put((byte)1).putShort(RouterAdvertisementDaemon.asShort(0)).putInt(mtu < 1280 ? 1280 : mtu);
    }

    private static void putPio(ByteBuffer ra, IpPrefix ipp, int validTime, int preferredTime) {
        int prefixLength = ipp.getPrefixLength();
        if (prefixLength != 64) {
            return;
        }
        int ND_OPTION_PIO = 3;
        int PIO_NUM_8OCTETS = 4;
        if (validTime < 0) {
            validTime = 0;
        }
        if (preferredTime < 0) {
            preferredTime = 0;
        }
        if (preferredTime > validTime) {
            preferredTime = validTime;
        }
        byte[] addr = ipp.getAddress().getAddress();
        ra.put((byte)3).put((byte)4).put(RouterAdvertisementDaemon.asByte(prefixLength)).put(RouterAdvertisementDaemon.asByte(192)).putInt(validTime).putInt(preferredTime).putInt(0).put(addr);
    }

    private static void putRio(ByteBuffer ra, IpPrefix ipp) {
        int prefixLength = ipp.getPrefixLength();
        if (prefixLength > 64) {
            return;
        }
        int ND_OPTION_RIO = 24;
        byte RIO_NUM_8OCTETS = RouterAdvertisementDaemon.asByte(prefixLength == 0 ? 1 : (prefixLength <= 8 ? 2 : 3));
        byte[] addr = ipp.getAddress().getAddress();
        ra.put((byte)24).put(RIO_NUM_8OCTETS).put(RouterAdvertisementDaemon.asByte(prefixLength)).put(RouterAdvertisementDaemon.asByte(24)).putInt(3600);
        if (prefixLength > 0) {
            ra.put(addr, 0, prefixLength <= 64 ? 8 : 16);
        }
    }

    private static void putRdnss(ByteBuffer ra, Set<Inet6Address> dnses, int lifetime) {
        HashSet<Inet6Address> filteredDnses = new HashSet<Inet6Address>();
        for (Inet6Address dns : dnses) {
            if (!new LinkAddress(dns, 64).isGlobalPreferred()) continue;
            filteredDnses.add(dns);
        }
        if (filteredDnses.isEmpty()) {
            return;
        }
        int ND_OPTION_RDNSS = 25;
        byte RDNSS_NUM_8OCTETS = RouterAdvertisementDaemon.asByte(dnses.size() * 2 + 1);
        ra.put((byte)25).put(RDNSS_NUM_8OCTETS).putShort(RouterAdvertisementDaemon.asShort(0)).putInt(lifetime);
        for (Inet6Address dns : filteredDnses) {
            ra.put(dns.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSocket() {
        int SEND_TIMEOUT_MS = 300;
        int oldTag = TrafficStats.getAndSetThreadStatsTag(-510);
        try {
            this.mSocket = Os.socket(OsConstants.AF_INET6, OsConstants.SOCK_RAW, OsConstants.IPPROTO_ICMPV6);
            Os.setsockoptTimeval(this.mSocket, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, StructTimeval.fromMillis(300L));
            Os.setsockoptIfreq(this.mSocket, OsConstants.SOL_SOCKET, OsConstants.SO_BINDTODEVICE, this.mInterface.name);
            NetworkUtils.protectFromVpn(this.mSocket);
            NetworkUtils.setupRaSocket(this.mSocket, this.mInterface.index);
        }
        catch (ErrnoException | IOException e) {
            Log.e(TAG, "Failed to create RA daemon socket: " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            TrafficStats.setThreadStatsTag(oldTag);
        }
        return true;
    }

    private void closeSocket() {
        if (this.mSocket != null) {
            try {
                IoBridge.closeAndSignalBlockedThreads(this.mSocket);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mSocket = null;
    }

    private boolean isSocketValid() {
        FileDescriptor s = this.mSocket;
        return s != null && s.valid();
    }

    private boolean isSuitableDestination(InetSocketAddress dest) {
        if (this.mAllNodes.equals(dest)) {
            return true;
        }
        InetAddress destip = dest.getAddress();
        return destip instanceof Inet6Address && destip.isLinkLocalAddress() && ((Inet6Address)destip).getScopeId() == this.mInterface.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSendRA(InetSocketAddress dest) {
        block7: {
            if (dest == null || !this.isSuitableDestination(dest)) {
                dest = this.mAllNodes;
            }
            try {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mRaLength < 16) {
                        return;
                    }
                    Os.sendto(this.mSocket, this.mRA, 0, this.mRaLength, 0, dest);
                }
                Log.d(TAG, "RA sendto " + dest.getAddress().getHostAddress());
            }
            catch (ErrnoException | SocketException e) {
                if (!this.isSocketValid()) break block7;
                Log.e(TAG, "sendto error: " + e);
            }
        }
    }

    private final class MulticastTransmitter
    extends Thread {
        private final Random mRandom = new Random();
        private final AtomicInteger mUrgentAnnouncements = new AtomicInteger(0);

        private MulticastTransmitter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (RouterAdvertisementDaemon.this.isSocketValid()) {
                try {
                    Thread.sleep(this.getNextMulticastTransmitDelayMs());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RouterAdvertisementDaemon.this.maybeSendRA(RouterAdvertisementDaemon.this.mAllNodes);
                Object object = RouterAdvertisementDaemon.this.mLock;
                synchronized (object) {
                    if (RouterAdvertisementDaemon.this.mDeprecatedInfoTracker.decrementCounters()) {
                        RouterAdvertisementDaemon.this.assembleRaLocked();
                    }
                }
            }
        }

        public void hup() {
            this.mUrgentAnnouncements.set(4);
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getNextMulticastTransmitDelaySec() {
            boolean deprecationInProgress = false;
            Object object = RouterAdvertisementDaemon.this.mLock;
            synchronized (object) {
                if (RouterAdvertisementDaemon.this.mRaLength < 16) {
                    return 86400;
                }
                deprecationInProgress = !RouterAdvertisementDaemon.this.mDeprecatedInfoTracker.isEmpty();
            }
            int urgentPending = this.mUrgentAnnouncements.getAndDecrement();
            if (urgentPending > 0 || deprecationInProgress) {
                return 3;
            }
            return 300 + this.mRandom.nextInt(300);
        }

        private long getNextMulticastTransmitDelayMs() {
            return 1000L * (long)this.getNextMulticastTransmitDelaySec();
        }
    }

    private final class UnicastResponder
    extends Thread {
        private final InetSocketAddress solicitor = new InetSocketAddress();
        private final byte[] mSolication = new byte[1280];

        private UnicastResponder() {
        }

        @Override
        public void run() {
            while (RouterAdvertisementDaemon.this.isSocketValid()) {
                block4: {
                    try {
                        int rval = Os.recvfrom(RouterAdvertisementDaemon.this.mSocket, this.mSolication, 0, this.mSolication.length, 0, this.solicitor);
                        if (rval < 1) continue;
                        if (this.mSolication[0] != ICMPV6_ND_ROUTER_SOLICIT) {
                        }
                        break block4;
                    }
                    catch (ErrnoException | SocketException e) {
                        if (!RouterAdvertisementDaemon.this.isSocketValid()) continue;
                        Log.e(TAG, "recvfrom error: " + e);
                    }
                    continue;
                }
                RouterAdvertisementDaemon.this.maybeSendRA(this.solicitor);
            }
        }
    }

    private static class DeprecatedInfoTracker {
        private final HashMap<IpPrefix, Integer> mPrefixes = new HashMap();
        private final HashMap<Inet6Address, Integer> mDnses = new HashMap();

        private DeprecatedInfoTracker() {
        }

        Set<IpPrefix> getPrefixes() {
            return this.mPrefixes.keySet();
        }

        void putPrefixes(Set<IpPrefix> prefixes) {
            for (IpPrefix ipp : prefixes) {
                this.mPrefixes.put(ipp, 5);
            }
        }

        void removePrefixes(Set<IpPrefix> prefixes) {
            for (IpPrefix ipp : prefixes) {
                this.mPrefixes.remove(ipp);
            }
        }

        Set<Inet6Address> getDnses() {
            return this.mDnses.keySet();
        }

        void putDnses(Set<Inet6Address> dnses) {
            for (Inet6Address dns : dnses) {
                this.mDnses.put(dns, 5);
            }
        }

        void removeDnses(Set<Inet6Address> dnses) {
            for (Inet6Address dns : dnses) {
                this.mDnses.remove(dns);
            }
        }

        boolean isEmpty() {
            return this.mPrefixes.isEmpty() && this.mDnses.isEmpty();
        }

        private boolean decrementCounters() {
            boolean removed = this.decrementCounter(this.mPrefixes);
            return removed |= this.decrementCounter(this.mDnses);
        }

        private <T> boolean decrementCounter(HashMap<T, Integer> map) {
            boolean removed = false;
            Iterator<Map.Entry<T, Integer>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<T, Integer> kv = it.next();
                if (kv.getValue() == 0) {
                    it.remove();
                    removed = true;
                    continue;
                }
                kv.setValue(kv.getValue() - 1);
            }
            return removed;
        }
    }

    public static class RaParams {
        static final byte DEFAULT_HOPLIMIT = 65;
        public boolean hasDefaultRoute;
        public byte hopLimit;
        public int mtu;
        public HashSet<IpPrefix> prefixes;
        public HashSet<Inet6Address> dnses;

        public RaParams() {
            this.hasDefaultRoute = false;
            this.hopLimit = (byte)65;
            this.mtu = 1280;
            this.prefixes = new HashSet();
            this.dnses = new HashSet();
        }

        public RaParams(RaParams other) {
            this.hasDefaultRoute = other.hasDefaultRoute;
            this.hopLimit = other.hopLimit;
            this.mtu = other.mtu;
            this.prefixes = (HashSet)other.prefixes.clone();
            this.dnses = (HashSet)other.dnses.clone();
        }

        public static RaParams getDeprecatedRaParams(RaParams oldRa, RaParams newRa) {
            RaParams newlyDeprecated = new RaParams();
            if (oldRa != null) {
                for (IpPrefix ipp : oldRa.prefixes) {
                    if (newRa != null && newRa.prefixes.contains(ipp)) continue;
                    newlyDeprecated.prefixes.add(ipp);
                }
                for (Inet6Address dns : oldRa.dnses) {
                    if (newRa != null && newRa.dnses.contains(dns)) continue;
                    newlyDeprecated.dnses.add(dns);
                }
            }
            return newlyDeprecated;
        }
    }
}

