/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipmemorystore;

import android.net.ipmemorystore.StatusParcelable;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IOnL2KeyResponseListener
extends IInterface {
    public static final int VERSION = 3;

    public void onL2KeyResponse(StatusParcelable var1, String var2) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOnL2KeyResponseListener {
        private static final String DESCRIPTOR = "android.net.ipmemorystore.IOnL2KeyResponseListener";
        static final int TRANSACTION_onL2KeyResponse = 1;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IOnL2KeyResponseListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IOnL2KeyResponseListener) {
                return (IOnL2KeyResponseListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    StatusParcelable _arg0 = 0 != data.readInt() ? StatusParcelable.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.onL2KeyResponse(_arg0, _arg1);
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IOnL2KeyResponseListener impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IOnL2KeyResponseListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IOnL2KeyResponseListener {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            public static IOnL2KeyResponseListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onL2KeyResponse(StatusParcelable status, String l2Key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (status != null) {
                        _data.writeInt(1);
                        status.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(l2Key);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onL2KeyResponse(status, l2Key);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(Stub.DESCRIPTOR);
                        this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }
        }
    }

    public static class Default
    implements IOnL2KeyResponseListener {
        @Override
        public void onL2KeyResponse(StatusParcelable status, String l2Key) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return -1;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

