/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipmemorystore;

import android.net.ipmemorystore.Blob;
import android.net.ipmemorystore.NetworkAttributesParcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class NetworkAttributes {
    private static final boolean DBG = true;
    private static final float TOTAL_WEIGHT_CUTOFF = 520.0f;
    private static final float NULL_MATCH_WEIGHT = 0.25f;
    public final Inet4Address assignedV4Address;
    private static final float WEIGHT_ASSIGNEDV4ADDR = 300.0f;
    public final Long assignedV4AddressExpiry;
    private static final float WEIGHT_ASSIGNEDV4ADDREXPIRY = 0.0f;
    public final String groupHint;
    private static final float WEIGHT_GROUPHINT = 300.0f;
    public final List<InetAddress> dnsAddresses;
    private static final float WEIGHT_DNSADDRESSES = 200.0f;
    public final Integer mtu;
    private static final float WEIGHT_MTU = 50.0f;
    @VisibleForTesting
    public static final float TOTAL_WEIGHT = 850.0f;

    @VisibleForTesting
    public NetworkAttributes(Inet4Address assignedV4Address, Long assignedV4AddressExpiry, String groupHint, List<InetAddress> dnsAddresses, Integer mtu) {
        if (mtu != null && mtu < 0) {
            throw new IllegalArgumentException("MTU can't be negative");
        }
        if (assignedV4AddressExpiry != null && assignedV4AddressExpiry <= 0L) {
            throw new IllegalArgumentException("lease expiry can't be negative or zero");
        }
        this.assignedV4Address = assignedV4Address;
        this.assignedV4AddressExpiry = assignedV4AddressExpiry;
        this.groupHint = groupHint;
        this.dnsAddresses = null == dnsAddresses ? null : Collections.unmodifiableList(new ArrayList<InetAddress>(dnsAddresses));
        this.mtu = mtu;
    }

    @VisibleForTesting
    public NetworkAttributes(NetworkAttributesParcelable parcelable) {
        this((Inet4Address)NetworkAttributes.getByAddressOrNull(parcelable.assignedV4Address), parcelable.assignedV4AddressExpiry > 0L ? Long.valueOf(parcelable.assignedV4AddressExpiry) : null, parcelable.groupHint, NetworkAttributes.blobArrayToInetAddressList(parcelable.dnsAddresses), parcelable.mtu >= 0 ? Integer.valueOf(parcelable.mtu) : null);
    }

    private static InetAddress getByAddressOrNull(byte[] address) {
        if (null == address) {
            return null;
        }
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static List<InetAddress> blobArrayToInetAddressList(Blob[] blobs) {
        if (null == blobs) {
            return null;
        }
        ArrayList<InetAddress> list = new ArrayList<InetAddress>(blobs.length);
        for (Blob b : blobs) {
            InetAddress addr = NetworkAttributes.getByAddressOrNull(b.data);
            if (null == addr) continue;
            list.add(addr);
        }
        return list;
    }

    private static Blob[] inetAddressListToBlobArray(List<InetAddress> addresses) {
        if (null == addresses) {
            return null;
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (int i = 0; i < addresses.size(); ++i) {
            InetAddress addr = addresses.get(i);
            if (null == addr) continue;
            Blob b = new Blob();
            b.data = addr.getAddress();
            blobs.add(b);
        }
        return blobs.toArray(new Blob[0]);
    }

    public NetworkAttributesParcelable toParcelable() {
        NetworkAttributesParcelable parcelable = new NetworkAttributesParcelable();
        parcelable.assignedV4Address = null == this.assignedV4Address ? null : this.assignedV4Address.getAddress();
        parcelable.assignedV4AddressExpiry = null == this.assignedV4AddressExpiry ? 0L : this.assignedV4AddressExpiry;
        parcelable.groupHint = this.groupHint;
        parcelable.dnsAddresses = NetworkAttributes.inetAddressListToBlobArray(this.dnsAddresses);
        parcelable.mtu = null == this.mtu ? -1 : this.mtu;
        return parcelable;
    }

    private float samenessContribution(float weight, Object o1, Object o2) {
        if (null == o1) {
            return null == o2 ? weight * 0.25f : 0.0f;
        }
        return Objects.equals(o1, o2) ? weight : 0.0f;
    }

    public float getNetworkGroupSamenessConfidence(NetworkAttributes o) {
        float samenessScore = this.samenessContribution(300.0f, this.assignedV4Address, o.assignedV4Address) + this.samenessContribution(0.0f, this.assignedV4AddressExpiry, o.assignedV4AddressExpiry) + this.samenessContribution(300.0f, this.groupHint, o.groupHint) + this.samenessContribution(200.0f, this.dnsAddresses, o.dnsAddresses) + this.samenessContribution(50.0f, this.mtu, o.mtu);
        if (samenessScore < 520.0f) {
            return samenessScore / 1040.0f;
        }
        return (samenessScore - 520.0f) / 330.0f / 2.0f + 0.5f;
    }

    public boolean isEmpty() {
        return null == this.assignedV4Address && null == this.assignedV4AddressExpiry && null == this.groupHint && null == this.dnsAddresses && null == this.mtu;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NetworkAttributes)) {
            return false;
        }
        NetworkAttributes other = (NetworkAttributes)o;
        return Objects.equals(this.assignedV4Address, other.assignedV4Address) && Objects.equals(this.assignedV4AddressExpiry, other.assignedV4AddressExpiry) && Objects.equals(this.groupHint, other.groupHint) && Objects.equals(this.dnsAddresses, other.dnsAddresses) && Objects.equals(this.mtu, other.mtu);
    }

    public int hashCode() {
        return Objects.hash(this.assignedV4Address, this.assignedV4AddressExpiry, this.groupHint, this.dnsAddresses, this.mtu);
    }

    public String toString() {
        StringJoiner resultJoiner = new StringJoiner(" ", "{", "}");
        ArrayList<String> nullFields = new ArrayList<String>();
        if (null != this.assignedV4Address) {
            resultJoiner.add("assignedV4Addr :");
            resultJoiner.add(this.assignedV4Address.toString());
        } else {
            nullFields.add("assignedV4Addr");
        }
        if (null != this.assignedV4AddressExpiry) {
            resultJoiner.add("assignedV4AddressExpiry :");
            resultJoiner.add(this.assignedV4AddressExpiry.toString());
        } else {
            nullFields.add("assignedV4AddressExpiry");
        }
        if (null != this.groupHint) {
            resultJoiner.add("groupHint :");
            resultJoiner.add(this.groupHint);
        } else {
            nullFields.add("groupHint");
        }
        if (null != this.dnsAddresses) {
            resultJoiner.add("dnsAddr : [");
            for (InetAddress addr : this.dnsAddresses) {
                resultJoiner.add(addr.getHostAddress());
            }
            resultJoiner.add("]");
        } else {
            nullFields.add("dnsAddr");
        }
        if (null != this.mtu) {
            resultJoiner.add("mtu :");
            resultJoiner.add(this.mtu.toString());
        } else {
            nullFields.add("mtu");
        }
        if (!nullFields.isEmpty()) {
            resultJoiner.add("; Null fields : [");
            for (String field : nullFields) {
                resultJoiner.add(field);
            }
            resultJoiner.add("]");
        }
        return resultJoiner.toString();
    }

    public static class Builder {
        private Inet4Address mAssignedAddress;
        private Long mAssignedAddressExpiry;
        private String mGroupHint;
        private List<InetAddress> mDnsAddresses;
        private Integer mMtu;

        public Builder setAssignedV4Address(Inet4Address assignedV4Address) {
            this.mAssignedAddress = assignedV4Address;
            return this;
        }

        public Builder setAssignedV4AddressExpiry(Long assignedV4AddressExpiry) {
            if (null != assignedV4AddressExpiry && assignedV4AddressExpiry <= 0L) {
                throw new IllegalArgumentException("lease expiry can't be negative or zero");
            }
            this.mAssignedAddressExpiry = assignedV4AddressExpiry;
            return this;
        }

        public Builder setGroupHint(String groupHint) {
            this.mGroupHint = groupHint;
            return this;
        }

        public Builder setDnsAddresses(List<InetAddress> dnsAddresses) {
            if (null != dnsAddresses) {
                for (InetAddress address : dnsAddresses) {
                    if (null != address) continue;
                    throw new IllegalArgumentException("Null DNS address");
                }
            }
            this.mDnsAddresses = dnsAddresses;
            return this;
        }

        public Builder setMtu(Integer mtu) {
            if (null != mtu && mtu < 0) {
                throw new IllegalArgumentException("MTU can't be negative");
            }
            this.mMtu = mtu;
            return this;
        }

        public NetworkAttributes build() {
            return new NetworkAttributes(this.mAssignedAddress, this.mAssignedAddressExpiry, this.mGroupHint, this.mDnsAddresses, this.mMtu);
        }
    }
}

