/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.net.metrics.IpConnectivityLog;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.util.MessageUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.BitSet;

@SystemApi
public final class ApfProgramEvent
implements IpConnectivityLog.Event {
    public static final int FLAG_MULTICAST_FILTER_ON = 0;
    public static final int FLAG_HAS_IPV4_ADDRESS = 1;
    @UnsupportedAppUsage
    public final long lifetime;
    @UnsupportedAppUsage
    public final long actualLifetime;
    @UnsupportedAppUsage
    public final int filteredRas;
    @UnsupportedAppUsage
    public final int currentRas;
    @UnsupportedAppUsage
    public final int programLength;
    @UnsupportedAppUsage
    public final int flags;
    public static final Parcelable.Creator<ApfProgramEvent> CREATOR = new Parcelable.Creator<ApfProgramEvent>(){

        @Override
        public ApfProgramEvent createFromParcel(Parcel in) {
            return new ApfProgramEvent(in);
        }

        public ApfProgramEvent[] newArray(int size) {
            return new ApfProgramEvent[size];
        }
    };

    private ApfProgramEvent(long lifetime, long actualLifetime, int filteredRas, int currentRas, int programLength, int flags) {
        this.lifetime = lifetime;
        this.actualLifetime = actualLifetime;
        this.filteredRas = filteredRas;
        this.currentRas = currentRas;
        this.programLength = programLength;
        this.flags = flags;
    }

    private ApfProgramEvent(Parcel in) {
        this.lifetime = in.readLong();
        this.actualLifetime = in.readLong();
        this.filteredRas = in.readInt();
        this.currentRas = in.readInt();
        this.programLength = in.readInt();
        this.flags = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.lifetime);
        out.writeLong(this.actualLifetime);
        out.writeInt(this.filteredRas);
        out.writeInt(this.currentRas);
        out.writeInt(this.programLength);
        out.writeInt(this.flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String lifetimeString = this.lifetime < Long.MAX_VALUE ? this.lifetime + "s" : "forever";
        return String.format("ApfProgramEvent(%d/%d RAs %dB %ds/%s %s)", this.filteredRas, this.currentRas, this.programLength, this.actualLifetime, lifetimeString, ApfProgramEvent.namesOf(this.flags));
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(ApfProgramEvent.class)) {
            return false;
        }
        ApfProgramEvent other = (ApfProgramEvent)obj;
        return this.lifetime == other.lifetime && this.actualLifetime == other.actualLifetime && this.filteredRas == other.filteredRas && this.currentRas == other.currentRas && this.programLength == other.programLength && this.flags == other.flags;
    }

    @UnsupportedAppUsage
    public static int flagsFor(boolean hasIPv4, boolean multicastFilterOn) {
        int bitfield = 0;
        if (hasIPv4) {
            bitfield |= 2;
        }
        if (multicastFilterOn) {
            bitfield |= 1;
        }
        return bitfield;
    }

    private static String namesOf(int bitfield) {
        ArrayList<String> names = new ArrayList<String>(Integer.bitCount(bitfield));
        BitSet set = BitSet.valueOf(new long[]{bitfield & Integer.MAX_VALUE});
        int bit = set.nextSetBit(0);
        while (bit >= 0) {
            names.add(Decoder.constants.get(bit));
            bit = set.nextSetBit(bit + 1);
        }
        return TextUtils.join((CharSequence)"|", names);
    }

    static final class Decoder {
        static final SparseArray<String> constants = MessageUtils.findMessageNames(new Class[]{ApfProgramEvent.class}, new String[]{"FLAG_"});

        Decoder() {
        }
    }

    public static final class Builder {
        private long mLifetime;
        private long mActualLifetime;
        private int mFilteredRas;
        private int mCurrentRas;
        private int mProgramLength;
        private int mFlags;

        public Builder setLifetime(long lifetime) {
            this.mLifetime = lifetime;
            return this;
        }

        public Builder setActualLifetime(long lifetime) {
            this.mActualLifetime = lifetime;
            return this;
        }

        public Builder setFilteredRas(int filteredRas) {
            this.mFilteredRas = filteredRas;
            return this;
        }

        public Builder setCurrentRas(int currentRas) {
            this.mCurrentRas = currentRas;
            return this;
        }

        public Builder setProgramLength(int programLength) {
            this.mProgramLength = programLength;
            return this;
        }

        public Builder setFlags(boolean hasIPv4, boolean multicastFilterOn) {
            this.mFlags = ApfProgramEvent.flagsFor(hasIPv4, multicastFilterOn);
            return this;
        }

        public ApfProgramEvent build() {
            return new ApfProgramEvent(this.mLifetime, this.mActualLifetime, this.mFilteredRas, this.mCurrentRas, this.mProgramLength, this.mFlags);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

