/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.net.metrics.IpConnectivityLog;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

@SystemApi
public final class DhcpClientEvent
implements IpConnectivityLog.Event {
    public final String msg;
    public final int durationMs;
    public static final Parcelable.Creator<DhcpClientEvent> CREATOR = new Parcelable.Creator<DhcpClientEvent>(){

        @Override
        public DhcpClientEvent createFromParcel(Parcel in) {
            return new DhcpClientEvent(in);
        }

        public DhcpClientEvent[] newArray(int size) {
            return new DhcpClientEvent[size];
        }
    };

    @UnsupportedAppUsage
    private DhcpClientEvent(String msg, int durationMs) {
        this.msg = msg;
        this.durationMs = durationMs;
    }

    private DhcpClientEvent(Parcel in) {
        this.msg = in.readString();
        this.durationMs = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.msg);
        out.writeInt(this.durationMs);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return String.format("DhcpClientEvent(%s, %dms)", this.msg, this.durationMs);
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(DhcpClientEvent.class)) {
            return false;
        }
        DhcpClientEvent other = (DhcpClientEvent)obj;
        return TextUtils.equals(this.msg, other.msg) && this.durationMs == other.durationMs;
    }

    public static final class Builder {
        private String mMsg;
        private int mDurationMs;

        public Builder setMsg(String msg) {
            this.mMsg = msg;
            return this;
        }

        public Builder setDurationMs(int durationMs) {
            this.mDurationMs = durationMs;
            return this;
        }

        public DhcpClientEvent build() {
            return new DhcpClientEvent(this.mMsg, this.mDurationMs);
        }
    }
}

