/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.annotation.SystemApi;
import android.net.metrics.IpConnectivityLog;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.android.internal.util.MessageUtils;

@SystemApi
public final class DhcpErrorEvent
implements IpConnectivityLog.Event {
    public static final int L2_ERROR = 1;
    public static final int L3_ERROR = 2;
    public static final int L4_ERROR = 3;
    public static final int DHCP_ERROR = 4;
    public static final int MISC_ERROR = 5;
    public final int errorCode;
    private static final int L2_ERROR_TYPE = 256;
    private static final int L3_ERROR_TYPE = 512;
    private static final int L4_ERROR_TYPE = 768;
    private static final int DHCP_ERROR_TYPE = 1024;
    private static final int MISC_ERROR_TYPE = 1280;
    public static final int L2_TOO_SHORT = 0x1010000;
    public static final int L2_WRONG_ETH_TYPE = 0x1020000;
    public static final int L3_TOO_SHORT = 0x2010000;
    public static final int L3_NOT_IPV4 = 0x2020000;
    public static final int L3_INVALID_IP = 0x2030000;
    public static final int L4_NOT_UDP = 0x3010000;
    public static final int L4_WRONG_PORT = 0x3020000;
    public static final int BOOTP_TOO_SHORT = 0x4010000;
    public static final int DHCP_BAD_MAGIC_COOKIE = 0x4020000;
    public static final int DHCP_INVALID_OPTION_LENGTH = 0x4030000;
    public static final int DHCP_NO_MSG_TYPE = 0x4040000;
    public static final int DHCP_UNKNOWN_MSG_TYPE = 0x4050000;
    public static final int DHCP_NO_COOKIE = 0x4060000;
    public static final int BUFFER_UNDERFLOW = 0x5010000;
    public static final int RECEIVE_ERROR = 0x5020000;
    public static final int PARSING_ERROR = 0x5030000;
    public static final Parcelable.Creator<DhcpErrorEvent> CREATOR = new Parcelable.Creator<DhcpErrorEvent>(){

        @Override
        public DhcpErrorEvent createFromParcel(Parcel in) {
            return new DhcpErrorEvent(in);
        }

        public DhcpErrorEvent[] newArray(int size) {
            return new DhcpErrorEvent[size];
        }
    };

    public DhcpErrorEvent(int errorCode) {
        this.errorCode = errorCode;
    }

    private DhcpErrorEvent(Parcel in) {
        this.errorCode = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.errorCode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static int errorCodeWithOption(int errorCode, int option) {
        return 0xFFFF0000 & errorCode | 0xFF & option;
    }

    public String toString() {
        return String.format("DhcpErrorEvent(%s)", Decoder.constants.get(this.errorCode));
    }

    static final class Decoder {
        static final SparseArray<String> constants = MessageUtils.findMessageNames(new Class[]{DhcpErrorEvent.class}, new String[]{"L2_", "L3_", "L4_", "BOOTP_", "DHCP_", "BUFFER_", "RECEIVE_", "PARSING_"});

        Decoder() {
        }
    }
}

