/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.metrics.WakeupEvent;
import android.os.SystemClock;
import android.util.SparseIntArray;
import java.util.StringJoiner;

public class WakeupStats {
    private static final int NO_UID = -1;
    public final long creationTimeMs = SystemClock.elapsedRealtime();
    public final String iface;
    public long totalWakeups = 0L;
    public long rootWakeups = 0L;
    public long systemWakeups = 0L;
    public long nonApplicationWakeups = 0L;
    public long applicationWakeups = 0L;
    public long noUidWakeups = 0L;
    public long durationSec = 0L;
    public long l2UnicastCount = 0L;
    public long l2MulticastCount = 0L;
    public long l2BroadcastCount = 0L;
    public final SparseIntArray ethertypes = new SparseIntArray();
    public final SparseIntArray ipNextHeaders = new SparseIntArray();

    public WakeupStats(String iface) {
        this.iface = iface;
    }

    public void updateDuration() {
        this.durationSec = (SystemClock.elapsedRealtime() - this.creationTimeMs) / 1000L;
    }

    public void countEvent(WakeupEvent ev) {
        ++this.totalWakeups;
        switch (ev.uid) {
            case 0: {
                ++this.rootWakeups;
                break;
            }
            case 1000: {
                ++this.systemWakeups;
                break;
            }
            case -1: {
                ++this.noUidWakeups;
                break;
            }
            default: {
                if (ev.uid >= 10000) {
                    ++this.applicationWakeups;
                    break;
                }
                ++this.nonApplicationWakeups;
            }
        }
        switch (ev.dstHwAddr.getAddressType()) {
            case 1: {
                ++this.l2UnicastCount;
                break;
            }
            case 2: {
                ++this.l2MulticastCount;
                break;
            }
            case 3: {
                ++this.l2BroadcastCount;
                break;
            }
        }
        WakeupStats.increment(this.ethertypes, ev.ethertype);
        if (ev.ipNextHeader >= 0) {
            WakeupStats.increment(this.ipNextHeaders, ev.ipNextHeader);
        }
    }

    public String toString() {
        int count;
        int i;
        this.updateDuration();
        StringJoiner j = new StringJoiner(", ", "WakeupStats(", ")");
        j.add(this.iface);
        j.add("" + this.durationSec + "s");
        j.add("total: " + this.totalWakeups);
        j.add("root: " + this.rootWakeups);
        j.add("system: " + this.systemWakeups);
        j.add("apps: " + this.applicationWakeups);
        j.add("non-apps: " + this.nonApplicationWakeups);
        j.add("no uid: " + this.noUidWakeups);
        j.add(String.format("l2 unicast/multicast/broadcast: %d/%d/%d", this.l2UnicastCount, this.l2MulticastCount, this.l2BroadcastCount));
        for (i = 0; i < this.ethertypes.size(); ++i) {
            int eth = this.ethertypes.keyAt(i);
            count = this.ethertypes.valueAt(i);
            j.add(String.format("ethertype 0x%x: %d", eth, count));
        }
        for (i = 0; i < this.ipNextHeaders.size(); ++i) {
            int proto = this.ipNextHeaders.keyAt(i);
            count = this.ipNextHeaders.valueAt(i);
            j.add(String.format("ipNxtHdr %d: %d", proto, count));
        }
        return j.toString();
    }

    private static void increment(SparseIntArray counters, int key) {
        int newcount = counters.get(key, 0) + 1;
        counters.put(key, newcount);
    }
}

