/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkMessage;
import android.net.netlink.NetlinkSocket;
import android.net.netlink.StructInetDiagMsg;
import android.net.netlink.StructInetDiagReqV2;
import android.net.netlink.StructNlMsgHdr;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class InetDiagMessage
extends NetlinkMessage {
    public static final String TAG = "InetDiagMessage";
    private static final int TIMEOUT_MS = 500;
    public StructInetDiagMsg mStructInetDiagMsg = new StructInetDiagMsg();
    private static final int[] FAMILY = new int[]{OsConstants.AF_INET6, OsConstants.AF_INET};

    public static byte[] InetDiagReqV2(int protocol, InetSocketAddress local, InetSocketAddress remote, int family, short flags) {
        byte[] bytes = new byte[72];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        StructNlMsgHdr nlMsgHdr = new StructNlMsgHdr();
        nlMsgHdr.nlmsg_len = bytes.length;
        nlMsgHdr.nlmsg_type = (short)20;
        nlMsgHdr.nlmsg_flags = flags;
        nlMsgHdr.pack(byteBuffer);
        StructInetDiagReqV2 inetDiagReqV2 = new StructInetDiagReqV2(protocol, local, remote, family);
        inetDiagReqV2.pack(byteBuffer);
        return bytes;
    }

    private InetDiagMessage(StructNlMsgHdr header) {
        super(header);
    }

    public static InetDiagMessage parse(StructNlMsgHdr header, ByteBuffer byteBuffer) {
        InetDiagMessage msg = new InetDiagMessage(header);
        msg.mStructInetDiagMsg = StructInetDiagMsg.parse(byteBuffer);
        return msg;
    }

    private static int lookupUidByFamily(int protocol, InetSocketAddress local, InetSocketAddress remote, int family, short flags, FileDescriptor fd) throws ErrnoException, InterruptedIOException {
        byte[] msg = InetDiagMessage.InetDiagReqV2(protocol, local, remote, family, flags);
        NetlinkSocket.sendMessage(fd, msg, 0, msg.length, 500L);
        ByteBuffer response = NetlinkSocket.recvMessage(fd, 8192, 500L);
        NetlinkMessage nlMsg = NetlinkMessage.parse(response);
        StructNlMsgHdr hdr = nlMsg.getHeader();
        if (hdr.nlmsg_type == 3) {
            return -1;
        }
        if (nlMsg instanceof InetDiagMessage) {
            return ((InetDiagMessage)nlMsg).mStructInetDiagMsg.idiag_uid;
        }
        return -1;
    }

    private static int lookupUid(int protocol, InetSocketAddress local, InetSocketAddress remote, FileDescriptor fd) throws ErrnoException, InterruptedIOException {
        int uid;
        for (int family : FAMILY) {
            uid = protocol == OsConstants.IPPROTO_UDP ? InetDiagMessage.lookupUidByFamily(protocol, remote, local, family, (short)1, fd) : InetDiagMessage.lookupUidByFamily(protocol, local, remote, family, (short)1, fd);
            if (uid == -1) continue;
            return uid;
        }
        if (protocol == OsConstants.IPPROTO_UDP) {
            try {
                InetSocketAddress wildcard = new InetSocketAddress(Inet6Address.getByName("::"), 0);
                uid = InetDiagMessage.lookupUidByFamily(protocol, local, wildcard, OsConstants.AF_INET6, (short)769, fd);
                if (uid != -1) {
                    return uid;
                }
                wildcard = new InetSocketAddress(Inet4Address.getByName("0.0.0.0"), 0);
                uid = InetDiagMessage.lookupUidByFamily(protocol, local, wildcard, OsConstants.AF_INET, (short)769, fd);
                if (uid != -1) {
                    return uid;
                }
            }
            catch (UnknownHostException e) {
                Log.e(TAG, e.toString());
            }
        }
        return -1;
    }

    public static int getConnectionOwnerUid(int protocol, InetSocketAddress local, InetSocketAddress remote) {
        try {
            FileDescriptor fd = NetlinkSocket.forProto(OsConstants.NETLINK_INET_DIAG);
            NetlinkSocket.connectToKernel(fd);
            return InetDiagMessage.lookupUid(protocol, local, remote, fd);
        }
        catch (ErrnoException | InterruptedIOException | IllegalArgumentException | SocketException e) {
            Log.e(TAG, e.toString());
            return -1;
        }
    }

    @Override
    public String toString() {
        return "InetDiagMessage{ nlmsghdr{" + (this.mHeader == null ? "" : this.mHeader.toString()) + "}, inet_diag_msg{" + (this.mStructInetDiagMsg == null ? "" : this.mStructInetDiagMsg.toString()) + "} }";
    }
}

