/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkMessage;
import android.net.netlink.StructNdMsg;
import android.net.netlink.StructNdaCacheInfo;
import android.net.netlink.StructNlAttr;
import android.net.netlink.StructNlMsgHdr;
import android.system.OsConstants;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RtNetlinkNeighborMessage
extends NetlinkMessage {
    public static final short NDA_UNSPEC = 0;
    public static final short NDA_DST = 1;
    public static final short NDA_LLADDR = 2;
    public static final short NDA_CACHEINFO = 3;
    public static final short NDA_PROBES = 4;
    public static final short NDA_VLAN = 5;
    public static final short NDA_PORT = 6;
    public static final short NDA_VNI = 7;
    public static final short NDA_IFINDEX = 8;
    public static final short NDA_MASTER = 9;
    private StructNdMsg mNdmsg = null;
    private InetAddress mDestination = null;
    private byte[] mLinkLayerAddr = null;
    private int mNumProbes = 0;
    private StructNdaCacheInfo mCacheInfo = null;

    private static StructNlAttr findNextAttrOfType(short attrType, ByteBuffer byteBuffer) {
        StructNlAttr nlAttr;
        while (byteBuffer != null && byteBuffer.remaining() > 0 && (nlAttr = StructNlAttr.peek(byteBuffer)) != null) {
            if (nlAttr.nla_type == attrType) {
                return StructNlAttr.parse(byteBuffer);
            }
            if (byteBuffer.remaining() < nlAttr.getAlignedLength()) break;
            byteBuffer.position(byteBuffer.position() + nlAttr.getAlignedLength());
        }
        return null;
    }

    public static RtNetlinkNeighborMessage parse(StructNlMsgHdr header, ByteBuffer byteBuffer) {
        RtNetlinkNeighborMessage neighMsg = new RtNetlinkNeighborMessage(header);
        neighMsg.mNdmsg = StructNdMsg.parse(byteBuffer);
        if (neighMsg.mNdmsg == null) {
            return null;
        }
        int baseOffset = byteBuffer.position();
        StructNlAttr nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)1, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mDestination = nlAttr.getValueAsInetAddress();
        }
        byteBuffer.position(baseOffset);
        nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)2, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mLinkLayerAddr = nlAttr.nla_value;
        }
        byteBuffer.position(baseOffset);
        nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)4, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mNumProbes = nlAttr.getValueAsInt(0);
        }
        byteBuffer.position(baseOffset);
        nlAttr = RtNetlinkNeighborMessage.findNextAttrOfType((short)3, byteBuffer);
        if (nlAttr != null) {
            neighMsg.mCacheInfo = StructNdaCacheInfo.parse(nlAttr.getValueAsByteBuffer());
        }
        int kMinConsumed = 28;
        int kAdditionalSpace = NetlinkConstants.alignedLengthOf(neighMsg.mHeader.nlmsg_len - 28);
        if (byteBuffer.remaining() < kAdditionalSpace) {
            byteBuffer.position(byteBuffer.limit());
        } else {
            byteBuffer.position(baseOffset + kAdditionalSpace);
        }
        return neighMsg;
    }

    public static byte[] newGetNeighborsRequest(int seqNo) {
        int length = 28;
        byte[] bytes = new byte[28];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        StructNlMsgHdr nlmsghdr = new StructNlMsgHdr();
        nlmsghdr.nlmsg_len = 28;
        nlmsghdr.nlmsg_type = (short)30;
        nlmsghdr.nlmsg_flags = (short)769;
        nlmsghdr.nlmsg_seq = seqNo;
        nlmsghdr.pack(byteBuffer);
        StructNdMsg ndmsg = new StructNdMsg();
        ndmsg.pack(byteBuffer);
        return bytes;
    }

    public static byte[] newNewNeighborMessage(int seqNo, InetAddress ip, short nudState, int ifIndex, byte[] llAddr) {
        StructNlMsgHdr nlmsghdr = new StructNlMsgHdr();
        nlmsghdr.nlmsg_type = (short)28;
        nlmsghdr.nlmsg_flags = (short)261;
        nlmsghdr.nlmsg_seq = seqNo;
        RtNetlinkNeighborMessage msg = new RtNetlinkNeighborMessage(nlmsghdr);
        (msg.mNdmsg = new StructNdMsg()).ndm_family = (byte)(ip instanceof Inet6Address ? OsConstants.AF_INET6 : OsConstants.AF_INET);
        msg.mNdmsg.ndm_ifindex = ifIndex;
        msg.mNdmsg.ndm_state = nudState;
        msg.mDestination = ip;
        msg.mLinkLayerAddr = llAddr;
        byte[] bytes = new byte[msg.getRequiredSpace()];
        nlmsghdr.nlmsg_len = bytes.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        msg.pack(byteBuffer);
        return bytes;
    }

    private RtNetlinkNeighborMessage(StructNlMsgHdr header) {
        super(header);
    }

    public StructNdMsg getNdHeader() {
        return this.mNdmsg;
    }

    public InetAddress getDestination() {
        return this.mDestination;
    }

    public byte[] getLinkLayerAddress() {
        return this.mLinkLayerAddr;
    }

    public int getProbes() {
        return this.mNumProbes;
    }

    public StructNdaCacheInfo getCacheInfo() {
        return this.mCacheInfo;
    }

    public int getRequiredSpace() {
        int spaceRequired = 28;
        if (this.mDestination != null) {
            spaceRequired += NetlinkConstants.alignedLengthOf(4 + this.mDestination.getAddress().length);
        }
        if (this.mLinkLayerAddr != null) {
            spaceRequired += NetlinkConstants.alignedLengthOf(4 + this.mLinkLayerAddr.length);
        }
        return spaceRequired;
    }

    private static void packNlAttr(short nlType, byte[] nlValue, ByteBuffer byteBuffer) {
        StructNlAttr nlAttr = new StructNlAttr();
        nlAttr.nla_type = nlType;
        nlAttr.nla_value = nlValue;
        nlAttr.nla_len = (short)(4 + nlAttr.nla_value.length);
        nlAttr.pack(byteBuffer);
    }

    public void pack(ByteBuffer byteBuffer) {
        this.getHeader().pack(byteBuffer);
        this.mNdmsg.pack(byteBuffer);
        if (this.mDestination != null) {
            RtNetlinkNeighborMessage.packNlAttr((short)1, this.mDestination.getAddress(), byteBuffer);
        }
        if (this.mLinkLayerAddr != null) {
            RtNetlinkNeighborMessage.packNlAttr((short)2, this.mLinkLayerAddr, byteBuffer);
        }
    }

    @Override
    public String toString() {
        String ipLiteral = this.mDestination == null ? "" : this.mDestination.getHostAddress();
        return "RtNetlinkNeighborMessage{ nlmsghdr{" + (this.mHeader == null ? "" : this.mHeader.toString()) + "}, ndmsg{" + (this.mNdmsg == null ? "" : this.mNdmsg.toString()) + "}, destination{" + ipLiteral + "} linklayeraddr{" + NetlinkConstants.hexify(this.mLinkLayerAddr) + "} probes{" + this.mNumProbes + "} cacheinfo{" + (this.mCacheInfo == null ? "" : this.mCacheInfo.toString()) + "} }";
    }
}

