/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class DnsSdTxtRecord
implements Parcelable {
    private static final byte mSeperator = 61;
    private byte[] mData;
    public static final Parcelable.Creator<DnsSdTxtRecord> CREATOR = new Parcelable.Creator<DnsSdTxtRecord>(){

        @Override
        public DnsSdTxtRecord createFromParcel(Parcel in) {
            DnsSdTxtRecord info = new DnsSdTxtRecord();
            in.readByteArray(info.mData);
            return info;
        }

        public DnsSdTxtRecord[] newArray(int size) {
            return new DnsSdTxtRecord[size];
        }
    };

    public DnsSdTxtRecord() {
        this.mData = new byte[0];
    }

    public DnsSdTxtRecord(byte[] data) {
        this.mData = (byte[])data.clone();
    }

    public DnsSdTxtRecord(DnsSdTxtRecord src) {
        if (src != null && src.mData != null) {
            this.mData = (byte[])src.mData.clone();
        }
    }

    public void set(String key, String value) {
        byte[] keyBytes;
        int valLen;
        byte[] valBytes;
        if (value != null) {
            valBytes = value.getBytes();
            valLen = valBytes.length;
        } else {
            valBytes = null;
            valLen = 0;
        }
        try {
            keyBytes = key.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("key should be US-ASCII");
        }
        for (int i = 0; i < keyBytes.length; ++i) {
            if (keyBytes[i] != 61) continue;
            throw new IllegalArgumentException("= is not a valid character in key");
        }
        if (keyBytes.length + valLen >= 255) {
            throw new IllegalArgumentException("Key and Value length cannot exceed 255 bytes");
        }
        int currentLoc = this.remove(key);
        if (currentLoc == -1) {
            currentLoc = this.keyCount();
        }
        this.insert(keyBytes, valBytes, currentLoc);
    }

    public String get(String key) {
        byte[] val = this.getValue(key);
        return val != null ? new String(val) : null;
    }

    public int remove(String key) {
        int avStart = 0;
        int i = 0;
        while (avStart < this.mData.length) {
            String s;
            byte avLen = this.mData[avStart];
            if (key.length() <= avLen && (key.length() == avLen || this.mData[avStart + key.length() + 1] == 61) && 0 == key.compareToIgnoreCase(s = new String(this.mData, avStart + 1, key.length()))) {
                byte[] oldBytes = this.mData;
                this.mData = new byte[oldBytes.length - avLen - 1];
                System.arraycopy(oldBytes, 0, this.mData, 0, avStart);
                System.arraycopy(oldBytes, avStart + avLen + 1, this.mData, avStart, oldBytes.length - avStart - avLen - 1);
                return i;
            }
            avStart += 0xFF & avLen + 1;
            ++i;
        }
        return -1;
    }

    public int keyCount() {
        int count = 0;
        int nextKey = 0;
        while (nextKey < this.mData.length) {
            nextKey += 0xFF & this.mData[nextKey] + 1;
            ++count;
        }
        return count;
    }

    public boolean contains(String key) {
        String s = null;
        int i = 0;
        while (null != (s = this.getKey(i))) {
            if (0 == key.compareToIgnoreCase(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int size() {
        return this.mData.length;
    }

    public byte[] getRawData() {
        return (byte[])this.mData.clone();
    }

    private void insert(byte[] keyBytes, byte[] value, int index) {
        byte[] oldBytes = this.mData;
        int valLen = value != null ? value.length : 0;
        int insertion = 0;
        for (int i = 0; i < index && insertion < this.mData.length; insertion += 0xFF & this.mData[insertion] + 1, ++i) {
        }
        int avLen = keyBytes.length + valLen + (value != null ? 1 : 0);
        int newLen = avLen + oldBytes.length + 1;
        this.mData = new byte[newLen];
        System.arraycopy(oldBytes, 0, this.mData, 0, insertion);
        int secondHalfLen = oldBytes.length - insertion;
        System.arraycopy(oldBytes, insertion, this.mData, newLen - secondHalfLen, secondHalfLen);
        this.mData[insertion] = (byte)avLen;
        System.arraycopy(keyBytes, 0, this.mData, insertion + 1, keyBytes.length);
        if (value != null) {
            this.mData[insertion + 1 + keyBytes.length] = 61;
            System.arraycopy(value, 0, this.mData, insertion + keyBytes.length + 2, valLen);
        }
    }

    private String getKey(int index) {
        int avStart = 0;
        for (int i = 0; i < index && avStart < this.mData.length; avStart += this.mData[avStart] + 1, ++i) {
        }
        if (avStart < this.mData.length) {
            int avLen = this.mData[avStart];
            int aLen = 0;
            for (aLen = 0; aLen < avLen && this.mData[avStart + aLen + 1] != 61; ++aLen) {
            }
            return new String(this.mData, avStart + 1, aLen);
        }
        return null;
    }

    private byte[] getValue(int index) {
        int avStart = 0;
        byte[] value = null;
        for (int i = 0; i < index && avStart < this.mData.length; avStart += this.mData[avStart] + 1, ++i) {
        }
        if (avStart < this.mData.length) {
            int avLen = this.mData[avStart];
            int aLen = 0;
            for (aLen = 0; aLen < avLen; ++aLen) {
                if (this.mData[avStart + aLen + 1] != 61) continue;
                value = new byte[avLen - aLen - 1];
                System.arraycopy(this.mData, avStart + aLen + 2, value, 0, avLen - aLen - 1);
                break;
            }
        }
        return value;
    }

    private String getValueAsString(int index) {
        byte[] value = this.getValue(index);
        return value != null ? new String(value) : null;
    }

    private byte[] getValue(String forKey) {
        String s = null;
        int i = 0;
        while (null != (s = this.getKey(i))) {
            if (0 == forKey.compareToIgnoreCase(s)) {
                return this.getValue(i);
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        String a;
        String result = null;
        int i = 0;
        while (null != (a = this.getKey(i))) {
            String av = "{" + a;
            String val = this.getValueAsString(i);
            av = val != null ? av + "=" + val + "}" : av + "}";
            result = result == null ? av : result + ", " + av;
            ++i;
        }
        return result != null ? result : "";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DnsSdTxtRecord)) {
            return false;
        }
        DnsSdTxtRecord record = (DnsSdTxtRecord)o;
        return Arrays.equals(record.mData, this.mData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mData);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mData);
    }
}

