/*
 * Decompiled with CFR 0.152.
 */
package android.net.shared;

import android.net.InetAddresses;
import android.net.InitialConfigurationParcelable;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.RouteInfo;
import android.net.shared.IpConfigurationParcelableUtil;
import android.net.shared.ParcelableUtil;
import android.text.TextUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class InitialConfiguration {
    public final Set<LinkAddress> ipAddresses = new HashSet<LinkAddress>();
    public final Set<IpPrefix> directlyConnectedRoutes = new HashSet<IpPrefix>();
    public final Set<InetAddress> dnsServers = new HashSet<InetAddress>();
    private static final int RFC6177_MIN_PREFIX_LENGTH = 48;
    private static final int RFC7421_PREFIX_LENGTH = 64;
    public static final InetAddress INET6_ANY = InetAddresses.parseNumericAddress("::");

    public static InitialConfiguration copy(InitialConfiguration config) {
        if (config == null) {
            return null;
        }
        InitialConfiguration configCopy = new InitialConfiguration();
        configCopy.ipAddresses.addAll(config.ipAddresses);
        configCopy.directlyConnectedRoutes.addAll(config.directlyConnectedRoutes);
        configCopy.dnsServers.addAll(config.dnsServers);
        return configCopy;
    }

    public String toString() {
        return String.format("InitialConfiguration(IPs: {%s}, prefixes: {%s}, DNS: {%s})", TextUtils.join((CharSequence)", ", this.ipAddresses), TextUtils.join((CharSequence)", ", this.directlyConnectedRoutes), TextUtils.join((CharSequence)", ", this.dnsServers));
    }

    public boolean isValid() {
        if (this.ipAddresses.isEmpty()) {
            return false;
        }
        for (LinkAddress linkAddress : this.ipAddresses) {
            if (InitialConfiguration.any(this.directlyConnectedRoutes, p -> p.contains(linkAddress.getAddress()))) continue;
            return false;
        }
        for (InetAddress inetAddress : this.dnsServers) {
            if (InitialConfiguration.any(this.directlyConnectedRoutes, p -> p.contains(inetAddress))) continue;
            return false;
        }
        if (InitialConfiguration.any(this.ipAddresses, InitialConfiguration.not(InitialConfiguration::isPrefixLengthCompliant))) {
            return false;
        }
        if (InitialConfiguration.any(this.directlyConnectedRoutes, InitialConfiguration::isIPv6DefaultRoute) && InitialConfiguration.all(this.ipAddresses, InitialConfiguration.not(InitialConfiguration::isIPv6GUA))) {
            return false;
        }
        if (InitialConfiguration.any(this.directlyConnectedRoutes, InitialConfiguration.not(InitialConfiguration::isPrefixLengthCompliant))) {
            return false;
        }
        return this.ipAddresses.stream().filter(InitialConfiguration::isIPv4).count() <= 1L;
    }

    public boolean isProvisionedBy(List<LinkAddress> addresses, List<RouteInfo> routes) {
        if (this.ipAddresses.isEmpty()) {
            return false;
        }
        for (LinkAddress addr : this.ipAddresses) {
            if (InitialConfiguration.any(addresses, addrSeen -> addr.isSameAddressAs((LinkAddress)addrSeen))) continue;
            return false;
        }
        if (routes != null) {
            for (IpPrefix prefix : this.directlyConnectedRoutes) {
                if (InitialConfiguration.any(routes, routeSeen -> InitialConfiguration.isDirectlyConnectedRoute(routeSeen, prefix))) continue;
                return false;
            }
        }
        return true;
    }

    public InitialConfigurationParcelable toStableParcelable() {
        InitialConfigurationParcelable p = new InitialConfigurationParcelable();
        p.ipAddresses = this.ipAddresses.toArray(new LinkAddress[0]);
        p.directlyConnectedRoutes = this.directlyConnectedRoutes.toArray(new IpPrefix[0]);
        p.dnsServers = ParcelableUtil.toParcelableArray(this.dnsServers, IpConfigurationParcelableUtil::parcelAddress, String.class);
        return p;
    }

    public static InitialConfiguration fromStableParcelable(InitialConfigurationParcelable p) {
        if (p == null) {
            return null;
        }
        InitialConfiguration config = new InitialConfiguration();
        config.ipAddresses.addAll(Arrays.asList(p.ipAddresses));
        config.directlyConnectedRoutes.addAll(Arrays.asList(p.directlyConnectedRoutes));
        config.dnsServers.addAll(ParcelableUtil.fromParcelableArray(p.dnsServers, IpConfigurationParcelableUtil::unparcelAddress));
        return config;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitialConfiguration)) {
            return false;
        }
        InitialConfiguration other = (InitialConfiguration)obj;
        return this.ipAddresses.equals(other.ipAddresses) && this.directlyConnectedRoutes.equals(other.directlyConnectedRoutes) && this.dnsServers.equals(other.dnsServers);
    }

    private static boolean isDirectlyConnectedRoute(RouteInfo route, IpPrefix prefix) {
        return !route.hasGateway() && prefix.equals(route.getDestination());
    }

    private static boolean isPrefixLengthCompliant(LinkAddress addr) {
        return InitialConfiguration.isIPv4(addr) || InitialConfiguration.isCompliantIPv6PrefixLength(addr.getPrefixLength());
    }

    private static boolean isPrefixLengthCompliant(IpPrefix prefix) {
        return InitialConfiguration.isIPv4(prefix) || InitialConfiguration.isCompliantIPv6PrefixLength(prefix.getPrefixLength());
    }

    private static boolean isCompliantIPv6PrefixLength(int prefixLength) {
        return 48 <= prefixLength && prefixLength <= 64;
    }

    private static boolean isIPv4(IpPrefix prefix) {
        return prefix.getAddress() instanceof Inet4Address;
    }

    private static boolean isIPv4(LinkAddress addr) {
        return addr.getAddress() instanceof Inet4Address;
    }

    private static boolean isIPv6DefaultRoute(IpPrefix prefix) {
        return prefix.getAddress().equals(INET6_ANY);
    }

    private static boolean isIPv6GUA(LinkAddress addr) {
        return addr.isIpv6() && addr.isGlobalPreferred();
    }

    public static <T> boolean any(Iterable<T> coll, Predicate<T> fn) {
        for (T t : coll) {
            if (!fn.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean all(Iterable<T> coll, Predicate<T> fn) {
        return !InitialConfiguration.any(coll, InitialConfiguration.not(fn));
    }

    public static <T> Predicate<T> not(Predicate<T> fn) {
        return t -> !fn.test(t);
    }
}

