/*
 * Decompiled with CFR 0.152.
 */
package android.net.shared;

import android.net.PrivateDnsConfigParcel;
import android.net.shared.IpConfigurationParcelableUtil;
import android.net.shared.ParcelableUtil;
import android.text.TextUtils;
import java.net.InetAddress;
import java.util.Arrays;

public class PrivateDnsConfig {
    public final boolean useTls;
    public final String hostname;
    public final InetAddress[] ips;

    public PrivateDnsConfig() {
        this(false);
    }

    public PrivateDnsConfig(boolean useTls) {
        this.useTls = useTls;
        this.hostname = "";
        this.ips = new InetAddress[0];
    }

    public PrivateDnsConfig(String hostname, InetAddress[] ips) {
        this.useTls = !TextUtils.isEmpty(hostname);
        this.hostname = this.useTls ? hostname : "";
        this.ips = ips != null ? ips : new InetAddress[]{};
    }

    public PrivateDnsConfig(PrivateDnsConfig cfg) {
        this.useTls = cfg.useTls;
        this.hostname = cfg.hostname;
        this.ips = cfg.ips;
    }

    public boolean inStrictMode() {
        return this.useTls && !TextUtils.isEmpty(this.hostname);
    }

    public String toString() {
        return PrivateDnsConfig.class.getSimpleName() + "{" + this.useTls + ":" + this.hostname + "/" + Arrays.toString(this.ips) + "}";
    }

    public PrivateDnsConfigParcel toParcel() {
        PrivateDnsConfigParcel parcel = new PrivateDnsConfigParcel();
        parcel.hostname = this.hostname;
        parcel.ips = ParcelableUtil.toParcelableArray(Arrays.asList(this.ips), IpConfigurationParcelableUtil::parcelAddress, String.class);
        return parcel;
    }

    public static PrivateDnsConfig fromParcel(PrivateDnsConfigParcel parcel) {
        InetAddress[] ips = new InetAddress[parcel.ips.length];
        ips = ParcelableUtil.fromParcelableArray(parcel.ips, IpConfigurationParcelableUtil::unparcelAddress).toArray(ips);
        return new PrivateDnsConfig(parcel.hostname, ips);
    }
}

