/*
 * Decompiled with CFR 0.152.
 */
package android.net.shared;

import android.net.Network;
import android.net.ProvisioningConfigurationParcelable;
import android.net.StaticIpConfiguration;
import android.net.apf.ApfCapabilities;
import android.net.shared.InitialConfiguration;
import java.util.Objects;
import java.util.StringJoiner;

public class ProvisioningConfiguration {
    private static final int DEFAULT_TIMEOUT_MS = 36000;
    public boolean mEnableIPv4 = true;
    public boolean mEnableIPv6 = true;
    public boolean mUsingMultinetworkPolicyTracker = true;
    public boolean mUsingIpReachabilityMonitor = true;
    public int mRequestedPreDhcpActionMs;
    public InitialConfiguration mInitialConfig;
    public StaticIpConfiguration mStaticIpConfig;
    public ApfCapabilities mApfCapabilities;
    public int mProvisioningTimeoutMs = 36000;
    public int mIPv6AddrGenMode = 2;
    public Network mNetwork = null;
    public String mDisplayName = null;

    public ProvisioningConfiguration() {
    }

    public ProvisioningConfiguration(ProvisioningConfiguration other) {
        this.mEnableIPv4 = other.mEnableIPv4;
        this.mEnableIPv6 = other.mEnableIPv6;
        this.mUsingMultinetworkPolicyTracker = other.mUsingMultinetworkPolicyTracker;
        this.mUsingIpReachabilityMonitor = other.mUsingIpReachabilityMonitor;
        this.mRequestedPreDhcpActionMs = other.mRequestedPreDhcpActionMs;
        this.mInitialConfig = InitialConfiguration.copy(other.mInitialConfig);
        this.mStaticIpConfig = other.mStaticIpConfig == null ? null : new StaticIpConfiguration(other.mStaticIpConfig);
        this.mApfCapabilities = other.mApfCapabilities;
        this.mProvisioningTimeoutMs = other.mProvisioningTimeoutMs;
        this.mIPv6AddrGenMode = other.mIPv6AddrGenMode;
        this.mNetwork = other.mNetwork;
        this.mDisplayName = other.mDisplayName;
    }

    public ProvisioningConfigurationParcelable toStableParcelable() {
        ProvisioningConfigurationParcelable p = new ProvisioningConfigurationParcelable();
        p.enableIPv4 = this.mEnableIPv4;
        p.enableIPv6 = this.mEnableIPv6;
        p.usingMultinetworkPolicyTracker = this.mUsingMultinetworkPolicyTracker;
        p.usingIpReachabilityMonitor = this.mUsingIpReachabilityMonitor;
        p.requestedPreDhcpActionMs = this.mRequestedPreDhcpActionMs;
        p.initialConfig = this.mInitialConfig == null ? null : this.mInitialConfig.toStableParcelable();
        p.staticIpConfig = this.mStaticIpConfig == null ? null : new StaticIpConfiguration(this.mStaticIpConfig);
        p.apfCapabilities = this.mApfCapabilities;
        p.provisioningTimeoutMs = this.mProvisioningTimeoutMs;
        p.ipv6AddrGenMode = this.mIPv6AddrGenMode;
        p.network = this.mNetwork;
        p.displayName = this.mDisplayName;
        return p;
    }

    public static ProvisioningConfiguration fromStableParcelable(ProvisioningConfigurationParcelable p) {
        if (p == null) {
            return null;
        }
        ProvisioningConfiguration config = new ProvisioningConfiguration();
        config.mEnableIPv4 = p.enableIPv4;
        config.mEnableIPv6 = p.enableIPv6;
        config.mUsingMultinetworkPolicyTracker = p.usingMultinetworkPolicyTracker;
        config.mUsingIpReachabilityMonitor = p.usingIpReachabilityMonitor;
        config.mRequestedPreDhcpActionMs = p.requestedPreDhcpActionMs;
        config.mInitialConfig = InitialConfiguration.fromStableParcelable(p.initialConfig);
        config.mStaticIpConfig = p.staticIpConfig == null ? null : new StaticIpConfiguration(p.staticIpConfig);
        config.mApfCapabilities = p.apfCapabilities;
        config.mProvisioningTimeoutMs = p.provisioningTimeoutMs;
        config.mIPv6AddrGenMode = p.ipv6AddrGenMode;
        config.mNetwork = p.network;
        config.mDisplayName = p.displayName;
        return config;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("mEnableIPv4: " + this.mEnableIPv4).add("mEnableIPv6: " + this.mEnableIPv6).add("mUsingMultinetworkPolicyTracker: " + this.mUsingMultinetworkPolicyTracker).add("mUsingIpReachabilityMonitor: " + this.mUsingIpReachabilityMonitor).add("mRequestedPreDhcpActionMs: " + this.mRequestedPreDhcpActionMs).add("mInitialConfig: " + this.mInitialConfig).add("mStaticIpConfig: " + this.mStaticIpConfig).add("mApfCapabilities: " + this.mApfCapabilities).add("mProvisioningTimeoutMs: " + this.mProvisioningTimeoutMs).add("mIPv6AddrGenMode: " + this.mIPv6AddrGenMode).add("mNetwork: " + this.mNetwork).add("mDisplayName: " + this.mDisplayName).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProvisioningConfiguration)) {
            return false;
        }
        ProvisioningConfiguration other = (ProvisioningConfiguration)obj;
        return this.mEnableIPv4 == other.mEnableIPv4 && this.mEnableIPv6 == other.mEnableIPv6 && this.mUsingMultinetworkPolicyTracker == other.mUsingMultinetworkPolicyTracker && this.mUsingIpReachabilityMonitor == other.mUsingIpReachabilityMonitor && this.mRequestedPreDhcpActionMs == other.mRequestedPreDhcpActionMs && Objects.equals(this.mInitialConfig, other.mInitialConfig) && Objects.equals(this.mStaticIpConfig, other.mStaticIpConfig) && Objects.equals(this.mApfCapabilities, other.mApfCapabilities) && this.mProvisioningTimeoutMs == other.mProvisioningTimeoutMs && this.mIPv6AddrGenMode == other.mIPv6AddrGenMode && Objects.equals(this.mNetwork, other.mNetwork) && Objects.equals(this.mDisplayName, other.mDisplayName);
    }

    public boolean isValid() {
        return this.mInitialConfig == null || this.mInitialConfig.isValid();
    }

    public static class Builder {
        protected ProvisioningConfiguration mConfig = new ProvisioningConfiguration();

        public Builder withoutIPv4() {
            this.mConfig.mEnableIPv4 = false;
            return this;
        }

        public Builder withoutIPv6() {
            this.mConfig.mEnableIPv6 = false;
            return this;
        }

        public Builder withoutMultinetworkPolicyTracker() {
            this.mConfig.mUsingMultinetworkPolicyTracker = false;
            return this;
        }

        public Builder withoutIpReachabilityMonitor() {
            this.mConfig.mUsingIpReachabilityMonitor = false;
            return this;
        }

        public Builder withPreDhcpAction() {
            this.mConfig.mRequestedPreDhcpActionMs = 36000;
            return this;
        }

        public Builder withPreDhcpAction(int dhcpActionTimeoutMs) {
            this.mConfig.mRequestedPreDhcpActionMs = dhcpActionTimeoutMs;
            return this;
        }

        public Builder withInitialConfiguration(InitialConfiguration initialConfig) {
            this.mConfig.mInitialConfig = initialConfig;
            return this;
        }

        public Builder withStaticConfiguration(StaticIpConfiguration staticConfig) {
            this.mConfig.mStaticIpConfig = staticConfig;
            return this;
        }

        public Builder withApfCapabilities(ApfCapabilities apfCapabilities) {
            this.mConfig.mApfCapabilities = apfCapabilities;
            return this;
        }

        public Builder withProvisioningTimeoutMs(int timeoutMs) {
            this.mConfig.mProvisioningTimeoutMs = timeoutMs;
            return this;
        }

        public Builder withRandomMacAddress() {
            this.mConfig.mIPv6AddrGenMode = 0;
            return this;
        }

        public Builder withStableMacAddress() {
            this.mConfig.mIPv6AddrGenMode = 2;
            return this;
        }

        public Builder withNetwork(Network network) {
            this.mConfig.mNetwork = network;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.mConfig.mDisplayName = displayName;
            return this;
        }

        public ProvisioningConfiguration build() {
            return new ProvisioningConfiguration(this.mConfig);
        }
    }
}

