/*
 * Decompiled with CFR 0.152.
 */
package android.net.ssl;

import com.android.org.conscrypt.Conscrypt;
import javax.net.ssl.SSLEngine;

public class SSLEngines {
    private SSLEngines() {
    }

    public static boolean isSupportedEngine(SSLEngine engine) {
        return Conscrypt.isConscrypt(engine);
    }

    private static void checkSupported(SSLEngine e) {
        if (!SSLEngines.isSupportedEngine(e)) {
            throw new IllegalArgumentException("Engine is not a supported engine.");
        }
    }

    public static void setUseSessionTickets(SSLEngine engine, boolean useSessionTickets) {
        SSLEngines.checkSupported(engine);
        Conscrypt.setUseSessionTickets(engine, useSessionTickets);
    }
}

