/*
 * Decompiled with CFR 0.152.
 */
package android.net.ssl;

import com.android.org.conscrypt.Conscrypt;
import javax.net.ssl.SSLSocket;

public class SSLSockets {
    private SSLSockets() {
    }

    public static boolean isSupportedSocket(SSLSocket socket) {
        return Conscrypt.isConscrypt(socket);
    }

    private static void checkSupported(SSLSocket s) {
        if (!SSLSockets.isSupportedSocket(s)) {
            throw new IllegalArgumentException("Socket is not a supported socket.");
        }
    }

    public static void setUseSessionTickets(SSLSocket socket, boolean useSessionTickets) {
        SSLSockets.checkSupported(socket);
        Conscrypt.setUseSessionTickets(socket, useSessionTickets);
    }
}

