/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.InetAddresses;
import android.net.Network;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.util.BitUtils;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import libcore.io.IoUtils;

public class DnsUtils {
    private static final String TAG = "DnsUtils";
    private static final int CHAR_BIT = 8;
    public static final int IPV6_ADDR_SCOPE_NODELOCAL = 1;
    public static final int IPV6_ADDR_SCOPE_LINKLOCAL = 2;
    public static final int IPV6_ADDR_SCOPE_SITELOCAL = 5;
    public static final int IPV6_ADDR_SCOPE_GLOBAL = 14;
    private static final Comparator<SortableAddress> sRfc6724Comparator = new Rfc6724Comparator();

    public static List<InetAddress> rfc6724Sort(Network network, List<InetAddress> answers) {
        ArrayList sortableAnswerList = new ArrayList();
        answers.forEach(addr -> sortableAnswerList.add(new SortableAddress((InetAddress)addr, DnsUtils.findSrcAddress(network, addr))));
        Collections.sort(sortableAnswerList, sRfc6724Comparator);
        ArrayList<InetAddress> sortedAnswers = new ArrayList<InetAddress>();
        sortableAnswerList.forEach(ans -> sortedAnswers.add(ans.address));
        return sortedAnswers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress findSrcAddress(Network network, InetAddress addr) {
        FileDescriptor socket;
        int domain;
        if (DnsUtils.isIpv4Address(addr)) {
            domain = OsConstants.AF_INET;
        } else if (DnsUtils.isIpv6Address(addr)) {
            domain = OsConstants.AF_INET6;
        } else {
            return null;
        }
        try {
            socket = Os.socket(domain, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "findSrcAddress:" + e.toString());
            return null;
        }
        try {
            if (network != null) {
                network.bindSocket(socket);
            }
            Os.connect(socket, new InetSocketAddress(addr, 0));
            InetAddress e = ((InetSocketAddress)Os.getsockname(socket)).getAddress();
            return e;
        }
        catch (ErrnoException | IOException e) {
            InetAddress inetAddress = null;
            return inetAddress;
        }
        finally {
            IoUtils.closeQuietly(socket);
        }
    }

    private static int findLabel(InetAddress addr) {
        if (DnsUtils.isIpv4Address(addr)) {
            return 4;
        }
        if (DnsUtils.isIpv6Address(addr)) {
            if (addr.isLoopbackAddress()) {
                return 0;
            }
            if (DnsUtils.isIpv6Address6To4(addr)) {
                return 2;
            }
            if (DnsUtils.isIpv6AddressTeredo(addr)) {
                return 5;
            }
            if (DnsUtils.isIpv6AddressULA(addr)) {
                return 13;
            }
            if (((Inet6Address)addr).isIPv4CompatibleAddress()) {
                return 3;
            }
            if (addr.isSiteLocalAddress()) {
                return 11;
            }
            if (DnsUtils.isIpv6Address6Bone(addr)) {
                return 12;
            }
            return 1;
        }
        return 1;
    }

    private static boolean isIpv6Address(InetAddress addr) {
        return addr instanceof Inet6Address;
    }

    private static boolean isIpv4Address(InetAddress addr) {
        return addr instanceof Inet4Address;
    }

    private static boolean isIpv6Address6To4(InetAddress addr) {
        if (!DnsUtils.isIpv6Address(addr)) {
            return false;
        }
        byte[] byteAddr = addr.getAddress();
        return byteAddr[0] == 32 && byteAddr[1] == 2;
    }

    private static boolean isIpv6AddressTeredo(InetAddress addr) {
        if (!DnsUtils.isIpv6Address(addr)) {
            return false;
        }
        byte[] byteAddr = addr.getAddress();
        return byteAddr[0] == 32 && byteAddr[1] == 1 && byteAddr[2] == 0 && byteAddr[3] == 0;
    }

    private static boolean isIpv6AddressULA(InetAddress addr) {
        return DnsUtils.isIpv6Address(addr) && (addr.getAddress()[0] & 0xFE) == 252;
    }

    private static boolean isIpv6Address6Bone(InetAddress addr) {
        if (!DnsUtils.isIpv6Address(addr)) {
            return false;
        }
        byte[] byteAddr = addr.getAddress();
        return byteAddr[0] == 63 && byteAddr[1] == -2;
    }

    private static int getIpv6MulticastScope(InetAddress addr) {
        return !DnsUtils.isIpv6Address(addr) ? 0 : addr.getAddress()[1] & 0xF;
    }

    private static int findScope(InetAddress addr) {
        if (DnsUtils.isIpv6Address(addr)) {
            if (addr.isMulticastAddress()) {
                return DnsUtils.getIpv6MulticastScope(addr);
            }
            if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) {
                return 2;
            }
            if (addr.isSiteLocalAddress()) {
                return 5;
            }
            return 14;
        }
        if (DnsUtils.isIpv4Address(addr)) {
            if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) {
                return 2;
            }
            return 14;
        }
        return 1;
    }

    private static int findPrecedence(InetAddress addr) {
        if (DnsUtils.isIpv4Address(addr)) {
            return 35;
        }
        if (DnsUtils.isIpv6Address(addr)) {
            if (addr.isLoopbackAddress()) {
                return 50;
            }
            if (DnsUtils.isIpv6Address6To4(addr)) {
                return 30;
            }
            if (DnsUtils.isIpv6AddressTeredo(addr)) {
                return 5;
            }
            if (DnsUtils.isIpv6AddressULA(addr)) {
                return 3;
            }
            if (((Inet6Address)addr).isIPv4CompatibleAddress() || addr.isSiteLocalAddress() || DnsUtils.isIpv6Address6Bone(addr)) {
                return 1;
            }
            return 40;
        }
        return 1;
    }

    private static int compareIpv6PrefixMatchLen(InetAddress srcAddr, InetAddress dstAddr) {
        byte[] dstByte;
        byte[] srcByte = srcAddr.getAddress();
        if (srcByte.length != (dstByte = dstAddr.getAddress()).length) {
            return 0;
        }
        for (int i = 0; i < dstByte.length; ++i) {
            if (srcByte[i] == dstByte[i]) continue;
            int x = BitUtils.uint8(srcByte[i]) ^ BitUtils.uint8(dstByte[i]);
            return i * 8 + (Integer.numberOfLeadingZeros(x) - 24);
        }
        return dstByte.length * 8;
    }

    public static boolean haveIpv4(Network network) {
        InetSocketAddress addrIpv4 = new InetSocketAddress(InetAddresses.parseNumericAddress("8.8.8.8"), 0);
        return DnsUtils.checkConnectivity(network, OsConstants.AF_INET, addrIpv4);
    }

    public static boolean haveIpv6(Network network) {
        InetSocketAddress addrIpv6 = new InetSocketAddress(InetAddresses.parseNumericAddress("2000::"), 0);
        return DnsUtils.checkConnectivity(network, OsConstants.AF_INET6, addrIpv6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkConnectivity(Network network, int domain, SocketAddress addr) {
        FileDescriptor socket;
        try {
            socket = Os.socket(domain, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
        }
        catch (ErrnoException e) {
            return false;
        }
        try {
            if (network != null) {
                network.bindSocket(socket);
            }
            Os.connect(socket, addr);
        }
        catch (ErrnoException | IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IoUtils.closeQuietly(socket);
        }
        return true;
    }

    public static class SortableAddress {
        public final int label;
        public final int labelMatch;
        public final int scope;
        public final int scopeMatch;
        public final int precedence;
        public final int prefixMatchLen;
        public final int hasSrcAddr;
        public final InetAddress address;

        public SortableAddress(InetAddress addr, InetAddress srcAddr) {
            this.address = addr;
            this.hasSrcAddr = srcAddr != null ? 1 : 0;
            this.label = DnsUtils.findLabel(addr);
            this.scope = DnsUtils.findScope(addr);
            this.precedence = DnsUtils.findPrecedence(addr);
            this.labelMatch = srcAddr != null && this.label == DnsUtils.findLabel(srcAddr) ? 1 : 0;
            this.scopeMatch = srcAddr != null && this.scope == DnsUtils.findScope(srcAddr) ? 1 : 0;
            this.prefixMatchLen = DnsUtils.isIpv6Address(addr) && DnsUtils.isIpv6Address(srcAddr) ? DnsUtils.compareIpv6PrefixMatchLen(srcAddr, addr) : 0;
        }
    }

    public static class Rfc6724Comparator
    implements Comparator<SortableAddress> {
        @Override
        public int compare(SortableAddress span1, SortableAddress span2) {
            if (span1.hasSrcAddr != span2.hasSrcAddr) {
                return span2.hasSrcAddr - span1.hasSrcAddr;
            }
            if (span1.scopeMatch != span2.scopeMatch) {
                return span2.scopeMatch - span1.scopeMatch;
            }
            if (span1.labelMatch != span2.labelMatch) {
                return span2.labelMatch - span1.labelMatch;
            }
            if (span1.precedence != span2.precedence) {
                return span2.precedence - span1.precedence;
            }
            if (span1.scope != span2.scope) {
                return span1.scope - span2.scope;
            }
            if (span1.prefixMatchLen != span2.prefixMatchLen) {
                return span2.prefixMatchLen - span1.prefixMatchLen;
            }
            return 0;
        }
    }
}

