/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.content.Context;
import android.content.res.Resources;
import android.net.NetworkCapabilities;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;

public final class KeepaliveUtils {
    public static final String TAG = "KeepaliveUtils";

    public static int[] getSupportedKeepalives(Context context) {
        String[] res = null;
        try {
            res = context.getResources().getStringArray(17236041);
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        if (res == null) {
            throw new KeepaliveDeviceConfigurationException("invalid resource");
        }
        int[] ret = new int[8];
        for (String row : res) {
            int supported;
            int transport;
            if (TextUtils.isEmpty(row)) {
                throw new KeepaliveDeviceConfigurationException("Empty string");
            }
            String[] arr = row.split(",");
            if (arr.length != 2) {
                throw new KeepaliveDeviceConfigurationException("Invalid parameter length");
            }
            try {
                transport = Integer.parseInt(arr[0]);
                supported = Integer.parseInt(arr[1]);
            }
            catch (NumberFormatException e) {
                throw new KeepaliveDeviceConfigurationException("Invalid number format");
            }
            if (!NetworkCapabilities.isValidTransport(transport)) {
                throw new KeepaliveDeviceConfigurationException("Invalid transport " + transport);
            }
            if (supported < 0) {
                throw new KeepaliveDeviceConfigurationException("Invalid supported count " + supported + " for " + NetworkCapabilities.transportNameOf(transport));
            }
            ret[transport] = supported;
        }
        return ret;
    }

    public static int getSupportedKeepalivesForNetworkCapabilities(int[] supportedKeepalives, NetworkCapabilities nc) {
        int[] transports = nc.getTransportTypes();
        if (transports.length == 0) {
            return 0;
        }
        int supportedCount = supportedKeepalives[transports[0]];
        for (int transport : transports) {
            if (supportedCount <= supportedKeepalives[transport]) continue;
            supportedCount = supportedKeepalives[transport];
        }
        return supportedCount;
    }

    public static class KeepaliveDeviceConfigurationException
    extends AndroidRuntimeException {
        public KeepaliveDeviceConfigurationException(String msg) {
            super(msg);
        }
    }
}

