/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;

public enum SupplicantState implements Parcelable
{
    DISCONNECTED,
    INTERFACE_DISABLED,
    INACTIVE,
    SCANNING,
    AUTHENTICATING,
    ASSOCIATING,
    ASSOCIATED,
    FOUR_WAY_HANDSHAKE,
    GROUP_HANDSHAKE,
    COMPLETED,
    DORMANT,
    UNINITIALIZED,
    INVALID;

    public static final Parcelable.Creator<SupplicantState> CREATOR;

    public static boolean isValidState(SupplicantState state) {
        return state != UNINITIALIZED && state != INVALID;
    }

    public static boolean isHandshakeState(SupplicantState state) {
        switch (state) {
            case AUTHENTICATING: 
            case ASSOCIATING: 
            case ASSOCIATED: 
            case FOUR_WAY_HANDSHAKE: 
            case GROUP_HANDSHAKE: {
                return true;
            }
            case COMPLETED: 
            case DISCONNECTED: 
            case INTERFACE_DISABLED: 
            case INACTIVE: 
            case SCANNING: 
            case DORMANT: 
            case UNINITIALIZED: 
            case INVALID: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown supplicant state");
    }

    public static boolean isConnecting(SupplicantState state) {
        switch (state) {
            case AUTHENTICATING: 
            case ASSOCIATING: 
            case ASSOCIATED: 
            case FOUR_WAY_HANDSHAKE: 
            case GROUP_HANDSHAKE: 
            case COMPLETED: {
                return true;
            }
            case DISCONNECTED: 
            case INTERFACE_DISABLED: 
            case INACTIVE: 
            case SCANNING: 
            case DORMANT: 
            case UNINITIALIZED: 
            case INVALID: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown supplicant state");
    }

    public static boolean isDriverActive(SupplicantState state) {
        switch (state) {
            case AUTHENTICATING: 
            case ASSOCIATING: 
            case ASSOCIATED: 
            case FOUR_WAY_HANDSHAKE: 
            case GROUP_HANDSHAKE: 
            case COMPLETED: 
            case DISCONNECTED: 
            case INACTIVE: 
            case SCANNING: 
            case DORMANT: {
                return true;
            }
            case INTERFACE_DISABLED: 
            case UNINITIALIZED: 
            case INVALID: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown supplicant state");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name());
    }

    static {
        CREATOR = new Parcelable.Creator<SupplicantState>(){

            @Override
            public SupplicantState createFromParcel(Parcel in) {
                return SupplicantState.valueOf(in.readString());
            }

            public SupplicantState[] newArray(int size) {
                return new SupplicantState[size];
            }
        };
    }
}

