/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.MacAddress;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkSpecifier;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiNetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public final class WifiNetworkAgentSpecifier
extends NetworkSpecifier
implements Parcelable {
    private final WifiConfiguration mWifiConfiguration;
    private final int mOriginalRequestorUid;
    private final String mOriginalRequestorPackageName;
    public static final Parcelable.Creator<WifiNetworkAgentSpecifier> CREATOR = new Parcelable.Creator<WifiNetworkAgentSpecifier>(){

        @Override
        public WifiNetworkAgentSpecifier createFromParcel(Parcel in) {
            WifiConfiguration wifiConfiguration = (WifiConfiguration)in.readParcelable(null);
            int originalRequestorUid = in.readInt();
            String originalRequestorPackageName = in.readString();
            return new WifiNetworkAgentSpecifier(wifiConfiguration, originalRequestorUid, originalRequestorPackageName);
        }

        public WifiNetworkAgentSpecifier[] newArray(int size) {
            return new WifiNetworkAgentSpecifier[size];
        }
    };

    public WifiNetworkAgentSpecifier(WifiConfiguration wifiConfiguration, int originalRequestorUid, String originalRequestorPackageName) {
        Preconditions.checkNotNull(wifiConfiguration);
        this.mWifiConfiguration = wifiConfiguration;
        this.mOriginalRequestorUid = originalRequestorUid;
        this.mOriginalRequestorPackageName = originalRequestorPackageName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mWifiConfiguration, flags);
        dest.writeInt(this.mOriginalRequestorUid);
        dest.writeString(this.mOriginalRequestorPackageName);
    }

    @Override
    public boolean satisfiedBy(NetworkSpecifier other) {
        if (this == other) {
            return true;
        }
        if (other == null || other instanceof MatchAllNetworkSpecifier) {
            return true;
        }
        if (other instanceof WifiNetworkSpecifier) {
            return this.satisfiesNetworkSpecifier((WifiNetworkSpecifier)other);
        }
        return this.equals(other);
    }

    public boolean satisfiesNetworkSpecifier(WifiNetworkSpecifier ns) {
        MacAddress matchMask;
        MacAddress matchBaseAddress;
        Preconditions.checkNotNull(ns);
        Preconditions.checkNotNull(ns.ssidPatternMatcher);
        Preconditions.checkNotNull(ns.bssidPatternMatcher);
        Preconditions.checkNotNull(ns.wifiConfiguration.allowedKeyManagement);
        Preconditions.checkNotNull(this.mWifiConfiguration.SSID);
        Preconditions.checkNotNull(this.mWifiConfiguration.BSSID);
        Preconditions.checkNotNull(this.mWifiConfiguration.allowedKeyManagement);
        String ssidWithQuotes = this.mWifiConfiguration.SSID;
        Preconditions.checkState(ssidWithQuotes.startsWith("\"") && ssidWithQuotes.endsWith("\""));
        String ssidWithoutQuotes = ssidWithQuotes.substring(1, ssidWithQuotes.length() - 1);
        if (!ns.ssidPatternMatcher.match(ssidWithoutQuotes)) {
            return false;
        }
        MacAddress bssid = MacAddress.fromString(this.mWifiConfiguration.BSSID);
        if (!bssid.matches(matchBaseAddress = (MacAddress)ns.bssidPatternMatcher.first, matchMask = (MacAddress)ns.bssidPatternMatcher.second)) {
            return false;
        }
        if (!ns.wifiConfiguration.allowedKeyManagement.equals(this.mWifiConfiguration.allowedKeyManagement)) {
            return false;
        }
        if (ns.requestorUid != this.mOriginalRequestorUid) {
            return false;
        }
        return TextUtils.equals(ns.requestorPackageName, this.mOriginalRequestorPackageName);
    }

    public int hashCode() {
        return Objects.hash(this.mWifiConfiguration.SSID, this.mWifiConfiguration.BSSID, this.mWifiConfiguration.allowedKeyManagement, this.mOriginalRequestorUid, this.mOriginalRequestorPackageName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiNetworkAgentSpecifier)) {
            return false;
        }
        WifiNetworkAgentSpecifier lhs = (WifiNetworkAgentSpecifier)obj;
        return Objects.equals(this.mWifiConfiguration.SSID, lhs.mWifiConfiguration.SSID) && Objects.equals(this.mWifiConfiguration.BSSID, lhs.mWifiConfiguration.BSSID) && Objects.equals(this.mWifiConfiguration.allowedKeyManagement, lhs.mWifiConfiguration.allowedKeyManagement) && this.mOriginalRequestorUid == lhs.mOriginalRequestorUid && TextUtils.equals(this.mOriginalRequestorPackageName, lhs.mOriginalRequestorPackageName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WifiNetworkAgentSpecifier [");
        sb.append("WifiConfiguration=").append(", SSID=").append(this.mWifiConfiguration.SSID).append(", BSSID=").append(this.mWifiConfiguration.BSSID).append(", mOriginalRequestorUid=").append(this.mOriginalRequestorUid).append(", mOriginalRequestorPackageName=").append(this.mOriginalRequestorPackageName).append("]");
        return sb.toString();
    }

    @Override
    public void assertValidFromUid(int requestorUid) {
        throw new IllegalStateException("WifiNetworkAgentSpecifier should never be used for requests.");
    }

    @Override
    public NetworkSpecifier redact() {
        return null;
    }
}

