/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.TransportInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet6Address;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Objects;

public final class WifiAwareNetworkInfo
implements TransportInfo,
Parcelable {
    private Inet6Address mIpv6Addr;
    private int mPort = 0;
    private int mTransportProtocol = -1;
    public static final Parcelable.Creator<WifiAwareNetworkInfo> CREATOR = new Parcelable.Creator<WifiAwareNetworkInfo>(){

        @Override
        public WifiAwareNetworkInfo createFromParcel(Parcel in) {
            Inet6Address ipv6Addr;
            try {
                byte[] addr = in.createByteArray();
                String interfaceName = in.readString();
                NetworkInterface ni = null;
                if (interfaceName != null) {
                    try {
                        ni = NetworkInterface.getByName(interfaceName);
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                    }
                }
                ipv6Addr = Inet6Address.getByAddress(null, addr, ni);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
            int port = in.readInt();
            int transportProtocol = in.readInt();
            return new WifiAwareNetworkInfo(ipv6Addr, port, transportProtocol);
        }

        public WifiAwareNetworkInfo[] newArray(int size) {
            return new WifiAwareNetworkInfo[size];
        }
    };

    public WifiAwareNetworkInfo(Inet6Address ipv6Addr) {
        this.mIpv6Addr = ipv6Addr;
    }

    public WifiAwareNetworkInfo(Inet6Address ipv6Addr, int port, int transportProtocol) {
        this.mIpv6Addr = ipv6Addr;
        this.mPort = port;
        this.mTransportProtocol = transportProtocol;
    }

    public Inet6Address getPeerIpv6Addr() {
        return this.mIpv6Addr;
    }

    public int getPort() {
        return this.mPort;
    }

    public int getTransportProtocol() {
        return this.mTransportProtocol;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mIpv6Addr.getAddress());
        NetworkInterface ni = this.mIpv6Addr.getScopedInterface();
        dest.writeString(ni == null ? null : ni.getName());
        dest.writeInt(this.mPort);
        dest.writeInt(this.mTransportProtocol);
    }

    public String toString() {
        return "AwareNetworkInfo: IPv6=" + this.mIpv6Addr + ", port=" + this.mPort + ", transportProtocol=" + this.mTransportProtocol;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiAwareNetworkInfo)) {
            return false;
        }
        WifiAwareNetworkInfo lhs = (WifiAwareNetworkInfo)obj;
        return Objects.equals(this.mIpv6Addr, lhs.mIpv6Addr) && this.mPort == lhs.mPort && this.mTransportProtocol == lhs.mTransportProtocol;
    }

    public int hashCode() {
        return Objects.hash(this.mIpv6Addr, this.mPort, this.mTransportProtocol);
    }
}

