/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2;

import android.annotation.SystemApi;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.net.wifi.WifiSsid;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@SystemApi
public final class OsuProvider
implements Parcelable {
    public static final int METHOD_OMA_DM = 0;
    public static final int METHOD_SOAP_XML_SPP = 1;
    private WifiSsid mOsuSsid;
    private final Map<String, String> mFriendlyNames;
    private final String mServiceDescription;
    private final Uri mServerUri;
    private final String mNetworkAccessIdentifier;
    private final List<Integer> mMethodList;
    private final Icon mIcon;
    public static final Parcelable.Creator<OsuProvider> CREATOR = new Parcelable.Creator<OsuProvider>(){

        @Override
        public OsuProvider createFromParcel(Parcel in) {
            WifiSsid osuSsid = (WifiSsid)in.readParcelable(null);
            String serviceDescription = in.readString();
            Uri serverUri = (Uri)in.readParcelable(null);
            String nai = in.readString();
            ArrayList<Integer> methodList = new ArrayList<Integer>();
            in.readList(methodList, null);
            Icon icon = (Icon)in.readParcelable(null);
            Bundle bundle = in.readBundle();
            HashMap friendlyNamesMap = (HashMap)bundle.getSerializable("friendlyNameMap");
            return new OsuProvider(osuSsid, friendlyNamesMap, serviceDescription, serverUri, nai, methodList, icon);
        }

        public OsuProvider[] newArray(int size) {
            return new OsuProvider[size];
        }
    };

    public OsuProvider(WifiSsid osuSsid, Map<String, String> friendlyNames, String serviceDescription, Uri serverUri, String nai, List<Integer> methodList, Icon icon) {
        this.mOsuSsid = osuSsid;
        this.mFriendlyNames = friendlyNames;
        this.mServiceDescription = serviceDescription;
        this.mServerUri = serverUri;
        this.mNetworkAccessIdentifier = nai;
        this.mMethodList = methodList == null ? new ArrayList<Integer>() : new ArrayList<Integer>(methodList);
        this.mIcon = icon;
    }

    public OsuProvider(OsuProvider source) {
        if (source == null) {
            this.mOsuSsid = null;
            this.mFriendlyNames = null;
            this.mServiceDescription = null;
            this.mServerUri = null;
            this.mNetworkAccessIdentifier = null;
            this.mMethodList = new ArrayList<Integer>();
            this.mIcon = null;
            return;
        }
        this.mOsuSsid = source.mOsuSsid;
        this.mFriendlyNames = source.mFriendlyNames;
        this.mServiceDescription = source.mServiceDescription;
        this.mServerUri = source.mServerUri;
        this.mNetworkAccessIdentifier = source.mNetworkAccessIdentifier;
        this.mMethodList = source.mMethodList == null ? new ArrayList<Integer>() : new ArrayList<Integer>(source.mMethodList);
        this.mIcon = source.mIcon;
    }

    public WifiSsid getOsuSsid() {
        return this.mOsuSsid;
    }

    public void setOsuSsid(WifiSsid osuSsid) {
        this.mOsuSsid = osuSsid;
    }

    public String getFriendlyName() {
        if (this.mFriendlyNames == null || this.mFriendlyNames.isEmpty()) {
            return null;
        }
        String lang = Locale.getDefault().getLanguage();
        String friendlyName = this.mFriendlyNames.get(lang);
        if (friendlyName != null) {
            return friendlyName;
        }
        friendlyName = this.mFriendlyNames.get("en");
        if (friendlyName != null) {
            return friendlyName;
        }
        return this.mFriendlyNames.get(this.mFriendlyNames.keySet().stream().findFirst().get());
    }

    public Map<String, String> getFriendlyNameList() {
        return this.mFriendlyNames;
    }

    public String getServiceDescription() {
        return this.mServiceDescription;
    }

    public Uri getServerUri() {
        return this.mServerUri;
    }

    public String getNetworkAccessIdentifier() {
        return this.mNetworkAccessIdentifier;
    }

    public List<Integer> getMethodList() {
        return this.mMethodList;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mOsuSsid, flags);
        dest.writeString(this.mServiceDescription);
        dest.writeParcelable(this.mServerUri, flags);
        dest.writeString(this.mNetworkAccessIdentifier);
        dest.writeList(this.mMethodList);
        dest.writeParcelable(this.mIcon, flags);
        Bundle bundle = new Bundle();
        bundle.putSerializable("friendlyNameMap", (HashMap)this.mFriendlyNames);
        dest.writeBundle(bundle);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof OsuProvider)) {
            return false;
        }
        OsuProvider that = (OsuProvider)thatObject;
        return (this.mOsuSsid == null ? that.mOsuSsid == null : this.mOsuSsid.equals(that.mOsuSsid)) && this.mFriendlyNames == null ? that.mFriendlyNames == null : this.mFriendlyNames.equals(that.mFriendlyNames) && TextUtils.equals(this.mServiceDescription, that.mServiceDescription) && (this.mServerUri == null ? that.mServerUri == null : this.mServerUri.equals(that.mServerUri)) && TextUtils.equals(this.mNetworkAccessIdentifier, that.mNetworkAccessIdentifier) && (this.mMethodList == null ? that.mMethodList == null : this.mMethodList.equals(that.mMethodList)) && (this.mIcon == null ? that.mIcon == null : this.mIcon.sameAs(that.mIcon));
    }

    public int hashCode() {
        return Objects.hash(this.mOsuSsid, this.mServiceDescription, this.mFriendlyNames, this.mServerUri, this.mNetworkAccessIdentifier, this.mMethodList);
    }

    public String toString() {
        return "OsuProvider{mOsuSsid=" + this.mOsuSsid + " mFriendlyNames=" + this.mFriendlyNames + " mServiceDescription=" + this.mServiceDescription + " mServerUri=" + this.mServerUri + " mNetworkAccessIdentifier=" + this.mNetworkAccessIdentifier + " mMethodList=" + this.mMethodList + " mIcon=" + this.mIcon;
    }
}

