/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.omadm;

import android.net.wifi.hotspot2.PasspointConfiguration;
import android.net.wifi.hotspot2.omadm.XMLNode;
import android.net.wifi.hotspot2.omadm.XMLParser;
import android.net.wifi.hotspot2.pps.Credential;
import android.net.wifi.hotspot2.pps.HomeSp;
import android.net.wifi.hotspot2.pps.Policy;
import android.net.wifi.hotspot2.pps.UpdateParameter;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public final class PpsMoParser {
    private static final String TAG = "PpsMoParser";
    private static final String TAG_MANAGEMENT_TREE = "MgmtTree";
    private static final String TAG_VER_DTD = "VerDTD";
    private static final String TAG_NODE = "Node";
    private static final String TAG_NODE_NAME = "NodeName";
    private static final String TAG_RT_PROPERTIES = "RTProperties";
    private static final String TAG_TYPE = "Type";
    private static final String TAG_DDF_NAME = "DDFName";
    private static final String TAG_VALUE = "Value";
    private static final String NODE_PER_PROVIDER_SUBSCRIPTION = "PerProviderSubscription";
    private static final String NODE_UPDATE_IDENTIFIER = "UpdateIdentifier";
    private static final String NODE_AAA_SERVER_TRUST_ROOT = "AAAServerTrustRoot";
    private static final String NODE_SUBSCRIPTION_UPDATE = "SubscriptionUpdate";
    private static final String NODE_SUBSCRIPTION_PARAMETER = "SubscriptionParameters";
    private static final String NODE_TYPE_OF_SUBSCRIPTION = "TypeOfSubscription";
    private static final String NODE_USAGE_LIMITS = "UsageLimits";
    private static final String NODE_DATA_LIMIT = "DataLimit";
    private static final String NODE_START_DATE = "StartDate";
    private static final String NODE_TIME_LIMIT = "TimeLimit";
    private static final String NODE_USAGE_TIME_PERIOD = "UsageTimePeriod";
    private static final String NODE_CREDENTIAL_PRIORITY = "CredentialPriority";
    private static final String NODE_EXTENSION = "Extension";
    private static final String NODE_HOMESP = "HomeSP";
    private static final String NODE_FQDN = "FQDN";
    private static final String NODE_FRIENDLY_NAME = "FriendlyName";
    private static final String NODE_ROAMING_CONSORTIUM_OI = "RoamingConsortiumOI";
    private static final String NODE_NETWORK_ID = "NetworkID";
    private static final String NODE_SSID = "SSID";
    private static final String NODE_HESSID = "HESSID";
    private static final String NODE_ICON_URL = "IconURL";
    private static final String NODE_HOME_OI_LIST = "HomeOIList";
    private static final String NODE_HOME_OI = "HomeOI";
    private static final String NODE_HOME_OI_REQUIRED = "HomeOIRequired";
    private static final String NODE_OTHER_HOME_PARTNERS = "OtherHomePartners";
    private static final String NODE_CREDENTIAL = "Credential";
    private static final String NODE_CREATION_DATE = "CreationDate";
    private static final String NODE_EXPIRATION_DATE = "ExpirationDate";
    private static final String NODE_USERNAME_PASSWORD = "UsernamePassword";
    private static final String NODE_USERNAME = "Username";
    private static final String NODE_PASSWORD = "Password";
    private static final String NODE_MACHINE_MANAGED = "MachineManaged";
    private static final String NODE_SOFT_TOKEN_APP = "SoftTokenApp";
    private static final String NODE_ABLE_TO_SHARE = "AbleToShare";
    private static final String NODE_EAP_METHOD = "EAPMethod";
    private static final String NODE_EAP_TYPE = "EAPType";
    private static final String NODE_VENDOR_ID = "VendorId";
    private static final String NODE_VENDOR_TYPE = "VendorType";
    private static final String NODE_INNER_EAP_TYPE = "InnerEAPType";
    private static final String NODE_INNER_VENDOR_ID = "InnerVendorID";
    private static final String NODE_INNER_VENDOR_TYPE = "InnerVendorType";
    private static final String NODE_INNER_METHOD = "InnerMethod";
    private static final String NODE_DIGITAL_CERTIFICATE = "DigitalCertificate";
    private static final String NODE_CERTIFICATE_TYPE = "CertificateType";
    private static final String NODE_CERT_SHA256_FINGERPRINT = "CertSHA256Fingerprint";
    private static final String NODE_REALM = "Realm";
    private static final String NODE_SIM = "SIM";
    private static final String NODE_SIM_IMSI = "IMSI";
    private static final String NODE_CHECK_AAA_SERVER_CERT_STATUS = "CheckAAAServerCertStatus";
    private static final String NODE_POLICY = "Policy";
    private static final String NODE_PREFERRED_ROAMING_PARTNER_LIST = "PreferredRoamingPartnerList";
    private static final String NODE_FQDN_MATCH = "FQDN_Match";
    private static final String NODE_PRIORITY = "Priority";
    private static final String NODE_COUNTRY = "Country";
    private static final String NODE_MIN_BACKHAUL_THRESHOLD = "MinBackhaulThreshold";
    private static final String NODE_NETWORK_TYPE = "NetworkType";
    private static final String NODE_DOWNLINK_BANDWIDTH = "DLBandwidth";
    private static final String NODE_UPLINK_BANDWIDTH = "ULBandwidth";
    private static final String NODE_POLICY_UPDATE = "PolicyUpdate";
    private static final String NODE_UPDATE_INTERVAL = "UpdateInterval";
    private static final String NODE_UPDATE_METHOD = "UpdateMethod";
    private static final String NODE_RESTRICTION = "Restriction";
    private static final String NODE_URI = "URI";
    private static final String NODE_TRUST_ROOT = "TrustRoot";
    private static final String NODE_CERT_URL = "CertURL";
    private static final String NODE_SP_EXCLUSION_LIST = "SPExclusionList";
    private static final String NODE_REQUIRED_PROTO_PORT_TUPLE = "RequiredProtoPortTuple";
    private static final String NODE_IP_PROTOCOL = "IPProtocol";
    private static final String NODE_PORT_NUMBER = "PortNumber";
    private static final String NODE_MAXIMUM_BSS_LOAD_VALUE = "MaximumBSSLoadValue";
    private static final String NODE_OTHER = "Other";
    private static final String PPS_MO_URN = "urn:wfa:mo:hotspot2dot0-perprovidersubscription:1.0";

    public static PasspointConfiguration parseMoText(String xmlString) {
        XMLParser xmlParser = new XMLParser();
        XMLNode root = null;
        try {
            root = xmlParser.parse(xmlString);
        }
        catch (IOException | SAXException e) {
            return null;
        }
        if (root == null) {
            return null;
        }
        if (root.getTag() != TAG_MANAGEMENT_TREE) {
            Log.e(TAG, "Root is not a MgmtTree");
            return null;
        }
        String verDtd = null;
        PasspointConfiguration config = null;
        block12: for (XMLNode child : root.getChildren()) {
            switch (child.getTag()) {
                case "VerDTD": {
                    if (verDtd != null) {
                        Log.e(TAG, "Duplicate VerDTD element");
                        return null;
                    }
                    verDtd = child.getText();
                    continue block12;
                }
                case "Node": {
                    if (config != null) {
                        Log.e(TAG, "Unexpected multiple Node element under MgmtTree");
                        return null;
                    }
                    try {
                        config = PpsMoParser.parsePpsNode(child);
                        continue block12;
                    }
                    catch (ParsingException e) {
                        Log.e(TAG, e.getMessage());
                        return null;
                    }
                }
            }
            Log.e(TAG, "Unknown node: " + child.getTag());
            return null;
        }
        return config;
    }

    private static PasspointConfiguration parsePpsNode(XMLNode node) throws ParsingException {
        PasspointConfiguration config = null;
        String nodeName = null;
        int updateIdentifier = Integer.MIN_VALUE;
        block10: for (XMLNode child : node.getChildren()) {
            switch (child.getTag()) {
                case "NodeName": {
                    if (nodeName != null) {
                        throw new ParsingException("Duplicate NodeName: " + child.getText());
                    }
                    nodeName = child.getText();
                    if (TextUtils.equals(nodeName, NODE_PER_PROVIDER_SUBSCRIPTION)) continue block10;
                    throw new ParsingException("Unexpected NodeName: " + nodeName);
                }
                case "Node": {
                    PPSNode ppsNodeRoot = PpsMoParser.buildPpsNode(child);
                    if (TextUtils.equals(ppsNodeRoot.getName(), NODE_UPDATE_IDENTIFIER)) {
                        if (updateIdentifier != Integer.MIN_VALUE) {
                            throw new ParsingException("Multiple node for UpdateIdentifier");
                        }
                        updateIdentifier = PpsMoParser.parseInteger(PpsMoParser.getPpsNodeValue(ppsNodeRoot));
                        continue block10;
                    }
                    if (config != null) {
                        throw new ParsingException("Multiple PPS instance");
                    }
                    config = PpsMoParser.parsePpsInstance(ppsNodeRoot);
                    continue block10;
                }
                case "RTProperties": {
                    String urn = PpsMoParser.parseUrn(child);
                    if (TextUtils.equals(urn, PPS_MO_URN)) continue block10;
                    throw new ParsingException("Unknown URN: " + urn);
                }
            }
            throw new ParsingException("Unknown tag under PPS node: " + child.getTag());
        }
        if (config != null && updateIdentifier != Integer.MIN_VALUE) {
            config.setUpdateIdentifier(updateIdentifier);
        }
        return config;
    }

    private static String parseUrn(XMLNode node) throws ParsingException {
        if (node.getChildren().size() != 1) {
            throw new ParsingException("Expect RTPProperties node to only have one child");
        }
        XMLNode typeNode = node.getChildren().get(0);
        if (typeNode.getChildren().size() != 1) {
            throw new ParsingException("Expect Type node to only have one child");
        }
        if (!TextUtils.equals(typeNode.getTag(), TAG_TYPE)) {
            throw new ParsingException("Unexpected tag for Type: " + typeNode.getTag());
        }
        XMLNode ddfNameNode = typeNode.getChildren().get(0);
        if (!ddfNameNode.getChildren().isEmpty()) {
            throw new ParsingException("Expect DDFName node to have no child");
        }
        if (!TextUtils.equals(ddfNameNode.getTag(), TAG_DDF_NAME)) {
            throw new ParsingException("Unexpected tag for DDFName: " + ddfNameNode.getTag());
        }
        return ddfNameNode.getText();
    }

    private static PPSNode buildPpsNode(XMLNode node) throws ParsingException {
        String nodeName = null;
        String nodeValue = null;
        ArrayList<PPSNode> childNodes = new ArrayList<PPSNode>();
        HashSet<String> parsedNodes = new HashSet<String>();
        for (XMLNode child : node.getChildren()) {
            String tag = child.getTag();
            if (TextUtils.equals(tag, TAG_NODE_NAME)) {
                if (nodeName != null) {
                    throw new ParsingException("Duplicate NodeName node");
                }
                nodeName = child.getText();
                continue;
            }
            if (TextUtils.equals(tag, TAG_NODE)) {
                PPSNode ppsNode = PpsMoParser.buildPpsNode(child);
                if (parsedNodes.contains(ppsNode.getName())) {
                    throw new ParsingException("Duplicate node: " + ppsNode.getName());
                }
                parsedNodes.add(ppsNode.getName());
                childNodes.add(ppsNode);
                continue;
            }
            if (TextUtils.equals(tag, TAG_VALUE)) {
                if (nodeValue != null) {
                    throw new ParsingException("Duplicate Value node");
                }
                nodeValue = child.getText();
                continue;
            }
            throw new ParsingException("Unknown tag: " + tag);
        }
        if (nodeName == null) {
            throw new ParsingException("Invalid node: missing NodeName");
        }
        if (nodeValue == null && childNodes.size() == 0) {
            throw new ParsingException("Invalid node: " + nodeName + " missing both value and children");
        }
        if (nodeValue != null && childNodes.size() > 0) {
            throw new ParsingException("Invalid node: " + nodeName + " contained both value and children");
        }
        if (nodeValue != null) {
            return new LeafNode(nodeName, nodeValue);
        }
        return new InternalNode(nodeName, childNodes);
    }

    private static String getPpsNodeValue(PPSNode node) throws ParsingException {
        if (!node.isLeaf()) {
            throw new ParsingException("Cannot get value from a non-leaf node: " + node.getName());
        }
        return node.getValue();
    }

    private static PasspointConfiguration parsePpsInstance(PPSNode root) throws ParsingException {
        if (root.isLeaf()) {
            throw new ParsingException("Leaf node not expected for PPS instance");
        }
        PasspointConfiguration config = new PasspointConfiguration();
        block20: for (PPSNode child : root.getChildren()) {
            switch (child.getName()) {
                case "HomeSP": {
                    config.setHomeSp(PpsMoParser.parseHomeSP(child));
                    continue block20;
                }
                case "Credential": {
                    config.setCredential(PpsMoParser.parseCredential(child));
                    continue block20;
                }
                case "Policy": {
                    config.setPolicy(PpsMoParser.parsePolicy(child));
                    continue block20;
                }
                case "AAAServerTrustRoot": {
                    config.setTrustRootCertList(PpsMoParser.parseAAAServerTrustRootList(child));
                    continue block20;
                }
                case "SubscriptionUpdate": {
                    config.setSubscriptionUpdate(PpsMoParser.parseUpdateParameter(child));
                    continue block20;
                }
                case "SubscriptionParameters": {
                    PpsMoParser.parseSubscriptionParameter(child, config);
                    continue block20;
                }
                case "CredentialPriority": {
                    config.setCredentialPriority(PpsMoParser.parseInteger(PpsMoParser.getPpsNodeValue(child)));
                    continue block20;
                }
                case "Extension": {
                    Log.d(TAG, "Ignore Extension node for vendor specific information");
                    continue block20;
                }
            }
            throw new ParsingException("Unknown node: " + child.getName());
        }
        return config;
    }

    private static HomeSp parseHomeSP(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for HomeSP");
        }
        HomeSp homeSp = new HomeSp();
        block18: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "FQDN": {
                    homeSp.setFqdn(PpsMoParser.getPpsNodeValue(child));
                    continue block18;
                }
                case "FriendlyName": {
                    homeSp.setFriendlyName(PpsMoParser.getPpsNodeValue(child));
                    continue block18;
                }
                case "RoamingConsortiumOI": {
                    homeSp.setRoamingConsortiumOis(PpsMoParser.parseRoamingConsortiumOI(PpsMoParser.getPpsNodeValue(child)));
                    continue block18;
                }
                case "IconURL": {
                    homeSp.setIconUrl(PpsMoParser.getPpsNodeValue(child));
                    continue block18;
                }
                case "NetworkID": {
                    homeSp.setHomeNetworkIds(PpsMoParser.parseNetworkIds(child));
                    continue block18;
                }
                case "HomeOIList": {
                    Pair<List<Long>, List<Long>> homeOIs = PpsMoParser.parseHomeOIList(child);
                    homeSp.setMatchAllOis(PpsMoParser.convertFromLongList((List)homeOIs.first));
                    homeSp.setMatchAnyOis(PpsMoParser.convertFromLongList((List)homeOIs.second));
                    continue block18;
                }
                case "OtherHomePartners": {
                    homeSp.setOtherHomePartners(PpsMoParser.parseOtherHomePartners(child));
                    continue block18;
                }
            }
            throw new ParsingException("Unknown node under HomeSP: " + child.getName());
        }
        return homeSp;
    }

    private static long[] parseRoamingConsortiumOI(String oiStr) throws ParsingException {
        String[] oiStrArray = oiStr.split(",");
        long[] oiArray = new long[oiStrArray.length];
        for (int i = 0; i < oiStrArray.length; ++i) {
            oiArray[i] = PpsMoParser.parseLong(oiStrArray[i], 16);
        }
        return oiArray;
    }

    private static Map<String, Long> parseNetworkIds(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for NetworkID");
        }
        HashMap<String, Long> networkIds = new HashMap<String, Long>();
        for (PPSNode child : node.getChildren()) {
            Pair<String, Long> networkId = PpsMoParser.parseNetworkIdInstance(child);
            networkIds.put((String)networkId.first, (Long)networkId.second);
        }
        return networkIds;
    }

    private static Pair<String, Long> parseNetworkIdInstance(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for NetworkID instance");
        }
        String ssid = null;
        Long hessid = null;
        block8: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "SSID": {
                    ssid = PpsMoParser.getPpsNodeValue(child);
                    continue block8;
                }
                case "HESSID": {
                    hessid = PpsMoParser.parseLong(PpsMoParser.getPpsNodeValue(child), 16);
                    continue block8;
                }
            }
            throw new ParsingException("Unknown node under NetworkID instance: " + child.getName());
        }
        if (ssid == null) {
            throw new ParsingException("NetworkID instance missing SSID");
        }
        return new Pair<Object, Object>(ssid, hessid);
    }

    private static Pair<List<Long>, List<Long>> parseHomeOIList(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for HomeOIList");
        }
        ArrayList<Long> matchAllOIs = new ArrayList<Long>();
        ArrayList<Long> matchAnyOIs = new ArrayList<Long>();
        for (PPSNode child : node.getChildren()) {
            Pair<Long, Boolean> homeOI = PpsMoParser.parseHomeOIInstance(child);
            if (((Boolean)homeOI.second).booleanValue()) {
                matchAllOIs.add((Long)homeOI.first);
                continue;
            }
            matchAnyOIs.add((Long)homeOI.first);
        }
        return new Pair<List<Long>, List<Long>>(matchAllOIs, matchAnyOIs);
    }

    private static Pair<Long, Boolean> parseHomeOIInstance(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for HomeOI instance");
        }
        Long oi = null;
        Boolean required = null;
        block10: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "HomeOI": {
                    try {
                        oi = Long.valueOf(PpsMoParser.getPpsNodeValue(child), 16);
                        continue block10;
                    }
                    catch (NumberFormatException e) {
                        throw new ParsingException("Invalid HomeOI: " + PpsMoParser.getPpsNodeValue(child));
                    }
                }
                case "HomeOIRequired": {
                    required = Boolean.valueOf(PpsMoParser.getPpsNodeValue(child));
                    continue block10;
                }
            }
            throw new ParsingException("Unknown node under NetworkID instance: " + child.getName());
        }
        if (oi == null) {
            throw new ParsingException("HomeOI instance missing OI field");
        }
        if (required == null) {
            throw new ParsingException("HomeOI instance missing required field");
        }
        return new Pair<Object, Object>(oi, required);
    }

    private static String[] parseOtherHomePartners(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for OtherHomePartners");
        }
        ArrayList<String> otherHomePartners = new ArrayList<String>();
        for (PPSNode child : node.getChildren()) {
            String fqdn = PpsMoParser.parseOtherHomePartnerInstance(child);
            otherHomePartners.add(fqdn);
        }
        return otherHomePartners.toArray(new String[otherHomePartners.size()]);
    }

    private static String parseOtherHomePartnerInstance(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for OtherHomePartner instance");
        }
        String fqdn = null;
        block6: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "FQDN": {
                    fqdn = PpsMoParser.getPpsNodeValue(child);
                    continue block6;
                }
            }
            throw new ParsingException("Unknown node under OtherHomePartner instance: " + child.getName());
        }
        if (fqdn == null) {
            throw new ParsingException("OtherHomePartner instance missing FQDN field");
        }
        return fqdn;
    }

    private static Credential parseCredential(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for HomeSP");
        }
        Credential credential = new Credential();
        block18: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "CreationDate": {
                    credential.setCreationTimeInMillis(PpsMoParser.parseDate(PpsMoParser.getPpsNodeValue(child)));
                    continue block18;
                }
                case "ExpirationDate": {
                    credential.setExpirationTimeInMillis(PpsMoParser.parseDate(PpsMoParser.getPpsNodeValue(child)));
                    continue block18;
                }
                case "UsernamePassword": {
                    credential.setUserCredential(PpsMoParser.parseUserCredential(child));
                    continue block18;
                }
                case "DigitalCertificate": {
                    credential.setCertCredential(PpsMoParser.parseCertificateCredential(child));
                    continue block18;
                }
                case "Realm": {
                    credential.setRealm(PpsMoParser.getPpsNodeValue(child));
                    continue block18;
                }
                case "CheckAAAServerCertStatus": {
                    credential.setCheckAaaServerCertStatus(Boolean.parseBoolean(PpsMoParser.getPpsNodeValue(child)));
                    continue block18;
                }
                case "SIM": {
                    credential.setSimCredential(PpsMoParser.parseSimCredential(child));
                    continue block18;
                }
            }
            throw new ParsingException("Unknown node under Credential: " + child.getName());
        }
        return credential;
    }

    private static Credential.UserCredential parseUserCredential(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for UsernamePassword");
        }
        Credential.UserCredential userCred = new Credential.UserCredential();
        block16: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "Username": {
                    userCred.setUsername(PpsMoParser.getPpsNodeValue(child));
                    continue block16;
                }
                case "Password": {
                    userCred.setPassword(PpsMoParser.getPpsNodeValue(child));
                    continue block16;
                }
                case "MachineManaged": {
                    userCred.setMachineManaged(Boolean.parseBoolean(PpsMoParser.getPpsNodeValue(child)));
                    continue block16;
                }
                case "SoftTokenApp": {
                    userCred.setSoftTokenApp(PpsMoParser.getPpsNodeValue(child));
                    continue block16;
                }
                case "AbleToShare": {
                    userCred.setAbleToShare(Boolean.parseBoolean(PpsMoParser.getPpsNodeValue(child)));
                    continue block16;
                }
                case "EAPMethod": {
                    PpsMoParser.parseEAPMethod(child, userCred);
                    continue block16;
                }
            }
            throw new ParsingException("Unknown node under UsernamPassword: " + child.getName());
        }
        return userCred;
    }

    private static void parseEAPMethod(PPSNode node, Credential.UserCredential userCred) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for EAPMethod");
        }
        block14: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "EAPType": {
                    userCred.setEapType(PpsMoParser.parseInteger(PpsMoParser.getPpsNodeValue(child)));
                    continue block14;
                }
                case "InnerMethod": {
                    userCred.setNonEapInnerMethod(PpsMoParser.getPpsNodeValue(child));
                    continue block14;
                }
                case "VendorId": 
                case "VendorType": 
                case "InnerEAPType": 
                case "InnerVendorID": 
                case "InnerVendorType": {
                    Log.d(TAG, "Ignore unsupported EAP method parameter: " + child.getName());
                    continue block14;
                }
            }
            throw new ParsingException("Unknown node under EAPMethod: " + child.getName());
        }
    }

    private static Credential.CertificateCredential parseCertificateCredential(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for DigitalCertificate");
        }
        Credential.CertificateCredential certCred = new Credential.CertificateCredential();
        block8: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "CertificateType": {
                    certCred.setCertType(PpsMoParser.getPpsNodeValue(child));
                    continue block8;
                }
                case "CertSHA256Fingerprint": {
                    certCred.setCertSha256Fingerprint(PpsMoParser.parseHexString(PpsMoParser.getPpsNodeValue(child)));
                    continue block8;
                }
            }
            throw new ParsingException("Unknown node under DigitalCertificate: " + child.getName());
        }
        return certCred;
    }

    private static Credential.SimCredential parseSimCredential(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for SIM");
        }
        Credential.SimCredential simCred = new Credential.SimCredential();
        block8: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "IMSI": {
                    simCred.setImsi(PpsMoParser.getPpsNodeValue(child));
                    continue block8;
                }
                case "EAPType": {
                    simCred.setEapType(PpsMoParser.parseInteger(PpsMoParser.getPpsNodeValue(child)));
                    continue block8;
                }
            }
            throw new ParsingException("Unknown node under SIM: " + child.getName());
        }
        return simCred;
    }

    private static Policy parsePolicy(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for Policy");
        }
        Policy policy = new Policy();
        block16: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "PreferredRoamingPartnerList": {
                    policy.setPreferredRoamingPartnerList(PpsMoParser.parsePreferredRoamingPartnerList(child));
                    continue block16;
                }
                case "MinBackhaulThreshold": {
                    PpsMoParser.parseMinBackhaulThreshold(child, policy);
                    continue block16;
                }
                case "PolicyUpdate": {
                    policy.setPolicyUpdate(PpsMoParser.parseUpdateParameter(child));
                    continue block16;
                }
                case "SPExclusionList": {
                    policy.setExcludedSsidList(PpsMoParser.parseSpExclusionList(child));
                    continue block16;
                }
                case "RequiredProtoPortTuple": {
                    policy.setRequiredProtoPortMap(PpsMoParser.parseRequiredProtoPortTuple(child));
                    continue block16;
                }
                case "MaximumBSSLoadValue": {
                    policy.setMaximumBssLoadValue(PpsMoParser.parseInteger(PpsMoParser.getPpsNodeValue(child)));
                    continue block16;
                }
            }
            throw new ParsingException("Unknown node under Policy: " + child.getName());
        }
        return policy;
    }

    private static List<Policy.RoamingPartner> parsePreferredRoamingPartnerList(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for PreferredRoamingPartnerList");
        }
        ArrayList<Policy.RoamingPartner> partnerList = new ArrayList<Policy.RoamingPartner>();
        for (PPSNode child : node.getChildren()) {
            partnerList.add(PpsMoParser.parsePreferredRoamingPartner(child));
        }
        return partnerList;
    }

    private static Policy.RoamingPartner parsePreferredRoamingPartner(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for PreferredRoamingPartner instance");
        }
        Policy.RoamingPartner roamingPartner = new Policy.RoamingPartner();
        block10: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "FQDN_Match": {
                    String fqdnMatch = PpsMoParser.getPpsNodeValue(child);
                    String[] fqdnMatchArray = fqdnMatch.split(",");
                    if (fqdnMatchArray.length != 2) {
                        throw new ParsingException("Invalid FQDN_Match: " + fqdnMatch);
                    }
                    roamingPartner.setFqdn(fqdnMatchArray[0]);
                    if (TextUtils.equals(fqdnMatchArray[1], "exactMatch")) {
                        roamingPartner.setFqdnExactMatch(true);
                        continue block10;
                    }
                    if (TextUtils.equals(fqdnMatchArray[1], "includeSubdomains")) {
                        roamingPartner.setFqdnExactMatch(false);
                        continue block10;
                    }
                    throw new ParsingException("Invalid FQDN_Match: " + fqdnMatch);
                }
                case "Priority": {
                    roamingPartner.setPriority(PpsMoParser.parseInteger(PpsMoParser.getPpsNodeValue(child)));
                    continue block10;
                }
                case "Country": {
                    roamingPartner.setCountries(PpsMoParser.getPpsNodeValue(child));
                    continue block10;
                }
            }
            throw new ParsingException("Unknown node under PreferredRoamingPartnerList instance " + child.getName());
        }
        return roamingPartner;
    }

    private static void parseMinBackhaulThreshold(PPSNode node, Policy policy) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for MinBackhaulThreshold");
        }
        for (PPSNode child : node.getChildren()) {
            PpsMoParser.parseMinBackhaulThresholdInstance(child, policy);
        }
    }

    private static void parseMinBackhaulThresholdInstance(PPSNode node, Policy policy) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for MinBackhaulThreshold instance");
        }
        String networkType = null;
        long downlinkBandwidth = Long.MIN_VALUE;
        long uplinkBandwidth = Long.MIN_VALUE;
        block10: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "NetworkType": {
                    networkType = PpsMoParser.getPpsNodeValue(child);
                    continue block10;
                }
                case "DLBandwidth": {
                    downlinkBandwidth = PpsMoParser.parseLong(PpsMoParser.getPpsNodeValue(child), 10);
                    continue block10;
                }
                case "ULBandwidth": {
                    uplinkBandwidth = PpsMoParser.parseLong(PpsMoParser.getPpsNodeValue(child), 10);
                    continue block10;
                }
            }
            throw new ParsingException("Unknown node under MinBackhaulThreshold instance " + child.getName());
        }
        if (networkType == null) {
            throw new ParsingException("Missing NetworkType field");
        }
        if (TextUtils.equals(networkType, "home")) {
            policy.setMinHomeDownlinkBandwidth(downlinkBandwidth);
            policy.setMinHomeUplinkBandwidth(uplinkBandwidth);
        } else if (TextUtils.equals(networkType, "roaming")) {
            policy.setMinRoamingDownlinkBandwidth(downlinkBandwidth);
            policy.setMinRoamingUplinkBandwidth(uplinkBandwidth);
        } else {
            throw new ParsingException("Invalid network type: " + networkType);
        }
    }

    private static UpdateParameter parseUpdateParameter(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for Update Parameters");
        }
        UpdateParameter updateParam = new UpdateParameter();
        block18: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "UpdateInterval": {
                    updateParam.setUpdateIntervalInMinutes(PpsMoParser.parseLong(PpsMoParser.getPpsNodeValue(child), 10));
                    continue block18;
                }
                case "UpdateMethod": {
                    updateParam.setUpdateMethod(PpsMoParser.getPpsNodeValue(child));
                    continue block18;
                }
                case "Restriction": {
                    updateParam.setRestriction(PpsMoParser.getPpsNodeValue(child));
                    continue block18;
                }
                case "URI": {
                    updateParam.setServerUri(PpsMoParser.getPpsNodeValue(child));
                    continue block18;
                }
                case "UsernamePassword": {
                    Pair<String, String> usernamePassword = PpsMoParser.parseUpdateUserCredential(child);
                    updateParam.setUsername((String)usernamePassword.first);
                    updateParam.setBase64EncodedPassword((String)usernamePassword.second);
                    continue block18;
                }
                case "TrustRoot": {
                    Pair<String, byte[]> trustRoot = PpsMoParser.parseTrustRoot(child);
                    updateParam.setTrustRootCertUrl((String)trustRoot.first);
                    updateParam.setTrustRootCertSha256Fingerprint((byte[])trustRoot.second);
                    continue block18;
                }
                case "Other": {
                    Log.d(TAG, "Ignore unsupported paramter: " + child.getName());
                    continue block18;
                }
            }
            throw new ParsingException("Unknown node under Update Parameters: " + child.getName());
        }
        return updateParam;
    }

    private static Pair<String, String> parseUpdateUserCredential(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for UsernamePassword");
        }
        String username = null;
        String password = null;
        block8: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "Username": {
                    username = PpsMoParser.getPpsNodeValue(child);
                    continue block8;
                }
                case "Password": {
                    password = PpsMoParser.getPpsNodeValue(child);
                    continue block8;
                }
            }
            throw new ParsingException("Unknown node under UsernamePassword: " + child.getName());
        }
        return Pair.create(username, password);
    }

    private static Pair<String, byte[]> parseTrustRoot(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for TrustRoot");
        }
        String certUrl = null;
        byte[] certFingerprint = null;
        block8: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "CertURL": {
                    certUrl = PpsMoParser.getPpsNodeValue(child);
                    continue block8;
                }
                case "CertSHA256Fingerprint": {
                    certFingerprint = PpsMoParser.parseHexString(PpsMoParser.getPpsNodeValue(child));
                    continue block8;
                }
            }
            throw new ParsingException("Unknown node under TrustRoot: " + child.getName());
        }
        return Pair.create(certUrl, certFingerprint);
    }

    private static String[] parseSpExclusionList(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for SPExclusionList");
        }
        ArrayList<String> ssidList = new ArrayList<String>();
        for (PPSNode child : node.getChildren()) {
            ssidList.add(PpsMoParser.parseSpExclusionInstance(child));
        }
        return ssidList.toArray(new String[ssidList.size()]);
    }

    private static String parseSpExclusionInstance(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for SPExclusion instance");
        }
        String ssid = null;
        block6: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "SSID": {
                    ssid = PpsMoParser.getPpsNodeValue(child);
                    continue block6;
                }
            }
            throw new ParsingException("Unknown node under SPExclusion instance");
        }
        return ssid;
    }

    private static Map<Integer, String> parseRequiredProtoPortTuple(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for RequiredProtoPortTuple");
        }
        HashMap<Integer, String> protoPortTupleMap = new HashMap<Integer, String>();
        for (PPSNode child : node.getChildren()) {
            Pair<Integer, String> protoPortTuple = PpsMoParser.parseProtoPortTuple(child);
            protoPortTupleMap.put((Integer)protoPortTuple.first, (String)protoPortTuple.second);
        }
        return protoPortTupleMap;
    }

    private static Pair<Integer, String> parseProtoPortTuple(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for RequiredProtoPortTuple instance");
        }
        int proto = Integer.MIN_VALUE;
        String ports = null;
        block8: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "IPProtocol": {
                    proto = PpsMoParser.parseInteger(PpsMoParser.getPpsNodeValue(child));
                    continue block8;
                }
                case "PortNumber": {
                    ports = PpsMoParser.getPpsNodeValue(child);
                    continue block8;
                }
            }
            throw new ParsingException("Unknown node under RequiredProtoPortTuple instance" + child.getName());
        }
        if (proto == Integer.MIN_VALUE) {
            throw new ParsingException("Missing IPProtocol field");
        }
        if (ports == null) {
            throw new ParsingException("Missing PortNumber field");
        }
        return Pair.create(proto, ports);
    }

    private static Map<String, byte[]> parseAAAServerTrustRootList(PPSNode node) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for AAAServerTrustRoot");
        }
        HashMap<String, byte[]> certList = new HashMap<String, byte[]>();
        for (PPSNode child : node.getChildren()) {
            Pair<String, byte[]> certTuple = PpsMoParser.parseTrustRoot(child);
            certList.put((String)certTuple.first, (byte[])certTuple.second);
        }
        return certList;
    }

    private static void parseSubscriptionParameter(PPSNode node, PasspointConfiguration config) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for SubscriptionParameter");
        }
        block12: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "CreationDate": {
                    config.setSubscriptionCreationTimeInMillis(PpsMoParser.parseDate(PpsMoParser.getPpsNodeValue(child)));
                    continue block12;
                }
                case "ExpirationDate": {
                    config.setSubscriptionExpirationTimeInMillis(PpsMoParser.parseDate(PpsMoParser.getPpsNodeValue(child)));
                    continue block12;
                }
                case "TypeOfSubscription": {
                    config.setSubscriptionType(PpsMoParser.getPpsNodeValue(child));
                    continue block12;
                }
                case "UsageLimits": {
                    PpsMoParser.parseUsageLimits(child, config);
                    continue block12;
                }
            }
            throw new ParsingException("Unknown node under SubscriptionParameter" + child.getName());
        }
    }

    private static void parseUsageLimits(PPSNode node, PasspointConfiguration config) throws ParsingException {
        if (node.isLeaf()) {
            throw new ParsingException("Leaf node not expected for UsageLimits");
        }
        block12: for (PPSNode child : node.getChildren()) {
            switch (child.getName()) {
                case "DataLimit": {
                    config.setUsageLimitDataLimit(PpsMoParser.parseLong(PpsMoParser.getPpsNodeValue(child), 10));
                    continue block12;
                }
                case "StartDate": {
                    config.setUsageLimitStartTimeInMillis(PpsMoParser.parseDate(PpsMoParser.getPpsNodeValue(child)));
                    continue block12;
                }
                case "TimeLimit": {
                    config.setUsageLimitTimeLimitInMinutes(PpsMoParser.parseLong(PpsMoParser.getPpsNodeValue(child), 10));
                    continue block12;
                }
                case "UsageTimePeriod": {
                    config.setUsageLimitUsageTimePeriodInMinutes(PpsMoParser.parseLong(PpsMoParser.getPpsNodeValue(child), 10));
                    continue block12;
                }
            }
            throw new ParsingException("Unknown node under UsageLimits" + child.getName());
        }
    }

    private static byte[] parseHexString(String str) throws ParsingException {
        if ((str.length() & 1) == 1) {
            throw new ParsingException("Odd length hex string: " + str.length());
        }
        byte[] result = new byte[str.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int index = i * 2;
            try {
                result[i] = (byte)Integer.parseInt(str.substring(index, index + 2), 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParsingException("Invalid hex string: " + str);
            }
        }
        return result;
    }

    private static long parseDate(String dateStr) throws ParsingException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return format.parse(dateStr).getTime();
        }
        catch (ParseException pe) {
            throw new ParsingException("Badly formatted time: " + dateStr);
        }
    }

    private static int parseInteger(String value) throws ParsingException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid integer value: " + value);
        }
    }

    private static long parseLong(String value, int radix) throws ParsingException {
        try {
            return Long.parseLong(value, radix);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid long integer value: " + value);
        }
    }

    private static long[] convertFromLongList(List<Long> list) {
        Long[] objectArray = list.toArray(new Long[list.size()]);
        long[] primitiveArray = new long[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            primitiveArray[i] = objectArray[i];
        }
        return primitiveArray;
    }

    private static class InternalNode
    extends PPSNode {
        private final List<PPSNode> mChildren;

        public InternalNode(String nodeName, List<PPSNode> children) {
            super(nodeName);
            this.mChildren = children;
        }

        @Override
        public String getValue() {
            return null;
        }

        @Override
        public List<PPSNode> getChildren() {
            return this.mChildren;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    private static class LeafNode
    extends PPSNode {
        private final String mValue;

        public LeafNode(String nodeName, String value) {
            super(nodeName);
            this.mValue = value;
        }

        @Override
        public String getValue() {
            return this.mValue;
        }

        @Override
        public List<PPSNode> getChildren() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    private static abstract class PPSNode {
        private final String mName;

        public PPSNode(String name) {
            this.mName = name;
        }

        public String getName() {
            return this.mName;
        }

        public abstract List<PPSNode> getChildren();

        public abstract String getValue();

        public abstract boolean isLeaf();
    }

    private static class ParsingException
    extends Exception {
        public ParsingException(String message) {
            super(message);
        }
    }
}

