/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.pps;

import android.net.wifi.ParcelUtil;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class Credential
implements Parcelable {
    private static final String TAG = "Credential";
    private static final int MAX_REALM_BYTES = 253;
    private long mCreationTimeInMillis = Long.MIN_VALUE;
    private long mExpirationTimeInMillis = Long.MIN_VALUE;
    private String mRealm = null;
    private boolean mCheckAaaServerCertStatus = false;
    private UserCredential mUserCredential = null;
    private CertificateCredential mCertCredential = null;
    private SimCredential mSimCredential = null;
    private X509Certificate[] mCaCertificates = null;
    private X509Certificate[] mClientCertificateChain = null;
    private PrivateKey mClientPrivateKey = null;
    public static final Parcelable.Creator<Credential> CREATOR = new Parcelable.Creator<Credential>(){

        @Override
        public Credential createFromParcel(Parcel in) {
            Credential credential = new Credential();
            credential.setCreationTimeInMillis(in.readLong());
            credential.setExpirationTimeInMillis(in.readLong());
            credential.setRealm(in.readString());
            credential.setCheckAaaServerCertStatus(in.readInt() != 0);
            credential.setUserCredential((UserCredential)in.readParcelable(null));
            credential.setCertCredential((CertificateCredential)in.readParcelable(null));
            credential.setSimCredential((SimCredential)in.readParcelable(null));
            credential.setCaCertificates(ParcelUtil.readCertificates(in));
            credential.setClientCertificateChain(ParcelUtil.readCertificates(in));
            credential.setClientPrivateKey(ParcelUtil.readPrivateKey(in));
            return credential;
        }

        public Credential[] newArray(int size) {
            return new Credential[size];
        }
    };

    public void setCreationTimeInMillis(long creationTimeInMillis) {
        this.mCreationTimeInMillis = creationTimeInMillis;
    }

    public long getCreationTimeInMillis() {
        return this.mCreationTimeInMillis;
    }

    public void setExpirationTimeInMillis(long expirationTimeInMillis) {
        this.mExpirationTimeInMillis = expirationTimeInMillis;
    }

    public long getExpirationTimeInMillis() {
        return this.mExpirationTimeInMillis;
    }

    public void setRealm(String realm) {
        this.mRealm = realm;
    }

    public String getRealm() {
        return this.mRealm;
    }

    public void setCheckAaaServerCertStatus(boolean checkAaaServerCertStatus) {
        this.mCheckAaaServerCertStatus = checkAaaServerCertStatus;
    }

    public boolean getCheckAaaServerCertStatus() {
        return this.mCheckAaaServerCertStatus;
    }

    public void setUserCredential(UserCredential userCredential) {
        this.mUserCredential = userCredential;
    }

    public UserCredential getUserCredential() {
        return this.mUserCredential;
    }

    public void setCertCredential(CertificateCredential certCredential) {
        this.mCertCredential = certCredential;
    }

    public CertificateCredential getCertCredential() {
        return this.mCertCredential;
    }

    public void setSimCredential(SimCredential simCredential) {
        this.mSimCredential = simCredential;
    }

    public SimCredential getSimCredential() {
        return this.mSimCredential;
    }

    public void setCaCertificate(X509Certificate caCertificate) {
        this.mCaCertificates = null;
        if (caCertificate != null) {
            this.mCaCertificates = new X509Certificate[]{caCertificate};
        }
    }

    public void setCaCertificates(X509Certificate[] caCertificates) {
        this.mCaCertificates = caCertificates;
    }

    public X509Certificate getCaCertificate() {
        return this.mCaCertificates == null || this.mCaCertificates.length > 1 ? null : this.mCaCertificates[0];
    }

    public X509Certificate[] getCaCertificates() {
        return this.mCaCertificates;
    }

    public void setClientCertificateChain(X509Certificate[] certificateChain) {
        this.mClientCertificateChain = certificateChain;
    }

    public X509Certificate[] getClientCertificateChain() {
        return this.mClientCertificateChain;
    }

    public void setClientPrivateKey(PrivateKey clientPrivateKey) {
        this.mClientPrivateKey = clientPrivateKey;
    }

    public PrivateKey getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    public Credential() {
    }

    public Credential(Credential source) {
        if (source != null) {
            this.mCreationTimeInMillis = source.mCreationTimeInMillis;
            this.mExpirationTimeInMillis = source.mExpirationTimeInMillis;
            this.mRealm = source.mRealm;
            this.mCheckAaaServerCertStatus = source.mCheckAaaServerCertStatus;
            if (source.mUserCredential != null) {
                this.mUserCredential = new UserCredential(source.mUserCredential);
            }
            if (source.mCertCredential != null) {
                this.mCertCredential = new CertificateCredential(source.mCertCredential);
            }
            if (source.mSimCredential != null) {
                this.mSimCredential = new SimCredential(source.mSimCredential);
            }
            if (source.mClientCertificateChain != null) {
                this.mClientCertificateChain = Arrays.copyOf(source.mClientCertificateChain, source.mClientCertificateChain.length);
            }
            if (source.mCaCertificates != null) {
                this.mCaCertificates = Arrays.copyOf(source.mCaCertificates, source.mCaCertificates.length);
            }
            this.mClientPrivateKey = source.mClientPrivateKey;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mCreationTimeInMillis);
        dest.writeLong(this.mExpirationTimeInMillis);
        dest.writeString(this.mRealm);
        dest.writeInt(this.mCheckAaaServerCertStatus ? 1 : 0);
        dest.writeParcelable(this.mUserCredential, flags);
        dest.writeParcelable(this.mCertCredential, flags);
        dest.writeParcelable(this.mSimCredential, flags);
        ParcelUtil.writeCertificates(dest, this.mCaCertificates);
        ParcelUtil.writeCertificates(dest, this.mClientCertificateChain);
        ParcelUtil.writePrivateKey(dest, this.mClientPrivateKey);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Credential)) {
            return false;
        }
        Credential that = (Credential)thatObject;
        return TextUtils.equals(this.mRealm, that.mRealm) && this.mCreationTimeInMillis == that.mCreationTimeInMillis && this.mExpirationTimeInMillis == that.mExpirationTimeInMillis && this.mCheckAaaServerCertStatus == that.mCheckAaaServerCertStatus && (this.mUserCredential == null ? that.mUserCredential == null : this.mUserCredential.equals(that.mUserCredential)) && (this.mCertCredential == null ? that.mCertCredential == null : this.mCertCredential.equals(that.mCertCredential)) && (this.mSimCredential == null ? that.mSimCredential == null : this.mSimCredential.equals(that.mSimCredential)) && Credential.isX509CertificatesEquals(this.mCaCertificates, that.mCaCertificates) && Credential.isX509CertificatesEquals(this.mClientCertificateChain, that.mClientCertificateChain) && Credential.isPrivateKeyEquals(this.mClientPrivateKey, that.mClientPrivateKey);
    }

    public int hashCode() {
        return Objects.hash(this.mCreationTimeInMillis, this.mExpirationTimeInMillis, this.mRealm, this.mCheckAaaServerCertStatus, this.mUserCredential, this.mCertCredential, this.mSimCredential, this.mClientPrivateKey, Arrays.hashCode(this.mCaCertificates), Arrays.hashCode(this.mClientCertificateChain));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Realm: ").append(this.mRealm).append("\n");
        builder.append("CreationTime: ").append(this.mCreationTimeInMillis != Long.MIN_VALUE ? new Date(this.mCreationTimeInMillis) : "Not specified").append("\n");
        builder.append("ExpirationTime: ").append(this.mExpirationTimeInMillis != Long.MIN_VALUE ? new Date(this.mExpirationTimeInMillis) : "Not specified").append("\n");
        builder.append("CheckAAAServerStatus: ").append(this.mCheckAaaServerCertStatus).append("\n");
        if (this.mUserCredential != null) {
            builder.append("UserCredential Begin ---\n");
            builder.append(this.mUserCredential);
            builder.append("UserCredential End ---\n");
        }
        if (this.mCertCredential != null) {
            builder.append("CertificateCredential Begin ---\n");
            builder.append(this.mCertCredential);
            builder.append("CertificateCredential End ---\n");
        }
        if (this.mSimCredential != null) {
            builder.append("SIMCredential Begin ---\n");
            builder.append(this.mSimCredential);
            builder.append("SIMCredential End ---\n");
        }
        return builder.toString();
    }

    public boolean validate(boolean isR1) {
        if (TextUtils.isEmpty(this.mRealm)) {
            Log.d(TAG, "Missing realm");
            return false;
        }
        if (this.mRealm.getBytes(StandardCharsets.UTF_8).length > 253) {
            Log.d(TAG, "realm exceeding maximum length: " + this.mRealm.getBytes(StandardCharsets.UTF_8).length);
            return false;
        }
        if (this.mUserCredential != null) {
            if (!this.verifyUserCredential(isR1)) {
                return false;
            }
        } else if (this.mCertCredential != null) {
            if (!this.verifyCertCredential(isR1)) {
                return false;
            }
        } else if (this.mSimCredential != null) {
            if (!this.verifySimCredential()) {
                return false;
            }
        } else {
            Log.d(TAG, "Missing required credential");
            return false;
        }
        return true;
    }

    private boolean verifyUserCredential(boolean isR1) {
        if (this.mUserCredential == null) {
            Log.d(TAG, "Missing user credential");
            return false;
        }
        if (this.mCertCredential != null || this.mSimCredential != null) {
            Log.d(TAG, "Contained more than one type of credential");
            return false;
        }
        if (!this.mUserCredential.validate()) {
            return false;
        }
        if (isR1 && this.mCaCertificates == null) {
            Log.d(TAG, "Missing CA Certificate for user credential");
            return false;
        }
        return true;
    }

    private boolean verifyCertCredential(boolean isR1) {
        if (this.mCertCredential == null) {
            Log.d(TAG, "Missing certificate credential");
            return false;
        }
        if (this.mUserCredential != null || this.mSimCredential != null) {
            Log.d(TAG, "Contained more than one type of credential");
            return false;
        }
        if (!this.mCertCredential.validate()) {
            return false;
        }
        if (isR1 && this.mCaCertificates == null) {
            Log.d(TAG, "Missing CA Certificate for certificate credential");
            return false;
        }
        if (this.mClientPrivateKey == null) {
            Log.d(TAG, "Missing client private key for certificate credential");
            return false;
        }
        try {
            if (!Credential.verifySha256Fingerprint(this.mClientCertificateChain, this.mCertCredential.getCertSha256Fingerprint())) {
                Log.d(TAG, "SHA-256 fingerprint mismatch");
                return false;
            }
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            Log.d(TAG, "Failed to verify SHA-256 fingerprint: " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean verifySimCredential() {
        if (this.mSimCredential == null) {
            Log.d(TAG, "Missing SIM credential");
            return false;
        }
        if (this.mUserCredential != null || this.mCertCredential != null) {
            Log.d(TAG, "Contained more than one type of credential");
            return false;
        }
        return this.mSimCredential.validate();
    }

    private static boolean isPrivateKeyEquals(PrivateKey key1, PrivateKey key2) {
        if (key1 == null && key2 == null) {
            return true;
        }
        if (key1 == null || key2 == null) {
            return false;
        }
        return TextUtils.equals(key1.getAlgorithm(), key2.getAlgorithm()) && Arrays.equals(key1.getEncoded(), key2.getEncoded());
    }

    public static boolean isX509CertificateEquals(X509Certificate cert1, X509Certificate cert2) {
        if (cert1 == null && cert2 == null) {
            return true;
        }
        if (cert1 == null || cert2 == null) {
            return false;
        }
        boolean result = false;
        try {
            result = Arrays.equals(cert1.getEncoded(), cert2.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return result;
    }

    private static boolean isX509CertificatesEquals(X509Certificate[] certs1, X509Certificate[] certs2) {
        if (certs1 == null && certs2 == null) {
            return true;
        }
        if (certs1 == null || certs2 == null) {
            return false;
        }
        if (certs1.length != certs2.length) {
            return false;
        }
        for (int i = 0; i < certs1.length; ++i) {
            if (Credential.isX509CertificateEquals(certs1[i], certs2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean verifySha256Fingerprint(X509Certificate[] certChain, byte[] expectedFingerprint) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (certChain == null) {
            return false;
        }
        MessageDigest digester = MessageDigest.getInstance("SHA-256");
        for (X509Certificate certificate : certChain) {
            digester.reset();
            byte[] fingerprint = digester.digest(certificate.getEncoded());
            if (!Arrays.equals(expectedFingerprint, fingerprint)) continue;
            return true;
        }
        return false;
    }

    public static final class SimCredential
    implements Parcelable {
        private static final int MAX_IMSI_LENGTH = 15;
        private String mImsi = null;
        private int mEapType = Integer.MIN_VALUE;
        public static final Parcelable.Creator<SimCredential> CREATOR = new Parcelable.Creator<SimCredential>(){

            @Override
            public SimCredential createFromParcel(Parcel in) {
                SimCredential simCredential = new SimCredential();
                simCredential.setImsi(in.readString());
                simCredential.setEapType(in.readInt());
                return simCredential;
            }

            public SimCredential[] newArray(int size) {
                return new SimCredential[size];
            }
        };

        public void setImsi(String imsi) {
            this.mImsi = imsi;
        }

        public String getImsi() {
            return this.mImsi;
        }

        public void setEapType(int eapType) {
            this.mEapType = eapType;
        }

        public int getEapType() {
            return this.mEapType;
        }

        public SimCredential() {
        }

        public SimCredential(SimCredential source) {
            if (source != null) {
                this.mImsi = source.mImsi;
                this.mEapType = source.mEapType;
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof SimCredential)) {
                return false;
            }
            SimCredential that = (SimCredential)thatObject;
            return TextUtils.equals(this.mImsi, that.mImsi) && this.mEapType == that.mEapType;
        }

        public int hashCode() {
            return Objects.hash(this.mImsi, this.mEapType);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IMSI: ").append(this.mImsi).append("\n");
            builder.append("EAPType: ").append(this.mEapType).append("\n");
            return builder.toString();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mImsi);
            dest.writeInt(this.mEapType);
        }

        public boolean validate() {
            if (!this.verifyImsi()) {
                return false;
            }
            if (this.mEapType != 18 && this.mEapType != 23 && this.mEapType != 50) {
                Log.d(Credential.TAG, "Invalid EAP Type for SIM credential: " + this.mEapType);
                return false;
            }
            return true;
        }

        private boolean verifyImsi() {
            int nonDigit;
            if (TextUtils.isEmpty(this.mImsi)) {
                Log.d(Credential.TAG, "Missing IMSI");
                return false;
            }
            if (this.mImsi.length() > 15) {
                Log.d(Credential.TAG, "IMSI exceeding maximum length: " + this.mImsi.length());
                return false;
            }
            char stopChar = '\u0000';
            for (nonDigit = 0; nonDigit < this.mImsi.length() && (stopChar = this.mImsi.charAt(nonDigit)) >= '0' && stopChar <= '9'; ++nonDigit) {
            }
            if (nonDigit == this.mImsi.length()) {
                return true;
            }
            return nonDigit == this.mImsi.length() - 1 && stopChar == '*';
        }
    }

    public static final class CertificateCredential
    implements Parcelable {
        public static final String CERT_TYPE_X509V3 = "x509v3";
        private static final int CERT_SHA256_FINGER_PRINT_LENGTH = 32;
        private String mCertType = null;
        private byte[] mCertSha256Fingerprint = null;
        public static final Parcelable.Creator<CertificateCredential> CREATOR = new Parcelable.Creator<CertificateCredential>(){

            @Override
            public CertificateCredential createFromParcel(Parcel in) {
                CertificateCredential certCredential = new CertificateCredential();
                certCredential.setCertType(in.readString());
                certCredential.setCertSha256Fingerprint(in.createByteArray());
                return certCredential;
            }

            public CertificateCredential[] newArray(int size) {
                return new CertificateCredential[size];
            }
        };

        public void setCertType(String certType) {
            this.mCertType = certType;
        }

        public String getCertType() {
            return this.mCertType;
        }

        public void setCertSha256Fingerprint(byte[] certSha256Fingerprint) {
            this.mCertSha256Fingerprint = certSha256Fingerprint;
        }

        public byte[] getCertSha256Fingerprint() {
            return this.mCertSha256Fingerprint;
        }

        public CertificateCredential() {
        }

        public CertificateCredential(CertificateCredential source) {
            if (source != null) {
                this.mCertType = source.mCertType;
                if (source.mCertSha256Fingerprint != null) {
                    this.mCertSha256Fingerprint = Arrays.copyOf(source.mCertSha256Fingerprint, source.mCertSha256Fingerprint.length);
                }
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mCertType);
            dest.writeByteArray(this.mCertSha256Fingerprint);
        }

        public boolean equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof CertificateCredential)) {
                return false;
            }
            CertificateCredential that = (CertificateCredential)thatObject;
            return TextUtils.equals(this.mCertType, that.mCertType) && Arrays.equals(this.mCertSha256Fingerprint, that.mCertSha256Fingerprint);
        }

        public int hashCode() {
            return Objects.hash(this.mCertType, Arrays.hashCode(this.mCertSha256Fingerprint));
        }

        public String toString() {
            return "CertificateType: " + this.mCertType + "\n";
        }

        public boolean validate() {
            if (!TextUtils.equals(CERT_TYPE_X509V3, this.mCertType)) {
                Log.d(Credential.TAG, "Unsupported certificate type: " + this.mCertType);
                return false;
            }
            if (this.mCertSha256Fingerprint == null || this.mCertSha256Fingerprint.length != 32) {
                Log.d(Credential.TAG, "Invalid SHA-256 fingerprint");
                return false;
            }
            return true;
        }
    }

    public static final class UserCredential
    implements Parcelable {
        private static final int MAX_USERNAME_BYTES = 63;
        private static final int MAX_PASSWORD_BYTES = 255;
        public static final String AUTH_METHOD_PAP = "PAP";
        public static final String AUTH_METHOD_MSCHAP = "MS-CHAP";
        public static final String AUTH_METHOD_MSCHAPV2 = "MS-CHAP-V2";
        private static final Set<String> SUPPORTED_AUTH = new HashSet<String>(Arrays.asList("PAP", "MS-CHAP", "MS-CHAP-V2"));
        private String mUsername = null;
        private String mPassword = null;
        private boolean mMachineManaged = false;
        private String mSoftTokenApp = null;
        private boolean mAbleToShare = false;
        private int mEapType = Integer.MIN_VALUE;
        private String mNonEapInnerMethod = null;
        public static final Parcelable.Creator<UserCredential> CREATOR = new Parcelable.Creator<UserCredential>(){

            @Override
            public UserCredential createFromParcel(Parcel in) {
                UserCredential userCredential = new UserCredential();
                userCredential.setUsername(in.readString());
                userCredential.setPassword(in.readString());
                userCredential.setMachineManaged(in.readInt() != 0);
                userCredential.setSoftTokenApp(in.readString());
                userCredential.setAbleToShare(in.readInt() != 0);
                userCredential.setEapType(in.readInt());
                userCredential.setNonEapInnerMethod(in.readString());
                return userCredential;
            }

            public UserCredential[] newArray(int size) {
                return new UserCredential[size];
            }
        };

        public void setUsername(String username) {
            this.mUsername = username;
        }

        public String getUsername() {
            return this.mUsername;
        }

        public void setPassword(String password) {
            this.mPassword = password;
        }

        public String getPassword() {
            return this.mPassword;
        }

        public void setMachineManaged(boolean machineManaged) {
            this.mMachineManaged = machineManaged;
        }

        public boolean getMachineManaged() {
            return this.mMachineManaged;
        }

        public void setSoftTokenApp(String softTokenApp) {
            this.mSoftTokenApp = softTokenApp;
        }

        public String getSoftTokenApp() {
            return this.mSoftTokenApp;
        }

        public void setAbleToShare(boolean ableToShare) {
            this.mAbleToShare = ableToShare;
        }

        public boolean getAbleToShare() {
            return this.mAbleToShare;
        }

        public void setEapType(int eapType) {
            this.mEapType = eapType;
        }

        public int getEapType() {
            return this.mEapType;
        }

        public void setNonEapInnerMethod(String nonEapInnerMethod) {
            this.mNonEapInnerMethod = nonEapInnerMethod;
        }

        public String getNonEapInnerMethod() {
            return this.mNonEapInnerMethod;
        }

        public UserCredential() {
        }

        public UserCredential(UserCredential source) {
            if (source != null) {
                this.mUsername = source.mUsername;
                this.mPassword = source.mPassword;
                this.mMachineManaged = source.mMachineManaged;
                this.mSoftTokenApp = source.mSoftTokenApp;
                this.mAbleToShare = source.mAbleToShare;
                this.mEapType = source.mEapType;
                this.mNonEapInnerMethod = source.mNonEapInnerMethod;
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mUsername);
            dest.writeString(this.mPassword);
            dest.writeInt(this.mMachineManaged ? 1 : 0);
            dest.writeString(this.mSoftTokenApp);
            dest.writeInt(this.mAbleToShare ? 1 : 0);
            dest.writeInt(this.mEapType);
            dest.writeString(this.mNonEapInnerMethod);
        }

        public boolean equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof UserCredential)) {
                return false;
            }
            UserCredential that = (UserCredential)thatObject;
            return TextUtils.equals(this.mUsername, that.mUsername) && TextUtils.equals(this.mPassword, that.mPassword) && this.mMachineManaged == that.mMachineManaged && TextUtils.equals(this.mSoftTokenApp, that.mSoftTokenApp) && this.mAbleToShare == that.mAbleToShare && this.mEapType == that.mEapType && TextUtils.equals(this.mNonEapInnerMethod, that.mNonEapInnerMethod);
        }

        public int hashCode() {
            return Objects.hash(this.mUsername, this.mPassword, this.mMachineManaged, this.mSoftTokenApp, this.mAbleToShare, this.mEapType, this.mNonEapInnerMethod);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Username: ").append(this.mUsername).append("\n");
            builder.append("MachineManaged: ").append(this.mMachineManaged).append("\n");
            builder.append("SoftTokenApp: ").append(this.mSoftTokenApp).append("\n");
            builder.append("AbleToShare: ").append(this.mAbleToShare).append("\n");
            builder.append("EAPType: ").append(this.mEapType).append("\n");
            builder.append("AuthMethod: ").append(this.mNonEapInnerMethod).append("\n");
            return builder.toString();
        }

        public boolean validate() {
            if (TextUtils.isEmpty(this.mUsername)) {
                Log.d(Credential.TAG, "Missing username");
                return false;
            }
            if (this.mUsername.getBytes(StandardCharsets.UTF_8).length > 63) {
                Log.d(Credential.TAG, "username exceeding maximum length: " + this.mUsername.getBytes(StandardCharsets.UTF_8).length);
                return false;
            }
            if (TextUtils.isEmpty(this.mPassword)) {
                Log.d(Credential.TAG, "Missing password");
                return false;
            }
            if (this.mPassword.getBytes(StandardCharsets.UTF_8).length > 255) {
                Log.d(Credential.TAG, "password exceeding maximum length: " + this.mPassword.getBytes(StandardCharsets.UTF_8).length);
                return false;
            }
            if (this.mEapType != 21) {
                Log.d(Credential.TAG, "Invalid EAP Type for user credential: " + this.mEapType);
                return false;
            }
            if (!SUPPORTED_AUTH.contains(this.mNonEapInnerMethod)) {
                Log.d(Credential.TAG, "Invalid non-EAP inner method for EAP-TTLS: " + this.mNonEapInnerMethod);
                return false;
            }
            return true;
        }
    }
}

