/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.UnsupportedAppUsage;
import android.nfc.INfcTag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.MifareUltralight;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.nfc.tech.NfcBarcode;
import android.nfc.tech.NfcF;
import android.nfc.tech.NfcV;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public final class Tag
implements Parcelable {
    @UnsupportedAppUsage
    final byte[] mId;
    final int[] mTechList;
    final String[] mTechStringList;
    final Bundle[] mTechExtras;
    final int mServiceHandle;
    final INfcTag mTagService;
    int mConnectedTechnology;
    public static final Parcelable.Creator<Tag> CREATOR = new Parcelable.Creator<Tag>(){

        @Override
        public Tag createFromParcel(Parcel in) {
            byte[] id2 = Tag.readBytesWithNull(in);
            int[] techList = new int[in.readInt()];
            in.readIntArray(techList);
            Bundle[] techExtras = in.createTypedArray(Bundle.CREATOR);
            int serviceHandle = in.readInt();
            int isMock = in.readInt();
            INfcTag tagService = isMock == 0 ? INfcTag.Stub.asInterface(in.readStrongBinder()) : null;
            return new Tag(id2, techList, techExtras, serviceHandle, tagService);
        }

        public Tag[] newArray(int size) {
            return new Tag[size];
        }
    };

    public Tag(byte[] id2, int[] techList, Bundle[] techListExtras, int serviceHandle, INfcTag tagService) {
        if (techList == null) {
            throw new IllegalArgumentException("rawTargets cannot be null");
        }
        this.mId = id2;
        this.mTechList = Arrays.copyOf(techList, techList.length);
        this.mTechStringList = this.generateTechStringList(techList);
        this.mTechExtras = Arrays.copyOf(techListExtras, techList.length);
        this.mServiceHandle = serviceHandle;
        this.mTagService = tagService;
        this.mConnectedTechnology = -1;
    }

    public static Tag createMockTag(byte[] id2, int[] techList, Bundle[] techListExtras) {
        return new Tag(id2, techList, techListExtras, 0, null);
    }

    private String[] generateTechStringList(int[] techList) {
        int size = techList.length;
        String[] strings = new String[size];
        block12: for (int i = 0; i < size; ++i) {
            switch (techList[i]) {
                case 3: {
                    strings[i] = IsoDep.class.getName();
                    continue block12;
                }
                case 8: {
                    strings[i] = MifareClassic.class.getName();
                    continue block12;
                }
                case 9: {
                    strings[i] = MifareUltralight.class.getName();
                    continue block12;
                }
                case 6: {
                    strings[i] = Ndef.class.getName();
                    continue block12;
                }
                case 7: {
                    strings[i] = NdefFormatable.class.getName();
                    continue block12;
                }
                case 1: {
                    strings[i] = NfcA.class.getName();
                    continue block12;
                }
                case 2: {
                    strings[i] = NfcB.class.getName();
                    continue block12;
                }
                case 4: {
                    strings[i] = NfcF.class.getName();
                    continue block12;
                }
                case 5: {
                    strings[i] = NfcV.class.getName();
                    continue block12;
                }
                case 10: {
                    strings[i] = NfcBarcode.class.getName();
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tech type " + techList[i]);
                }
            }
        }
        return strings;
    }

    static int[] getTechCodesFromStrings(String[] techStringList) throws IllegalArgumentException {
        if (techStringList == null) {
            throw new IllegalArgumentException("List cannot be null");
        }
        int[] techIntList = new int[techStringList.length];
        HashMap<String, Integer> stringToCodeMap = Tag.getTechStringToCodeMap();
        for (int i = 0; i < techStringList.length; ++i) {
            Integer code = stringToCodeMap.get(techStringList[i]);
            if (code == null) {
                throw new IllegalArgumentException("Unknown tech type " + techStringList[i]);
            }
            techIntList[i] = code;
        }
        return techIntList;
    }

    private static HashMap<String, Integer> getTechStringToCodeMap() {
        HashMap<String, Integer> techStringToCodeMap = new HashMap<String, Integer>();
        techStringToCodeMap.put(IsoDep.class.getName(), 3);
        techStringToCodeMap.put(MifareClassic.class.getName(), 8);
        techStringToCodeMap.put(MifareUltralight.class.getName(), 9);
        techStringToCodeMap.put(Ndef.class.getName(), 6);
        techStringToCodeMap.put(NdefFormatable.class.getName(), 7);
        techStringToCodeMap.put(NfcA.class.getName(), 1);
        techStringToCodeMap.put(NfcB.class.getName(), 2);
        techStringToCodeMap.put(NfcF.class.getName(), 4);
        techStringToCodeMap.put(NfcV.class.getName(), 5);
        techStringToCodeMap.put(NfcBarcode.class.getName(), 10);
        return techStringToCodeMap;
    }

    @UnsupportedAppUsage
    public int getServiceHandle() {
        return this.mServiceHandle;
    }

    public int[] getTechCodeList() {
        return this.mTechList;
    }

    public byte[] getId() {
        return this.mId;
    }

    public String[] getTechList() {
        return this.mTechStringList;
    }

    public Tag rediscover() throws IOException {
        if (this.getConnectedTechnology() != -1) {
            throw new IllegalStateException("Close connection to the technology first!");
        }
        if (this.mTagService == null) {
            throw new IOException("Mock tags don't support this operation.");
        }
        try {
            Tag newTag = this.mTagService.rediscover(this.getServiceHandle());
            if (newTag != null) {
                return newTag;
            }
            throw new IOException("Failed to rediscover tag");
        }
        catch (RemoteException e) {
            throw new IOException("NFC service dead");
        }
    }

    public boolean hasTech(int techType) {
        for (int tech : this.mTechList) {
            if (tech != techType) continue;
            return true;
        }
        return false;
    }

    public Bundle getTechExtras(int tech) {
        int pos = -1;
        for (int idx = 0; idx < this.mTechList.length; ++idx) {
            if (this.mTechList[idx] != tech) continue;
            pos = idx;
            break;
        }
        if (pos < 0) {
            return null;
        }
        return this.mTechExtras[pos];
    }

    @UnsupportedAppUsage
    public INfcTag getTagService() {
        return this.mTagService;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TAG: Tech [");
        String[] techList = this.getTechList();
        int length = techList.length;
        for (int i = 0; i < length; ++i) {
            sb.append(techList[i]);
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    static byte[] readBytesWithNull(Parcel in) {
        int len = in.readInt();
        byte[] result = null;
        if (len >= 0) {
            result = new byte[len];
            in.readByteArray(result);
        }
        return result;
    }

    static void writeBytesWithNull(Parcel out, byte[] b) {
        if (b == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(b.length);
        out.writeByteArray(b);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int isMock = this.mTagService == null ? 1 : 0;
        Tag.writeBytesWithNull(dest, this.mId);
        dest.writeInt(this.mTechList.length);
        dest.writeIntArray(this.mTechList);
        dest.writeTypedArray(this.mTechExtras, 0);
        dest.writeInt(this.mServiceHandle);
        dest.writeInt(isMock);
        if (isMock == 0) {
            dest.writeStrongBinder(this.mTagService.asBinder());
        }
    }

    public synchronized void setConnectedTechnology(int technology) {
        if (this.mConnectedTechnology != -1) {
            throw new IllegalStateException("Close other technology first!");
        }
        this.mConnectedTechnology = technology;
    }

    public int getConnectedTechnology() {
        return this.mConnectedTechnology;
    }

    public void setTechnologyDisconnected() {
        this.mConnectedTechnology = -1;
    }
}

