/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.dta;

import android.content.Context;
import android.nfc.INfcDta;
import android.nfc.NfcAdapter;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;

public final class NfcDta {
    private static final String TAG = "NfcDta";
    private static INfcDta sService;
    private static HashMap<Context, NfcDta> sNfcDtas;
    private final Context mContext;

    private NfcDta(Context context, INfcDta service) {
        this.mContext = context.getApplicationContext();
        sService = service;
    }

    public static synchronized NfcDta getInstance(NfcAdapter adapter) {
        if (adapter == null) {
            throw new NullPointerException("NfcAdapter is null");
        }
        Context context = adapter.getContext();
        if (context == null) {
            Log.e(TAG, "NfcAdapter context is null.");
            throw new UnsupportedOperationException();
        }
        NfcDta manager = sNfcDtas.get(context);
        if (manager == null) {
            INfcDta service = adapter.getNfcDtaInterface();
            if (service == null) {
                Log.e(TAG, "This device does not implement the INfcDta interface.");
                throw new UnsupportedOperationException();
            }
            manager = new NfcDta(context, service);
            sNfcDtas.put(context, manager);
        }
        return manager;
    }

    public boolean enableDta() {
        try {
            sService.enableDta();
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean disableDta() {
        try {
            sService.disableDta();
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean enableServer(String serviceName, int serviceSap, int miu, int rwSize, int testCaseId) {
        try {
            return sService.enableServer(serviceName, serviceSap, miu, rwSize, testCaseId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean disableServer() {
        try {
            sService.disableServer();
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean enableClient(String serviceName, int miu, int rwSize, int testCaseId) {
        try {
            return sService.enableClient(serviceName, miu, rwSize, testCaseId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean disableClient() {
        try {
            sService.disableClient();
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean registerMessageService(String msgServiceName) {
        try {
            return sService.registerMessageService(msgServiceName);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    static {
        sNfcDtas = new HashMap();
    }
}

