/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.ChildZygoteProcess;
import android.os.Process;
import android.os.ZygoteProcess;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;

public class AppZygote {
    private static final String LOG_TAG = "AppZygote";
    private final int mZygoteUid;
    private final int mZygoteUidGidMin;
    private final int mZygoteUidGidMax;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ChildZygoteProcess mZygote;
    private final ApplicationInfo mAppInfo;

    public AppZygote(ApplicationInfo appInfo, int zygoteUid, int uidGidMin, int uidGidMax) {
        this.mAppInfo = appInfo;
        this.mZygoteUid = zygoteUid;
        this.mZygoteUidGidMin = uidGidMin;
        this.mZygoteUidGidMax = uidGidMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildZygoteProcess getProcess() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mZygote != null) {
                return this.mZygote;
            }
            this.connectToZygoteIfNeededLocked();
            return this.mZygote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopZygote() {
        Object object = this.mLock;
        synchronized (object) {
            this.stopZygoteLocked();
        }
    }

    public ApplicationInfo getAppInfo() {
        return this.mAppInfo;
    }

    @GuardedBy(value={"mLock"})
    private void stopZygoteLocked() {
        if (this.mZygote != null) {
            this.mZygote.close();
            Process.killProcess(this.mZygote.getPid());
            this.mZygote = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private void connectToZygoteIfNeededLocked() {
        String abi = this.mAppInfo.primaryCpuAbi != null ? this.mAppInfo.primaryCpuAbi : Build.SUPPORTED_ABIS[0];
        try {
            this.mZygote = Process.ZYGOTE_PROCESS.startChildZygote("com.android.internal.os.AppZygoteInit", this.mAppInfo.processName + "_zygote", this.mZygoteUid, this.mZygoteUid, null, 0, "app_zygote", abi, abi, null, this.mZygoteUidGidMin, this.mZygoteUidGidMax);
            ZygoteProcess.waitForConnectionToZygote(this.mZygote.getPrimarySocketAddress());
            Log.i(LOG_TAG, "Starting application preload.");
            this.mZygote.preloadApp(this.mAppInfo, abi);
            Log.i(LOG_TAG, "Application preload done.");
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error connecting to app zygote", e);
            this.stopZygoteLocked();
        }
    }
}

