/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.UnsupportedAppUsage;
import android.os.StrictMode;
import android.os.UserHandle;
import android.os.ZygoteProcess;
import android.system.Os;
import android.system.OsConstants;
import android.webkit.WebViewZygote;
import dalvik.system.VMRuntime;

public class Process {
    private static final String LOG_TAG = "Process";
    public static final int INVALID_UID = -1;
    public static final int ROOT_UID = 0;
    public static final int SYSTEM_UID = 1000;
    public static final int PHONE_UID = 1001;
    public static final int SHELL_UID = 2000;
    @UnsupportedAppUsage
    public static final int LOG_UID = 1007;
    @UnsupportedAppUsage
    public static final int WIFI_UID = 1010;
    @UnsupportedAppUsage
    public static final int MEDIA_UID = 1013;
    @UnsupportedAppUsage
    public static final int DRM_UID = 1019;
    @UnsupportedAppUsage
    public static final int VPN_UID = 1016;
    public static final int KEYSTORE_UID = 1017;
    @UnsupportedAppUsage
    public static final int NFC_UID = 1027;
    public static final int CLAT_UID = 1029;
    public static final int BLUETOOTH_UID = 1002;
    public static final int MEDIA_RW_GID = 1023;
    public static final int PACKAGE_INFO_GID = 1032;
    public static final int SHARED_RELRO_UID = 1037;
    public static final int AUDIOSERVER_UID = 1041;
    public static final int CAMERASERVER_UID = 1047;
    public static final int DNS_TETHER_UID = 1052;
    public static final int WEBVIEW_ZYGOTE_UID = 1053;
    public static final int OTA_UPDATE_UID = 1061;
    public static final int INCIDENTD_UID = 1067;
    public static final int SE_UID = 1068;
    public static final int NETWORK_STACK_UID = 1073;
    public static final int NOBODY_UID = 9999;
    public static final int FIRST_APPLICATION_UID = 10000;
    public static final int LAST_APPLICATION_UID = 19999;
    public static final int FIRST_APP_ZYGOTE_ISOLATED_UID = 90000;
    public static final int NUM_UIDS_PER_APP_ZYGOTE = 100;
    public static final int LAST_APP_ZYGOTE_ISOLATED_UID = 98999;
    public static final int FIRST_ISOLATED_UID = 99000;
    public static final int LAST_ISOLATED_UID = 99999;
    public static final int SHARED_USER_GID = 9997;
    public static final int FIRST_SHARED_APPLICATION_GID = 50000;
    public static final int LAST_SHARED_APPLICATION_GID = 59999;
    public static final int FIRST_APPLICATION_CACHE_GID = 20000;
    public static final int LAST_APPLICATION_CACHE_GID = 29999;
    public static final int THREAD_PRIORITY_DEFAULT = 0;
    public static final int THREAD_PRIORITY_LOWEST = 19;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_PRIORITY_FOREGROUND = -2;
    public static final int THREAD_PRIORITY_DISPLAY = -4;
    public static final int THREAD_PRIORITY_URGENT_DISPLAY = -8;
    public static final int THREAD_PRIORITY_VIDEO = -10;
    public static final int THREAD_PRIORITY_AUDIO = -16;
    public static final int THREAD_PRIORITY_URGENT_AUDIO = -19;
    public static final int THREAD_PRIORITY_MORE_FAVORABLE = -1;
    public static final int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static final int SCHED_OTHER = 0;
    public static final int SCHED_FIFO = 1;
    public static final int SCHED_RR = 2;
    public static final int SCHED_BATCH = 3;
    public static final int SCHED_IDLE = 5;
    public static final int SCHED_RESET_ON_FORK = 0x40000000;
    public static final int THREAD_GROUP_DEFAULT = -1;
    public static final int THREAD_GROUP_BG_NONINTERACTIVE = 0;
    private static final int THREAD_GROUP_FOREGROUND = 1;
    public static final int THREAD_GROUP_SYSTEM = 2;
    public static final int THREAD_GROUP_AUDIO_APP = 3;
    public static final int THREAD_GROUP_AUDIO_SYS = 4;
    public static final int THREAD_GROUP_TOP_APP = 5;
    public static final int THREAD_GROUP_RT_APP = 6;
    public static final int THREAD_GROUP_RESTRICTED = 7;
    public static final int SIGNAL_QUIT = 3;
    public static final int SIGNAL_KILL = 9;
    public static final int SIGNAL_USR1 = 10;
    private static long sStartElapsedRealtime;
    private static long sStartUptimeMillis;
    public static final ZygoteProcess ZYGOTE_PROCESS;
    @UnsupportedAppUsage
    public static final int PROC_TERM_MASK = 255;
    @UnsupportedAppUsage
    public static final int PROC_ZERO_TERM = 0;
    @UnsupportedAppUsage
    public static final int PROC_SPACE_TERM = 32;
    @UnsupportedAppUsage
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_NEWLINE_TERM = 10;
    @UnsupportedAppUsage
    public static final int PROC_COMBINE = 256;
    @UnsupportedAppUsage
    public static final int PROC_PARENS = 512;
    @UnsupportedAppUsage
    public static final int PROC_QUOTES = 1024;
    public static final int PROC_CHAR = 2048;
    @UnsupportedAppUsage
    public static final int PROC_OUT_STRING = 4096;
    @UnsupportedAppUsage
    public static final int PROC_OUT_LONG = 8192;
    @UnsupportedAppUsage
    public static final int PROC_OUT_FLOAT = 16384;

    public static ProcessStartResult start(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, String packageName, String[] zygoteArgs) {
        return ZYGOTE_PROCESS.start(processClass, niceName, uid, gid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, invokeWith, packageName, true, zygoteArgs);
    }

    public static ProcessStartResult startWebView(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, String packageName, String[] zygoteArgs) {
        return WebViewZygote.getProcess().start(processClass, niceName, uid, gid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, invokeWith, packageName, false, zygoteArgs);
    }

    public static final native long getElapsedCpuTime();

    public static final long getStartElapsedRealtime() {
        return sStartElapsedRealtime;
    }

    public static final long getStartUptimeMillis() {
        return sStartUptimeMillis;
    }

    public static final void setStartTimes(long elapsedRealtime, long uptimeMillis) {
        sStartElapsedRealtime = elapsedRealtime;
        sStartUptimeMillis = uptimeMillis;
    }

    public static final boolean is64Bit() {
        return VMRuntime.getRuntime().is64Bit();
    }

    public static final int myPid() {
        return Os.getpid();
    }

    @UnsupportedAppUsage
    public static final int myPpid() {
        return Os.getppid();
    }

    public static final int myTid() {
        return Os.gettid();
    }

    public static final int myUid() {
        return Os.getuid();
    }

    public static UserHandle myUserHandle() {
        return UserHandle.of(UserHandle.getUserId(Process.myUid()));
    }

    public static boolean isCoreUid(int uid) {
        return UserHandle.isCore(uid);
    }

    public static boolean isApplicationUid(int uid) {
        return UserHandle.isApp(uid);
    }

    public static final boolean isIsolated() {
        return Process.isIsolated(Process.myUid());
    }

    @UnsupportedAppUsage
    public static final boolean isIsolated(int uid) {
        return (uid = UserHandle.getAppId(uid)) >= 99000 && uid <= 99999 || uid >= 90000 && uid <= 98999;
    }

    public static final native int getUidForName(String var0);

    public static final native int getGidForName(String var0);

    @UnsupportedAppUsage
    public static final int getUidForPid(int pid) {
        String[] procStatusLabels = new String[]{"Uid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    @UnsupportedAppUsage
    public static final int getParentPid(int pid) {
        String[] procStatusLabels = new String[]{"PPid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static final int getThreadGroupLeader(int tid) {
        String[] procStatusLabels = new String[]{"Tgid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + tid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static final native void setThreadPriority(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setCanSelfBackground(boolean var0);

    public static final native void setThreadGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadGroupAndCpuset(int var0, int var1) throws IllegalArgumentException, SecurityException;

    @UnsupportedAppUsage
    public static final native void setProcessGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native int getProcessGroup(int var0) throws IllegalArgumentException, SecurityException;

    public static final native int[] getExclusiveCores();

    public static final native void setThreadPriority(int var0) throws IllegalArgumentException, SecurityException;

    public static final native int getThreadPriority(int var0) throws IllegalArgumentException;

    public static final native int getThreadScheduler(int var0) throws IllegalArgumentException;

    public static final native void setThreadScheduler(int var0, int var1, int var2) throws IllegalArgumentException;

    @Deprecated
    public static final boolean supportsProcesses() {
        return true;
    }

    public static final native boolean setSwappiness(int var0, boolean var1);

    @UnsupportedAppUsage
    public static final native void setArgV0(String var0);

    public static final void killProcess(int pid) {
        Process.sendSignal(pid, 9);
    }

    public static final native int setUid(int var0);

    public static final native int setGid(int var0);

    public static final native void sendSignal(int var0, int var1);

    public static final void killProcessQuiet(int pid) {
        Process.sendSignalQuiet(pid, 9);
    }

    public static final native void sendSignalQuiet(int var0, int var1);

    @UnsupportedAppUsage
    public static final native long getFreeMemory();

    @UnsupportedAppUsage
    public static final native long getTotalMemory();

    @UnsupportedAppUsage
    public static final native void readProcLines(String var0, String[] var1, long[] var2);

    @UnsupportedAppUsage
    public static final native int[] getPids(String var0, int[] var1);

    @UnsupportedAppUsage
    public static final native boolean readProcFile(String var0, int[] var1, String[] var2, long[] var3, float[] var4);

    @UnsupportedAppUsage
    public static final native boolean parseProcLine(byte[] var0, int var1, int var2, int[] var3, String[] var4, long[] var5, float[] var6);

    @UnsupportedAppUsage
    public static final native int[] getPidsForCommands(String[] var0);

    @UnsupportedAppUsage
    public static final native long getPss(int var0);

    public static final native long[] getRss(int var0);

    public static final native int killProcessGroup(int var0, int var1);

    public static final native void removeAllProcessGroups();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isThreadInProcess(int tid, int pid) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (Os.access("/proc/" + tid + "/task/" + pid, OsConstants.F_OK)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    static {
        ZYGOTE_PROCESS = new ZygoteProcess();
    }

    public static final class ProcessStartResult {
        public int pid;
        public boolean usingWrapper;
    }
}

