/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import android.util.Slog;
import java.util.ArrayList;
import java.util.List;

public final class StatsLogEventWrapper
implements Parcelable {
    static final boolean DEBUG = false;
    static final String TAG = "StatsLogEventWrapper";
    private static final int EVENT_TYPE_UNKNOWN = 0;
    private static final int EVENT_TYPE_INT = 1;
    private static final int EVENT_TYPE_LONG = 2;
    private static final int EVENT_TYPE_FLOAT = 3;
    private static final int EVENT_TYPE_DOUBLE = 4;
    private static final int EVENT_TYPE_STRING = 5;
    private static final int EVENT_TYPE_STORAGE = 6;
    List<Integer> mTypes = new ArrayList<Integer>();
    List<Object> mValues = new ArrayList<Object>();
    int mTag;
    long mElapsedTimeNs;
    long mWallClockTimeNs;
    WorkSource mWorkSource = null;
    public static final Parcelable.Creator<StatsLogEventWrapper> CREATOR = new Parcelable.Creator<StatsLogEventWrapper>(){

        @Override
        public StatsLogEventWrapper createFromParcel(Parcel in) {
            return new StatsLogEventWrapper(in);
        }

        public StatsLogEventWrapper[] newArray(int size) {
            return new StatsLogEventWrapper[size];
        }
    };

    public StatsLogEventWrapper(int tag, long elapsedTimeNs, long wallClockTimeNs) {
        this.mTag = tag;
        this.mElapsedTimeNs = elapsedTimeNs;
        this.mWallClockTimeNs = wallClockTimeNs;
    }

    private StatsLogEventWrapper(Parcel in) {
        this.readFromParcel(in);
    }

    public void setWorkSource(WorkSource ws) {
        if (ws.getWorkChains() == null || ws.getWorkChains().size() == 0) {
            Slog.w(TAG, "Empty worksource!");
            return;
        }
        this.mWorkSource = ws;
    }

    public void writeInt(int val) {
        this.mTypes.add(1);
        this.mValues.add(val);
    }

    public void writeLong(long val) {
        this.mTypes.add(2);
        this.mValues.add(val);
    }

    public void writeString(String val) {
        this.mTypes.add(5);
        this.mValues.add(val == null ? "" : val);
    }

    public void writeFloat(float val) {
        this.mTypes.add(3);
        this.mValues.add(Float.valueOf(val));
    }

    public void writeStorage(byte[] val) {
        this.mTypes.add(6);
        this.mValues.add(val);
    }

    public void writeBoolean(boolean val) {
        this.mTypes.add(1);
        this.mValues.add(val ? 1 : 0);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mTag);
        out.writeLong(this.mElapsedTimeNs);
        out.writeLong(this.mWallClockTimeNs);
        if (this.mWorkSource != null) {
            ArrayList<WorkSource.WorkChain> workChains = this.mWorkSource.getWorkChains();
            out.writeInt(workChains.size());
            for (int i = 0; i < workChains.size(); ++i) {
                WorkSource.WorkChain wc = workChains.get(i);
                if (wc.getSize() == 0) {
                    Slog.w(TAG, "Empty work chain.");
                    out.writeInt(0);
                    continue;
                }
                if (wc.getUids().length != wc.getTags().length || wc.getUids().length != wc.getSize()) {
                    Slog.w(TAG, "Malformated work chain.");
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(wc.getSize());
                for (int j = 0; j < wc.getSize(); ++j) {
                    out.writeInt(wc.getUids()[j]);
                    out.writeString(wc.getTags()[j] == null ? "" : wc.getTags()[j]);
                }
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.mTypes.size());
        block10: for (int i = 0; i < this.mTypes.size(); ++i) {
            out.writeInt(this.mTypes.get(i));
            switch (this.mTypes.get(i)) {
                case 1: {
                    out.writeInt((Integer)this.mValues.get(i));
                    continue block10;
                }
                case 2: {
                    out.writeLong((Long)this.mValues.get(i));
                    continue block10;
                }
                case 3: {
                    out.writeFloat(((Float)this.mValues.get(i)).floatValue());
                    continue block10;
                }
                case 4: {
                    out.writeDouble((Double)this.mValues.get(i));
                    continue block10;
                }
                case 5: {
                    out.writeString((String)this.mValues.get(i));
                    continue block10;
                }
                case 6: {
                    out.writeByteArray((byte[])this.mValues.get(i));
                    continue block10;
                }
            }
        }
    }

    public void readFromParcel(Parcel in) {
        this.mTypes = new ArrayList<Integer>();
        this.mValues = new ArrayList<Object>();
        this.mWorkSource = null;
        this.mTag = in.readInt();
        this.mElapsedTimeNs = in.readLong();
        this.mWallClockTimeNs = in.readLong();
        int numWorkChains = in.readInt();
        if (numWorkChains > 0) {
            this.mWorkSource = new WorkSource();
            for (int i = 0; i < numWorkChains; ++i) {
                WorkSource.WorkChain workChain = this.mWorkSource.createWorkChain();
                int workChainSize = in.readInt();
                for (int j = 0; j < workChainSize; ++j) {
                    int uid = in.readInt();
                    String tag = in.readString();
                    workChain.addNode(uid, tag);
                }
            }
        }
        int numTypes = in.readInt();
        block10: for (int i = 0; i < numTypes; ++i) {
            int type = in.readInt();
            this.mTypes.add(type);
            switch (type) {
                case 1: {
                    this.mValues.add(in.readInt());
                    continue block10;
                }
                case 2: {
                    this.mValues.add(in.readLong());
                    continue block10;
                }
                case 3: {
                    this.mValues.add(Float.valueOf(in.readFloat()));
                    continue block10;
                }
                case 4: {
                    this.mValues.add(in.readDouble());
                    continue block10;
                }
                case 5: {
                    this.mValues.add(in.readString());
                    continue block10;
                }
                case 6: {
                    this.mValues.add(in.createByteArray());
                    continue block10;
                }
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

