/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.UnsupportedAppUsage;
import android.app.IAlarmManager;
import android.location.ILocationManager;
import android.location.LocationTime;
import android.os.DeadSystemException;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SimpleClock;
import android.util.Slog;
import dalvik.annotation.optimization.CriticalNative;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneOffset;

public final class SystemClock {
    private static final String TAG = "SystemClock";

    @UnsupportedAppUsage
    private SystemClock() {
    }

    public static void sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean setCurrentTimeMillis(long millis) {
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        if (mgr == null) {
            return false;
        }
        try {
            return mgr.setTime(millis);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        catch (SecurityException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        return false;
    }

    @CriticalNative
    public static native long uptimeMillis();

    @Deprecated
    public static Clock uptimeMillisClock() {
        return SystemClock.uptimeClock();
    }

    public static Clock uptimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.uptimeMillis();
            }
        };
    }

    @CriticalNative
    public static native long elapsedRealtime();

    public static Clock elapsedRealtimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.elapsedRealtime();
            }
        };
    }

    @CriticalNative
    public static native long elapsedRealtimeNanos();

    @CriticalNative
    public static native long currentThreadTimeMillis();

    @UnsupportedAppUsage
    @CriticalNative
    public static native long currentThreadTimeMicro();

    @UnsupportedAppUsage
    @CriticalNative
    public static native long currentTimeMicro();

    public static long currentNetworkTimeMillis() {
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        if (mgr != null) {
            try {
                return mgr.currentNetworkTimeMillis();
            }
            catch (ParcelableException e) {
                e.maybeRethrow(DateTimeException.class);
                throw new RuntimeException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        throw new RuntimeException(new DeadSystemException());
    }

    public static Clock currentNetworkTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.currentNetworkTimeMillis();
            }
        };
    }

    public static Clock currentGnssTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){
            private final ILocationManager mMgr = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));

            @Override
            public long millis() {
                LocationTime time;
                try {
                    time = this.mMgr.getGnssTimeMillis();
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                    return 0L;
                }
                if (time == null) {
                    throw new DateTimeException("Gnss based time is not available.");
                }
                long currentNanos = SystemClock.elapsedRealtimeNanos();
                long deltaMs = (currentNanos - time.getElapsedRealtimeNanos()) / 1000000L;
                return time.getTime() + deltaMs;
            }
        };
    }
}

