/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.util.Log;
import android.util.MutableInt;
import com.android.internal.annotations.GuardedBy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import libcore.util.HexEncoding;

@SystemApi
public class SystemProperties {
    private static final String TAG = "SystemProperties";
    private static final boolean TRACK_KEY_ACCESS = false;
    @UnsupportedAppUsage
    public static final int PROP_NAME_MAX = Integer.MAX_VALUE;
    public static final int PROP_VALUE_MAX = 91;
    @UnsupportedAppUsage
    @GuardedBy(value={"sChangeCallbacks"})
    private static final ArrayList<Runnable> sChangeCallbacks = new ArrayList();
    @GuardedBy(value={"sRoReads"})
    private static final HashMap<String, MutableInt> sRoReads = null;

    private static void onKeyAccess(String key) {
    }

    @UnsupportedAppUsage
    private static native String native_get(String var0);

    private static native String native_get(String var0, String var1);

    private static native int native_get_int(String var0, int var1);

    @UnsupportedAppUsage
    private static native long native_get_long(String var0, long var1);

    private static native boolean native_get_boolean(String var0, boolean var1);

    private static native void native_set(String var0, String var1);

    private static native void native_add_change_callback();

    private static native void native_report_sysprop_change();

    @SystemApi
    public static String get(String key) {
        return SystemProperties.native_get(key);
    }

    @SystemApi
    public static String get(String key, String def) {
        return SystemProperties.native_get(key, def);
    }

    @SystemApi
    public static int getInt(String key, int def) {
        return SystemProperties.native_get_int(key, def);
    }

    @SystemApi
    public static long getLong(String key, long def) {
        return SystemProperties.native_get_long(key, def);
    }

    @SystemApi
    public static boolean getBoolean(String key, boolean def) {
        return SystemProperties.native_get_boolean(key, def);
    }

    @UnsupportedAppUsage
    public static void set(String key, String val) {
        if (val != null && !val.startsWith("ro.") && val.length() > 91) {
            throw new IllegalArgumentException("value of system property '" + key + "' is longer than " + 91 + " characters: " + val);
        }
        SystemProperties.native_set(key, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void addChangeCallback(Runnable callback) {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                SystemProperties.native_add_change_callback();
            }
            sChangeCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callChangeCallbacks() {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                return;
            }
            ArrayList<Runnable> callbacks = new ArrayList<Runnable>(sChangeCallbacks);
            long token = Binder.clearCallingIdentity();
            try {
                for (int i = 0; i < callbacks.size(); ++i) {
                    try {
                        callbacks.get(i).run();
                        continue;
                    }
                    catch (Throwable t) {
                        Log.wtf(TAG, "Exception in SystemProperties change callback", t);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @UnsupportedAppUsage
    public static void reportSyspropChanged() {
        SystemProperties.native_report_sysprop_change();
    }

    public static String digestOf(String ... keys) {
        Arrays.sort(keys);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            for (String key : keys) {
                String item = key + "=" + SystemProperties.get(key) + "\n";
                digest.update(item.getBytes(StandardCharsets.UTF_8));
            }
            return HexEncoding.encodeToString(digest.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @UnsupportedAppUsage
    private SystemProperties() {
    }
}

