/*
 * Decompiled with CFR 0.152.
 */
package android.os.image;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

@SystemApi
public class DynamicSystemClient {
    private static final String TAG = "DynSystemClient";
    private static final long DEFAULT_USERDATA_SIZE = 0x280000000L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOT_STARTED = 1;
    public static final int STATUS_IN_PROGRESS = 2;
    public static final int STATUS_READY = 3;
    public static final int STATUS_IN_USE = 4;
    public static final int CAUSE_NOT_SPECIFIED = 0;
    public static final int CAUSE_INSTALL_COMPLETED = 1;
    public static final int CAUSE_INSTALL_CANCELLED = 2;
    public static final int CAUSE_ERROR_IO = 3;
    public static final int CAUSE_ERROR_INVALID_URL = 4;
    public static final int CAUSE_ERROR_IPC = 5;
    public static final int CAUSE_ERROR_EXCEPTION = 6;
    public static final int MSG_REGISTER_LISTENER = 1;
    public static final int MSG_UNREGISTER_LISTENER = 2;
    public static final int MSG_POST_STATUS = 3;
    public static final String KEY_INSTALLED_SIZE = "KEY_INSTALLED_SIZE";
    public static final String KEY_EXCEPTION_DETAIL = "KEY_EXCEPTION_DETAIL";
    public static final String ACTION_START_INSTALL = "android.os.image.action.START_INSTALL";
    public static final String ACTION_NOTIFY_IF_IN_USE = "android.os.image.action.NOTIFY_IF_IN_USE";
    public static final String KEY_SYSTEM_SIZE = "KEY_SYSTEM_SIZE";
    public static final String KEY_USERDATA_SIZE = "KEY_USERDATA_SIZE";
    private final Context mContext;
    private final DynSystemServiceConnection mConnection;
    private final Messenger mMessenger;
    private boolean mBound;
    private Executor mExecutor;
    private OnStatusChangedListener mListener;
    private Messenger mService;

    @SystemApi
    public DynamicSystemClient(Context context) {
        this.mContext = context;
        this.mConnection = new DynSystemServiceConnection();
        this.mMessenger = new Messenger(new IncomingHandler(this));
    }

    public void setOnStatusChangedListener(Executor executor, OnStatusChangedListener listener) {
        this.mListener = listener;
        this.mExecutor = executor;
    }

    public void setOnStatusChangedListener(OnStatusChangedListener listener) {
        this.mListener = listener;
        this.mExecutor = null;
    }

    @SystemApi
    public void bind() {
        if (!this.featureFlagEnabled()) {
            Slog.w(TAG, "settings_dynamic_system not enabled; bind() aborted.");
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.dynsystem", "com.android.dynsystem.DynamicSystemInstallationService");
        this.mContext.bindService(intent, this.mConnection, 1);
        this.mBound = true;
    }

    @SystemApi
    public void unbind() {
        if (!this.mBound) {
            return;
        }
        if (this.mService != null) {
            try {
                Message msg = Message.obtain(null, 2);
                msg.replyTo = this.mMessenger;
                this.mService.send(msg);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to unregister from installation service");
            }
        }
        this.mContext.unbindService(this.mConnection);
        this.mBound = false;
    }

    @SystemApi
    public void start(Uri systemUrl, long systemSize) {
        this.start(systemUrl, systemSize, 0x280000000L);
    }

    public void start(Uri systemUrl, long systemSize, long userdataSize) {
        if (!this.featureFlagEnabled()) {
            Slog.w(TAG, "settings_dynamic_system not enabled; start() aborted.");
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.dynsystem", "com.android.dynsystem.VerificationActivity");
        intent.setData(systemUrl);
        intent.setAction(ACTION_START_INSTALL);
        intent.putExtra(KEY_SYSTEM_SIZE, systemSize);
        intent.putExtra(KEY_USERDATA_SIZE, userdataSize);
        this.mContext.startActivity(intent);
    }

    private boolean featureFlagEnabled() {
        return SystemProperties.getBoolean("persist.sys.fflag.override.settings_dynamic_system", false);
    }

    private void handleMessage(Message msg) {
        switch (msg.what) {
            case 3: {
                Throwable detail;
                int status = msg.arg1;
                int cause = msg.arg2;
                Bundle bundle = (Bundle)msg.obj;
                long progress = bundle.getLong(KEY_INSTALLED_SIZE);
                ParcelableException t = (ParcelableException)bundle.getSerializable(KEY_EXCEPTION_DETAIL);
                Throwable throwable = detail = t == null ? null : t.getCause();
                if (this.mExecutor != null) {
                    this.mExecutor.execute(() -> this.mListener.onStatusChanged(status, cause, progress, detail));
                    break;
                }
                this.mListener.onStatusChanged(status, cause, progress, detail);
                break;
            }
        }
    }

    private class DynSystemServiceConnection
    implements ServiceConnection {
        private DynSystemServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            Slog.v(DynamicSystemClient.TAG, "DynSystemService connected");
            DynamicSystemClient.this.mService = new Messenger(service);
            try {
                Message msg = Message.obtain(null, 1);
                msg.replyTo = DynamicSystemClient.this.mMessenger;
                DynamicSystemClient.this.mService.send(msg);
            }
            catch (RemoteException e) {
                Slog.e(DynamicSystemClient.TAG, "Unable to get status from installation service");
                DynamicSystemClient.this.mExecutor.execute(() -> DynamicSystemClient.this.mListener.onStatusChanged(0, 5, 0L, e));
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            Slog.v(DynamicSystemClient.TAG, "DynSystemService disconnected");
            DynamicSystemClient.this.mService = null;
        }
    }

    private static class IncomingHandler
    extends Handler {
        private final WeakReference<DynamicSystemClient> mWeakClient;

        IncomingHandler(DynamicSystemClient service) {
            super(Looper.getMainLooper());
            this.mWeakClient = new WeakReference<DynamicSystemClient>(service);
        }

        @Override
        public void handleMessage(Message msg) {
            DynamicSystemClient service = (DynamicSystemClient)this.mWeakClient.get();
            if (service != null) {
                service.handleMessage(msg);
            }
        }
    }

    public static interface OnStatusChangedListener {
        public void onStatusChanged(int var1, int var2, long var3, Throwable var5);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusChangedCause {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstallationStatus {
    }
}

