/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.permission.IPermissionController;
import android.permission.RuntimePermissionPresentationInfo;
import android.permission.RuntimePermissionUsageInfo;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.AbstractMultiplePendingRequestsRemoteService;
import com.android.internal.infra.AbstractRemoteService;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import libcore.io.IoUtils;

@SystemApi
public final class PermissionControllerManager {
    private static final String TAG = PermissionControllerManager.class.getSimpleName();
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<Pair<Integer, Thread>, RemoteService> sRemoteServices = new ArrayMap(1);
    public static final String KEY_RESULT = "android.permission.PermissionControllerManager.key.result";
    public static final int REASON_MALWARE = 1;
    public static final int REASON_INSTALLER_POLICY_VIOLATION = 2;
    public static final int COUNT_ONLY_WHEN_GRANTED = 1;
    public static final int COUNT_WHEN_SYSTEM = 2;
    private final Context mContext;
    private final RemoteService mRemoteService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionControllerManager(Context context, Handler handler) {
        Object object = sLock;
        synchronized (object) {
            Pair<Integer, Thread> key = new Pair<Integer, Thread>(context.getUserId(), handler.getLooper().getThread());
            RemoteService remoteService = sRemoteServices.get(key);
            if (remoteService == null) {
                Intent intent = new Intent("android.permission.PermissionControllerService");
                intent.setPackage(context.getPackageManager().getPermissionControllerPackageName());
                ResolveInfo serviceInfo = context.getPackageManager().resolveService(intent, 0);
                remoteService = new RemoteService(ActivityThread.currentApplication(), serviceInfo.getComponentInfo().getComponentName(), handler, context.getUser());
                sRemoteServices.put(key, remoteService);
            }
            this.mRemoteService = remoteService;
        }
        this.mContext = context;
    }

    public void revokeRuntimePermissions(Map<String, List<String>> request, boolean doDryRun, int reason, Executor executor, OnRevokeRuntimePermissionsCallback callback) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(request);
        for (Map.Entry<String, List<String>> appRequest : request.entrySet()) {
            Preconditions.checkNotNull(appRequest.getKey());
            Preconditions.checkCollectionElementsNotNull(appRequest.getValue(), "permissions");
        }
        if (this.mContext.checkSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS") != 0) {
            throw new SecurityException("android.permission.REVOKE_RUNTIME_PERMISSIONS required");
        }
        this.mRemoteService.scheduleRequest(new PendingRevokeRuntimePermissionRequest(this.mRemoteService, request, doDryRun, reason, this.mContext.getPackageName(), executor, callback));
    }

    public void setRuntimePermissionGrantStateByDeviceAdmin(String callerPackageName, String packageName, String permission2, int grantState, Executor executor, Consumer<Boolean> callback) {
        Preconditions.checkStringNotEmpty(callerPackageName);
        Preconditions.checkStringNotEmpty(packageName);
        Preconditions.checkStringNotEmpty(permission2);
        Preconditions.checkArgument(grantState == 1 || grantState == 2 || grantState == 0);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.scheduleRequest(new PendingSetRuntimePermissionGrantStateByDeviceAdmin(this.mRemoteService, callerPackageName, packageName, permission2, grantState, executor, callback));
    }

    public void getRuntimePermissionBackup(UserHandle user, Executor executor, OnGetRuntimePermissionBackupCallback callback) {
        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.scheduleRequest(new PendingGetRuntimePermissionBackup(this.mRemoteService, user, executor, callback));
    }

    public void restoreRuntimePermissionBackup(byte[] backup, UserHandle user) {
        Preconditions.checkNotNull(backup);
        Preconditions.checkNotNull(user);
        this.mRemoteService.scheduleAsyncRequest(new PendingRestoreRuntimePermissionBackup(this.mRemoteService, backup, user));
    }

    public void restoreDelayedRuntimePermissionBackup(String packageName, UserHandle user, Executor executor, Consumer<Boolean> callback) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.scheduleRequest(new PendingRestoreDelayedRuntimePermissionBackup(this.mRemoteService, packageName, user, executor, callback));
    }

    public void getAppPermissions(String packageName, OnGetAppPermissionResultCallback callback, Handler handler) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.scheduleRequest(new PendingGetAppPermissionRequest(this.mRemoteService, packageName, callback, handler == null ? this.mRemoteService.getHandler() : handler));
    }

    public void revokeRuntimePermission(String packageName, String permissionName) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(permissionName);
        this.mRemoteService.scheduleAsyncRequest(new PendingRevokeAppPermissionRequest(packageName, permissionName));
    }

    public void countPermissionApps(List<String> permissionNames, int flags, OnCountPermissionAppsResultCallback callback, Handler handler) {
        Preconditions.checkCollectionElementsNotNull(permissionNames, "permissionNames");
        Preconditions.checkFlagsArgument(flags, 3);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.scheduleRequest(new PendingCountPermissionAppsRequest(this.mRemoteService, permissionNames, flags, callback, handler == null ? this.mRemoteService.getHandler() : handler));
    }

    public void getPermissionUsages(boolean countSystem, long numMillis, Executor executor, OnPermissionUsageResultCallback callback) {
        Preconditions.checkArgumentNonnegative(numMillis);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback);
        this.mRemoteService.scheduleRequest(new PendingGetPermissionUsagesRequest(this.mRemoteService, countSystem, numMillis, executor, callback));
    }

    public void grantOrUpgradeDefaultRuntimePermissions(Executor executor, Consumer<Boolean> callback) {
        this.mRemoteService.scheduleRequest(new PendingGrantOrUpgradeDefaultRuntimePermissionsRequest(this.mRemoteService, executor, callback));
    }

    private static final class PendingGrantOrUpgradeDefaultRuntimePermissionsRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController> {
        private final Consumer<Boolean> mCallback;
        private final RemoteCallback mRemoteCallback;

        private PendingGrantOrUpgradeDefaultRuntimePermissionsRequest(RemoteService service, Executor executor, Consumer<Boolean> callback) {
            super(service);
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> executor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.accept(result != null);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onTimeout(RemoteService remoteService) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mCallback.accept(false);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void run() {
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).grantOrUpgradeDefaultRuntimePermissions(this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error granting or upgrading runtime permissions", e);
            }
        }
    }

    private static final class PendingGetPermissionUsagesRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController> {
        private final OnPermissionUsageResultCallback mCallback;
        private final boolean mCountSystem;
        private final long mNumMillis;
        private final RemoteCallback mRemoteCallback;

        private PendingGetPermissionUsagesRequest(RemoteService service, boolean countSystem, long numMillis, Executor executor, OnPermissionUsageResultCallback callback) {
            super(service);
            this.mCountSystem = countSystem;
            this.mNumMillis = numMillis;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> executor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    List<RuntimePermissionUsageInfo> users = null;
                    users = result != null ? result.getParcelableArrayList(PermissionControllerManager.KEY_RESULT) : Collections.emptyList();
                    List<RuntimePermissionUsageInfo> reportedUsers = users;
                    callback.onPermissionUsageResult(reportedUsers);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }), null);
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mCallback.onPermissionUsageResult(Collections.emptyList());
        }

        @Override
        public void run() {
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).getPermissionUsages(this.mCountSystem, this.mNumMillis, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error counting permission users", e);
            }
        }
    }

    private static final class PendingCountPermissionAppsRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController> {
        private final List<String> mPermissionNames;
        private final OnCountPermissionAppsResultCallback mCallback;
        private final int mFlags;
        private final RemoteCallback mRemoteCallback;

        private PendingCountPermissionAppsRequest(RemoteService service, List<String> permissionNames, int flags, OnCountPermissionAppsResultCallback callback, Handler handler) {
            super(service);
            this.mPermissionNames = permissionNames;
            this.mFlags = flags;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> {
                int numApps = result != null ? result.getInt(PermissionControllerManager.KEY_RESULT) : 0;
                callback.onCountPermissionApps(numApps);
                this.finish();
            }, handler);
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mCallback.onCountPermissionApps(0);
        }

        @Override
        public void run() {
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).countPermissionApps(this.mPermissionNames, this.mFlags, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error counting permission apps", e);
            }
        }
    }

    private static final class PendingRevokeAppPermissionRequest
    implements AbstractRemoteService.AsyncRequest<IPermissionController> {
        private final String mPackageName;
        private final String mPermissionName;

        private PendingRevokeAppPermissionRequest(String packageName, String permissionName) {
            this.mPackageName = packageName;
            this.mPermissionName = permissionName;
        }

        @Override
        public void run(IPermissionController remoteInterface) {
            try {
                remoteInterface.revokeRuntimePermission(this.mPackageName, this.mPermissionName);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error revoking app permission", e);
            }
        }
    }

    private static final class PendingGetAppPermissionRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController> {
        private final String mPackageName;
        private final OnGetAppPermissionResultCallback mCallback;
        private final RemoteCallback mRemoteCallback;

        private PendingGetAppPermissionRequest(RemoteService service, String packageName, OnGetAppPermissionResultCallback callback, Handler handler) {
            super(service);
            this.mPackageName = packageName;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> {
                List<RuntimePermissionPresentationInfo> permissions = null;
                if (result != null) {
                    permissions = result.getParcelableArrayList(PermissionControllerManager.KEY_RESULT);
                }
                if (permissions == null) {
                    permissions = Collections.emptyList();
                }
                ArrayList<RuntimePermissionPresentationInfo> reportedPermissions = permissions;
                callback.onGetAppPermissions(reportedPermissions);
                this.finish();
            }, handler);
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mCallback.onGetAppPermissions(Collections.emptyList());
        }

        @Override
        public void run() {
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).getAppPermissions(this.mPackageName, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error getting app permission", e);
            }
        }
    }

    private static final class PendingRestoreDelayedRuntimePermissionBackup
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController> {
        private final String mPackageName;
        private final UserHandle mUser;
        private final Executor mExecutor;
        private final Consumer<Boolean> mCallback;
        private final RemoteCallback mRemoteCallback;

        private PendingRestoreDelayedRuntimePermissionBackup(RemoteService service, String packageName, UserHandle user, Executor executor, Consumer<Boolean> callback) {
            super(service);
            this.mPackageName = packageName;
            this.mUser = user;
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> executor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.accept(result.getBoolean(PermissionControllerManager.KEY_RESULT, false));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onTimeout(RemoteService remoteService) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.accept(true));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void run() {
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).restoreDelayedRuntimePermissionBackup(this.mPackageName, this.mUser, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error restoring delayed permissions for " + this.mPackageName, e);
            }
        }
    }

    private static final class PendingRestoreRuntimePermissionBackup
    implements AbstractRemoteService.AsyncRequest<IPermissionController> {
        private final FileWriterTask mBackupSender;
        private final byte[] mBackup;
        private final UserHandle mUser;

        private PendingRestoreRuntimePermissionBackup(RemoteService service, byte[] backup, UserHandle user) {
            this.mBackup = backup;
            this.mUser = user;
            this.mBackupSender = new FileWriterTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(IPermissionController service) {
            if (this.mBackupSender.getStatus() != AsyncTask.Status.PENDING) {
                return;
            }
            this.mBackupSender.execute((Params[])new byte[][]{this.mBackup});
            ParcelFileDescriptor remotePipe = this.mBackupSender.getRemotePipe();
            try {
                service.restoreRuntimePermissionBackup(this.mUser, remotePipe);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error sending runtime permission backup", e);
                this.mBackupSender.cancel(false);
                this.mBackupSender.interruptWrite();
            }
            finally {
                IoUtils.closeQuietly(remotePipe);
            }
        }
    }

    private static final class PendingSetRuntimePermissionGrantStateByDeviceAdmin
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController> {
        private final String mCallerPackageName;
        private final String mPackageName;
        private final String mPermission;
        private final int mGrantState;
        private final Executor mExecutor;
        private final Consumer<Boolean> mCallback;
        private final RemoteCallback mRemoteCallback;

        private PendingSetRuntimePermissionGrantStateByDeviceAdmin(RemoteService service, String callerPackageName, String packageName, String permission2, int grantState, Executor executor, Consumer<Boolean> callback) {
            super(service);
            this.mCallerPackageName = callerPackageName;
            this.mPackageName = packageName;
            this.mPermission = permission2;
            this.mGrantState = grantState;
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> executor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    callback.accept(result.getBoolean(PermissionControllerManager.KEY_RESULT, false));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onTimeout(RemoteService remoteService) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.accept(false));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void run() {
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).setRuntimePermissionGrantStateByDeviceAdmin(this.mCallerPackageName, this.mPackageName, this.mPermission, this.mGrantState, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error setting permissions state for device admin " + this.mPackageName, e);
            }
        }
    }

    private static final class PendingGetRuntimePermissionBackup
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController>
    implements Consumer<byte[]> {
        private final FileReaderTask<PendingGetRuntimePermissionBackup> mBackupReader;
        private final Executor mExecutor;
        private final OnGetRuntimePermissionBackupCallback mCallback;
        private final UserHandle mUser;

        private PendingGetRuntimePermissionBackup(RemoteService service, UserHandle user, Executor executor, OnGetRuntimePermissionBackupCallback callback) {
            super(service);
            this.mUser = user;
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mBackupReader = new FileReaderTask<PendingGetRuntimePermissionBackup>(this);
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mBackupReader.cancel(true);
            this.mBackupReader.interruptRead();
        }

        @Override
        public void run() {
            if (this.mBackupReader.getStatus() != AsyncTask.Status.PENDING) {
                return;
            }
            this.mBackupReader.execute(new Void[0]);
            ParcelFileDescriptor remotePipe = this.mBackupReader.getRemotePipe();
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).getRuntimePermissionBackup(this.mUser, remotePipe);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error getting runtime permission backup", e);
            }
            finally {
                IoUtils.closeQuietly(remotePipe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(byte[] backup) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onGetRuntimePermissionsBackup(backup));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            this.finish();
        }
    }

    private static final class PendingRevokeRuntimePermissionRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IPermissionController> {
        private final Map<String, List<String>> mRequest;
        private final boolean mDoDryRun;
        private final int mReason;
        private final String mCallingPackage;
        private final Executor mExecutor;
        private final OnRevokeRuntimePermissionsCallback mCallback;
        private final RemoteCallback mRemoteCallback;

        private PendingRevokeRuntimePermissionRequest(RemoteService service, Map<String, List<String>> request, boolean doDryRun, int reason, String callingPackage, Executor executor, OnRevokeRuntimePermissionsCallback callback) {
            super(service);
            this.mRequest = request;
            this.mDoDryRun = doDryRun;
            this.mReason = reason;
            this.mCallingPackage = callingPackage;
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> executor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    ArrayMap<String, List<String>> revoked = new ArrayMap<String, List<String>>();
                    try {
                        Bundle bundleizedRevoked = result.getBundle(PermissionControllerManager.KEY_RESULT);
                        for (String packageName : bundleizedRevoked.keySet()) {
                            Preconditions.checkNotNull(packageName);
                            ArrayList<String> permissions = bundleizedRevoked.getStringArrayList(packageName);
                            Preconditions.checkCollectionElementsNotNull(permissions, "permissions");
                            revoked.put(packageName, permissions);
                        }
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Could not read result when revoking runtime permissions", e);
                    }
                    callback.onRevokeRuntimePermissions(revoked);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onTimeout(RemoteService remoteService) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onRevokeRuntimePermissions(Collections.emptyMap()));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void run() {
            Bundle bundledizedRequest = new Bundle();
            for (Map.Entry<String, List<String>> appRequest : this.mRequest.entrySet()) {
                bundledizedRequest.putStringArrayList(appRequest.getKey(), new ArrayList<String>((Collection)appRequest.getValue()));
            }
            try {
                ((IPermissionController)((RemoteService)this.getService()).getServiceInterface()).revokeRuntimePermissions(bundledizedRequest, this.mDoDryRun, this.mReason, this.mCallingPackage, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error revoking runtime permission", e);
            }
        }
    }

    private static class FileWriterTask
    extends AsyncTask<byte[], Void, Void> {
        private static final int CHUNK_SIZE = 4096;
        private ParcelFileDescriptor mLocalPipe;
        private ParcelFileDescriptor mRemotePipe;

        private FileWriterTask() {
        }

        @Override
        protected void onPreExecute() {
            ParcelFileDescriptor[] pipe;
            try {
                pipe = ParcelFileDescriptor.createPipe();
            }
            catch (IOException e) {
                Log.e(TAG, "Could not create pipe needed to send runtime permission backup", e);
                return;
            }
            this.mRemotePipe = pipe[0];
            this.mLocalPipe = pipe[1];
        }

        ParcelFileDescriptor getRemotePipe() {
            return this.mRemotePipe;
        }

        protected Void doInBackground(byte[] ... in) {
            byte[] buffer = in[0];
            try (ParcelFileDescriptor.AutoCloseOutputStream out = new ParcelFileDescriptor.AutoCloseOutputStream(this.mLocalPipe);){
                for (int offset = 0; offset < buffer.length; offset += 4096) {
                    ((OutputStream)out).write(buffer, offset, Math.min(4096, buffer.length - offset));
                }
            }
            catch (IOException | NullPointerException e) {
                Log.e(TAG, "Error sending runtime permission backup", e);
            }
            return null;
        }

        void interruptWrite() {
            IoUtils.closeQuietly(this.mLocalPipe);
        }

        @Override
        protected void onCancelled() {
            this.onPostExecute(null);
        }

        @Override
        protected void onPostExecute(Void ignored) {
            IoUtils.closeQuietly(this.mLocalPipe);
        }
    }

    private static class FileReaderTask<Callback extends Consumer<byte[]>>
    extends AsyncTask<Void, Void, byte[]> {
        private ParcelFileDescriptor mLocalPipe;
        private ParcelFileDescriptor mRemotePipe;
        private final Callback mCallback;

        FileReaderTask(Callback callback) {
            this.mCallback = callback;
        }

        @Override
        protected void onPreExecute() {
            ParcelFileDescriptor[] pipe;
            try {
                pipe = ParcelFileDescriptor.createPipe();
            }
            catch (IOException e) {
                Log.e(TAG, "Could not create pipe needed to get runtime permission backup", e);
                return;
            }
            this.mLocalPipe = pipe[0];
            this.mRemotePipe = pipe[1];
        }

        ParcelFileDescriptor getRemotePipe() {
            return this.mRemotePipe;
        }

        protected byte[] doInBackground(Void ... ignored) {
            ByteArrayOutputStream combinedBuffer = new ByteArrayOutputStream();
            try (ParcelFileDescriptor.AutoCloseInputStream in = new ParcelFileDescriptor.AutoCloseInputStream(this.mLocalPipe);){
                byte[] buffer = new byte[16384];
                while (!this.isCancelled()) {
                    int numRead = ((InputStream)in).read(buffer);
                    if (numRead == -1) {
                        break;
                    }
                    combinedBuffer.write(buffer, 0, numRead);
                }
            }
            catch (IOException | NullPointerException e) {
                Log.e(TAG, "Error reading runtime permission backup", e);
                combinedBuffer.reset();
            }
            return combinedBuffer.toByteArray();
        }

        void interruptRead() {
            IoUtils.closeQuietly(this.mLocalPipe);
        }

        @Override
        protected void onCancelled() {
            this.onPostExecute(new byte[0]);
        }

        @Override
        protected void onPostExecute(byte[] backup) {
            IoUtils.closeQuietly(this.mLocalPipe);
            this.mCallback.accept((byte[])backup);
        }
    }

    static final class RemoteService
    extends AbstractMultiplePendingRequestsRemoteService<RemoteService, IPermissionController> {
        private static final long UNBIND_TIMEOUT_MILLIS = 10000L;
        private static final long MESSAGE_TIMEOUT_MILLIS = 30000L;

        RemoteService(Context context, ComponentName componentName, Handler handler, UserHandle user) {
            super(context, "android.permission.PermissionControllerService", componentName, user.getIdentifier(), service -> Log.e(TAG, "RemoteService " + service + " died"), handler, 0, false, 1);
        }

        Handler getHandler() {
            return this.mHandler;
        }

        @Override
        protected IPermissionController getServiceInterface(IBinder binder) {
            return IPermissionController.Stub.asInterface(binder);
        }

        @Override
        protected long getTimeoutIdleBindMillis() {
            return 10000L;
        }

        @Override
        protected long getRemoteRequestMillis() {
            return 30000L;
        }

        @Override
        public void scheduleRequest(AbstractRemoteService.BasePendingRequest<RemoteService, IPermissionController> pendingRequest) {
            super.scheduleRequest(pendingRequest);
        }

        @Override
        public void scheduleAsyncRequest(AbstractRemoteService.AsyncRequest<IPermissionController> request) {
            super.scheduleAsyncRequest(request);
        }
    }

    public static interface OnPermissionUsageResultCallback {
        public void onPermissionUsageResult(List<RuntimePermissionUsageInfo> var1);
    }

    public static interface OnCountPermissionAppsResultCallback {
        public void onCountPermissionApps(int var1);
    }

    public static interface OnGetAppPermissionResultCallback {
        public void onGetAppPermissions(List<RuntimePermissionPresentationInfo> var1);
    }

    public static interface OnGetRuntimePermissionBackupCallback {
        public void onGetRuntimePermissionsBackup(byte[] var1);
    }

    public static abstract class OnRevokeRuntimePermissionsCallback {
        public abstract void onRevokeRuntimePermissions(Map<String, List<String>> var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CountPermissionAppsFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reason {
    }
}

