/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.UserHandle;
import android.permission.IPermissionController;
import android.permission.RuntimePermissionPresentationInfo;
import android.permission.RuntimePermissionUsageInfo;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

@SystemApi
public abstract class PermissionControllerService
extends Service {
    private static final String LOG_TAG = PermissionControllerService.class.getSimpleName();
    public static final String SERVICE_INTERFACE = "android.permission.PermissionControllerService";

    public abstract void onRevokeRuntimePermissions(Map<String, List<String>> var1, boolean var2, int var3, String var4, Consumer<Map<String, List<String>>> var5);

    public abstract void onGetRuntimePermissionsBackup(UserHandle var1, OutputStream var2, Runnable var3);

    public abstract void onRestoreRuntimePermissionsBackup(UserHandle var1, InputStream var2, Runnable var3);

    public abstract void onRestoreDelayedRuntimePermissionsBackup(String var1, UserHandle var2, Consumer<Boolean> var3);

    public abstract void onGetAppPermissions(String var1, Consumer<List<RuntimePermissionPresentationInfo>> var2);

    public abstract void onRevokeRuntimePermission(String var1, String var2, Runnable var3);

    public abstract void onCountPermissionApps(List<String> var1, int var2, IntConsumer var3);

    public abstract void onGetPermissionUsages(boolean var1, long var2, Consumer<List<RuntimePermissionUsageInfo>> var4);

    public abstract void onGrantOrUpgradeDefaultRuntimePermissions(Runnable var1);

    public abstract void onSetRuntimePermissionGrantStateByDeviceAdmin(String var1, String var2, String var3, int var4, Consumer<Boolean> var5);

    @Override
    public final IBinder onBind(Intent intent) {
        return new IPermissionController.Stub(){

            @Override
            public void revokeRuntimePermissions(Bundle bundleizedRequest, boolean doDryRun, int reason, String callerPackageName, RemoteCallback callback) {
                Preconditions.checkNotNull(bundleizedRequest, "bundleizedRequest");
                Preconditions.checkNotNull(callerPackageName);
                Preconditions.checkNotNull(callback);
                ArrayMap<String, List<String>> request = new ArrayMap<String, List<String>>();
                for (String packageName : bundleizedRequest.keySet()) {
                    Preconditions.checkNotNull(packageName);
                    ArrayList<String> permissions = bundleizedRequest.getStringArrayList(packageName);
                    Preconditions.checkCollectionElementsNotNull(permissions, "permissions");
                    request.put(packageName, permissions);
                }
                PermissionControllerService.this.enforceCallingPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", null);
                try {
                    PackageInfo pkgInfo = PermissionControllerService.this.getPackageManager().getPackageInfo(callerPackageName, 0);
                    Preconditions.checkArgument(1.getCallingUid() == pkgInfo.applicationInfo.uid);
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new RuntimeException(e);
                }
                PermissionControllerService.this.onRevokeRuntimePermissions(request, doDryRun, reason, callerPackageName, revoked -> {
                    Preconditions.checkNotNull(revoked);
                    Bundle bundledizedRevoked = new Bundle();
                    for (Map.Entry appRevocation : revoked.entrySet()) {
                        Preconditions.checkNotNull((String)appRevocation.getKey());
                        Preconditions.checkCollectionElementsNotNull((List)appRevocation.getValue(), "permissions");
                        bundledizedRevoked.putStringArrayList((String)appRevocation.getKey(), new ArrayList<String>((Collection)appRevocation.getValue()));
                    }
                    Bundle result = new Bundle();
                    result.putBundle("android.permission.PermissionControllerManager.key.result", bundledizedRevoked);
                    callback.sendResult(result);
                });
            }

            @Override
            public void getRuntimePermissionBackup(UserHandle user, ParcelFileDescriptor pipe) {
                Preconditions.checkNotNull(user);
                Preconditions.checkNotNull(pipe);
                PermissionControllerService.this.enforceCallingPermission("android.permission.GET_RUNTIME_PERMISSIONS", null);
                try (ParcelFileDescriptor.AutoCloseOutputStream backup = new ParcelFileDescriptor.AutoCloseOutputStream(pipe);){
                    CountDownLatch latch = new CountDownLatch(1);
                    PermissionControllerService.this.onGetRuntimePermissionsBackup(user, backup, latch::countDown);
                    latch.await();
                }
                catch (IOException e) {
                    Log.e(LOG_TAG, "Could not open pipe to write backup to", e);
                }
                catch (InterruptedException e) {
                    Log.e(LOG_TAG, "getRuntimePermissionBackup timed out", e);
                }
            }

            @Override
            public void restoreRuntimePermissionBackup(UserHandle user, ParcelFileDescriptor pipe) {
                Preconditions.checkNotNull(user);
                Preconditions.checkNotNull(pipe);
                PermissionControllerService.this.enforceCallingPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", null);
                try (ParcelFileDescriptor.AutoCloseInputStream backup = new ParcelFileDescriptor.AutoCloseInputStream(pipe);){
                    CountDownLatch latch = new CountDownLatch(1);
                    PermissionControllerService.this.onRestoreRuntimePermissionsBackup(user, backup, latch::countDown);
                    latch.await();
                }
                catch (IOException e) {
                    Log.e(LOG_TAG, "Could not open pipe to read backup from", e);
                }
                catch (InterruptedException e) {
                    Log.e(LOG_TAG, "restoreRuntimePermissionBackup timed out", e);
                }
            }

            @Override
            public void restoreDelayedRuntimePermissionBackup(String packageName, UserHandle user, RemoteCallback callback) {
                Preconditions.checkNotNull(packageName);
                Preconditions.checkNotNull(user);
                Preconditions.checkNotNull(callback);
                PermissionControllerService.this.enforceCallingPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", null);
                PermissionControllerService.this.onRestoreDelayedRuntimePermissionsBackup(packageName, user, hasMoreBackup -> {
                    Bundle result = new Bundle();
                    result.putBoolean("android.permission.PermissionControllerManager.key.result", (boolean)hasMoreBackup);
                    callback.sendResult(result);
                });
            }

            @Override
            public void getAppPermissions(String packageName, RemoteCallback callback) {
                Preconditions.checkNotNull(packageName, "packageName");
                Preconditions.checkNotNull(callback, "callback");
                PermissionControllerService.this.enforceCallingPermission("android.permission.GET_RUNTIME_PERMISSIONS", null);
                PermissionControllerService.this.onGetAppPermissions(packageName, permissions -> {
                    if (permissions != null && !permissions.isEmpty()) {
                        Bundle result = new Bundle();
                        result.putParcelableList("android.permission.PermissionControllerManager.key.result", (List<? extends Parcelable>)permissions);
                        callback.sendResult(result);
                    } else {
                        callback.sendResult(null);
                    }
                });
            }

            @Override
            public void revokeRuntimePermission(String packageName, String permissionName) {
                Preconditions.checkNotNull(packageName, "packageName");
                Preconditions.checkNotNull(permissionName, "permissionName");
                PermissionControllerService.this.enforceCallingPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", null);
                CountDownLatch latch = new CountDownLatch(1);
                PermissionControllerService.this.onRevokeRuntimePermission(packageName, permissionName, latch::countDown);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Log.e(LOG_TAG, "revokeRuntimePermission timed out", e);
                }
            }

            @Override
            public void countPermissionApps(List<String> permissionNames, int flags, RemoteCallback callback) {
                Preconditions.checkCollectionElementsNotNull(permissionNames, "permissionNames");
                Preconditions.checkFlagsArgument(flags, 3);
                Preconditions.checkNotNull(callback, "callback");
                PermissionControllerService.this.enforceCallingPermission("android.permission.GET_RUNTIME_PERMISSIONS", null);
                PermissionControllerService.this.onCountPermissionApps(permissionNames, flags, numApps -> {
                    Bundle result = new Bundle();
                    result.putInt("android.permission.PermissionControllerManager.key.result", numApps);
                    callback.sendResult(result);
                });
            }

            @Override
            public void getPermissionUsages(boolean countSystem, long numMillis, RemoteCallback callback) {
                Preconditions.checkArgumentNonnegative(numMillis);
                Preconditions.checkNotNull(callback, "callback");
                PermissionControllerService.this.enforceCallingPermission("android.permission.GET_RUNTIME_PERMISSIONS", null);
                PermissionControllerService.this.onGetPermissionUsages(countSystem, numMillis, users -> {
                    if (users != null && !users.isEmpty()) {
                        Bundle result = new Bundle();
                        result.putParcelableList("android.permission.PermissionControllerManager.key.result", (List<? extends Parcelable>)users);
                        callback.sendResult(result);
                    } else {
                        callback.sendResult(null);
                    }
                });
            }

            @Override
            public void setRuntimePermissionGrantStateByDeviceAdmin(String callerPackageName, String packageName, String permission2, int grantState, RemoteCallback callback) {
                Preconditions.checkStringNotEmpty(callerPackageName);
                Preconditions.checkStringNotEmpty(packageName);
                Preconditions.checkStringNotEmpty(permission2);
                Preconditions.checkArgument(grantState == 1 || grantState == 2 || grantState == 0);
                Preconditions.checkNotNull(callback);
                if (grantState == 2) {
                    PermissionControllerService.this.enforceCallingPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", null);
                }
                if (grantState == 2) {
                    PermissionControllerService.this.enforceCallingPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", null);
                }
                PermissionControllerService.this.enforceCallingPermission("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", null);
                PermissionControllerService.this.onSetRuntimePermissionGrantStateByDeviceAdmin(callerPackageName, packageName, permission2, grantState, wasSet -> {
                    Bundle result = new Bundle();
                    result.putBoolean("android.permission.PermissionControllerManager.key.result", (boolean)wasSet);
                    callback.sendResult(result);
                });
            }

            @Override
            public void grantOrUpgradeDefaultRuntimePermissions(RemoteCallback callback) {
                Preconditions.checkNotNull(callback, "callback");
                PermissionControllerService.this.enforceCallingPermission("android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", null);
                PermissionControllerService.this.onGrantOrUpgradeDefaultRuntimePermissions(() -> callback.sendResult(Bundle.EMPTY));
            }
        };
    }
}

