/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

@SystemApi
public final class RuntimePermissionPresentationInfo
implements Parcelable {
    private static final int FLAG_GRANTED = 1;
    private static final int FLAG_STANDARD = 2;
    private final CharSequence mLabel;
    private final int mFlags;
    public static final Parcelable.Creator<RuntimePermissionPresentationInfo> CREATOR = new Parcelable.Creator<RuntimePermissionPresentationInfo>(){

        @Override
        public RuntimePermissionPresentationInfo createFromParcel(Parcel source) {
            CharSequence label = source.readCharSequence();
            int flags = source.readInt();
            return new RuntimePermissionPresentationInfo(label, (flags & 1) != 0, (flags & 2) != 0);
        }

        public RuntimePermissionPresentationInfo[] newArray(int size) {
            return new RuntimePermissionPresentationInfo[size];
        }
    };

    public RuntimePermissionPresentationInfo(CharSequence label, boolean granted, boolean standard) {
        Preconditions.checkNotNull(label);
        this.mLabel = label;
        int flags = 0;
        if (granted) {
            flags |= 1;
        }
        if (standard) {
            flags |= 2;
        }
        this.mFlags = flags;
    }

    public boolean isGranted() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isStandard() {
        return (this.mFlags & 2) != 0;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeCharSequence(this.mLabel);
        parcel.writeInt(this.mFlags);
    }
}

