/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.ComponentName;
import android.graphics.drawable.Icon;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.IPrintSpoolerCallbacks;
import android.print.IPrintSpoolerClient;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface IPrintSpooler
extends IInterface {
    public void removeObsoletePrintJobs() throws RemoteException;

    public void getPrintJobInfos(IPrintSpoolerCallbacks var1, ComponentName var2, int var3, int var4, int var5) throws RemoteException;

    public void getPrintJobInfo(PrintJobId var1, IPrintSpoolerCallbacks var2, int var3, int var4) throws RemoteException;

    public void createPrintJob(PrintJobInfo var1) throws RemoteException;

    public void setPrintJobState(PrintJobId var1, int var2, String var3, IPrintSpoolerCallbacks var4, int var5) throws RemoteException;

    public void setProgress(PrintJobId var1, float var2) throws RemoteException;

    public void setStatus(PrintJobId var1, CharSequence var2) throws RemoteException;

    public void setStatusRes(PrintJobId var1, int var2, CharSequence var3) throws RemoteException;

    public void onCustomPrinterIconLoaded(PrinterId var1, Icon var2, IPrintSpoolerCallbacks var3, int var4) throws RemoteException;

    public void getCustomPrinterIcon(PrinterId var1, IPrintSpoolerCallbacks var2, int var3) throws RemoteException;

    public void clearCustomPrinterIconCache(IPrintSpoolerCallbacks var1, int var2) throws RemoteException;

    public void setPrintJobTag(PrintJobId var1, String var2, IPrintSpoolerCallbacks var3, int var4) throws RemoteException;

    public void writePrintJobData(ParcelFileDescriptor var1, PrintJobId var2) throws RemoteException;

    public void setClient(IPrintSpoolerClient var1) throws RemoteException;

    public void setPrintJobCancelling(PrintJobId var1, boolean var2) throws RemoteException;

    public void pruneApprovedPrintServices(List<ComponentName> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPrintSpooler {
        private static final String DESCRIPTOR = "android.print.IPrintSpooler";
        static final int TRANSACTION_removeObsoletePrintJobs = 1;
        static final int TRANSACTION_getPrintJobInfos = 2;
        static final int TRANSACTION_getPrintJobInfo = 3;
        static final int TRANSACTION_createPrintJob = 4;
        static final int TRANSACTION_setPrintJobState = 5;
        static final int TRANSACTION_setProgress = 6;
        static final int TRANSACTION_setStatus = 7;
        static final int TRANSACTION_setStatusRes = 8;
        static final int TRANSACTION_onCustomPrinterIconLoaded = 9;
        static final int TRANSACTION_getCustomPrinterIcon = 10;
        static final int TRANSACTION_clearCustomPrinterIconCache = 11;
        static final int TRANSACTION_setPrintJobTag = 12;
        static final int TRANSACTION_writePrintJobData = 13;
        static final int TRANSACTION_setClient = 14;
        static final int TRANSACTION_setPrintJobCancelling = 15;
        static final int TRANSACTION_pruneApprovedPrintServices = 16;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPrintSpooler asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPrintSpooler) {
                return (IPrintSpooler)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "removeObsoletePrintJobs";
                }
                case 2: {
                    return "getPrintJobInfos";
                }
                case 3: {
                    return "getPrintJobInfo";
                }
                case 4: {
                    return "createPrintJob";
                }
                case 5: {
                    return "setPrintJobState";
                }
                case 6: {
                    return "setProgress";
                }
                case 7: {
                    return "setStatus";
                }
                case 8: {
                    return "setStatusRes";
                }
                case 9: {
                    return "onCustomPrinterIconLoaded";
                }
                case 10: {
                    return "getCustomPrinterIcon";
                }
                case 11: {
                    return "clearCustomPrinterIconCache";
                }
                case 12: {
                    return "setPrintJobTag";
                }
                case 13: {
                    return "writePrintJobData";
                }
                case 14: {
                    return "setClient";
                }
                case 15: {
                    return "setPrintJobCancelling";
                }
                case 16: {
                    return "pruneApprovedPrintServices";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    this.removeObsoletePrintJobs();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IPrintSpoolerCallbacks _arg0 = IPrintSpoolerCallbacks.Stub.asInterface(data.readStrongBinder());
                    ComponentName _arg1 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    this.getPrintJobInfos(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    IPrintSpoolerCallbacks _arg1 = IPrintSpoolerCallbacks.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.getPrintJobInfo(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    PrintJobInfo _arg0 = 0 != data.readInt() ? PrintJobInfo.CREATOR.createFromParcel(data) : null;
                    this.createPrintJob(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    IPrintSpoolerCallbacks _arg3 = IPrintSpoolerCallbacks.Stub.asInterface(data.readStrongBinder());
                    int _arg4 = data.readInt();
                    this.setPrintJobState(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    float _arg1 = data.readFloat();
                    this.setProgress(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    CharSequence _arg1 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    this.setStatus(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    CharSequence _arg2 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    this.setStatusRes(_arg0, _arg1, _arg2);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    PrinterId _arg0 = 0 != data.readInt() ? PrinterId.CREATOR.createFromParcel(data) : null;
                    Icon _arg1 = 0 != data.readInt() ? Icon.CREATOR.createFromParcel(data) : null;
                    IPrintSpoolerCallbacks _arg2 = IPrintSpoolerCallbacks.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.onCustomPrinterIconLoaded(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    PrinterId _arg0 = 0 != data.readInt() ? PrinterId.CREATOR.createFromParcel(data) : null;
                    IPrintSpoolerCallbacks _arg1 = IPrintSpoolerCallbacks.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.getCustomPrinterIcon(_arg0, _arg1, _arg2);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IPrintSpoolerCallbacks _arg0 = IPrintSpoolerCallbacks.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.clearCustomPrinterIconCache(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    IPrintSpoolerCallbacks _arg2 = IPrintSpoolerCallbacks.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.setPrintJobTag(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    ParcelFileDescriptor _arg0 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    PrintJobId _arg1 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    this.writePrintJobData(_arg0, _arg1);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    IPrintSpoolerClient _arg0 = IPrintSpoolerClient.Stub.asInterface(data.readStrongBinder());
                    this.setClient(_arg0);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    PrintJobId _arg0 = 0 != data.readInt() ? PrintJobId.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    this.setPrintJobCancelling(_arg0, _arg1);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    ArrayList<ComponentName> _arg0 = data.createTypedArrayList(ComponentName.CREATOR);
                    this.pruneApprovedPrintServices(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPrintSpooler impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPrintSpooler getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPrintSpooler {
            private IBinder mRemote;
            public static IPrintSpooler sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void removeObsoletePrintJobs() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeObsoletePrintJobs();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPrintJobInfos(IPrintSpoolerCallbacks callback, ComponentName componentName, int state, int appId, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (componentName != null) {
                        _data.writeInt(1);
                        componentName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(state);
                    _data.writeInt(appId);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getPrintJobInfos(callback, componentName, state, appId, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPrintJobInfo(PrintJobId printJobId, IPrintSpoolerCallbacks callback, int appId, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(appId);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getPrintJobInfo(printJobId, callback, appId, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createPrintJob(PrintJobInfo printJob) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJob != null) {
                        _data.writeInt(1);
                        printJob.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().createPrintJob(printJob);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrintJobState(PrintJobId printJobId, int status, String stateReason, IPrintSpoolerCallbacks callback, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(status);
                    _data.writeString(stateReason);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPrintJobState(printJobId, status, stateReason, callback, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setProgress(PrintJobId printJobId, float progress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeFloat(progress);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setProgress(printJobId, progress);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStatus(PrintJobId printJobId, CharSequence status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (status != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(status, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setStatus(printJobId, status);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStatusRes(PrintJobId printJobId, int status, CharSequence appPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(status);
                    if (appPackageName != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(appPackageName, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setStatusRes(printJobId, status, appPackageName);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCustomPrinterIconLoaded(PrinterId printerId, Icon icon, IPrintSpoolerCallbacks callbacks, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printerId != null) {
                        _data.writeInt(1);
                        printerId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (icon != null) {
                        _data.writeInt(1);
                        icon.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callbacks != null ? callbacks.asBinder() : null);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCustomPrinterIconLoaded(printerId, icon, callbacks, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCustomPrinterIcon(PrinterId printerId, IPrintSpoolerCallbacks callbacks, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printerId != null) {
                        _data.writeInt(1);
                        printerId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callbacks != null ? callbacks.asBinder() : null);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getCustomPrinterIcon(printerId, callbacks, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearCustomPrinterIconCache(IPrintSpoolerCallbacks callbacks, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callbacks != null ? callbacks.asBinder() : null);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearCustomPrinterIconCache(callbacks, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrintJobTag(PrintJobId printJobId, String tag, IPrintSpoolerCallbacks callback, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(tag);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPrintJobTag(printJobId, tag, callback, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writePrintJobData(ParcelFileDescriptor fd, PrintJobId printJobId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (fd != null) {
                        _data.writeInt(1);
                        fd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().writePrintJobData(fd, printJobId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setClient(IPrintSpoolerClient client) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setClient(client);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrintJobCancelling(PrintJobId printJobId, boolean cancelling) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (printJobId != null) {
                        _data.writeInt(1);
                        printJobId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(cancelling ? 1 : 0);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPrintJobCancelling(printJobId, cancelling);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pruneApprovedPrintServices(List<ComponentName> servicesToKeep) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(servicesToKeep);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().pruneApprovedPrintServices(servicesToKeep);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPrintSpooler {
        @Override
        public void removeObsoletePrintJobs() throws RemoteException {
        }

        @Override
        public void getPrintJobInfos(IPrintSpoolerCallbacks callback, ComponentName componentName, int state, int appId, int sequence) throws RemoteException {
        }

        @Override
        public void getPrintJobInfo(PrintJobId printJobId, IPrintSpoolerCallbacks callback, int appId, int sequence) throws RemoteException {
        }

        @Override
        public void createPrintJob(PrintJobInfo printJob) throws RemoteException {
        }

        @Override
        public void setPrintJobState(PrintJobId printJobId, int status, String stateReason, IPrintSpoolerCallbacks callback, int sequence) throws RemoteException {
        }

        @Override
        public void setProgress(PrintJobId printJobId, float progress) throws RemoteException {
        }

        @Override
        public void setStatus(PrintJobId printJobId, CharSequence status) throws RemoteException {
        }

        @Override
        public void setStatusRes(PrintJobId printJobId, int status, CharSequence appPackageName) throws RemoteException {
        }

        @Override
        public void onCustomPrinterIconLoaded(PrinterId printerId, Icon icon, IPrintSpoolerCallbacks callbacks, int sequence) throws RemoteException {
        }

        @Override
        public void getCustomPrinterIcon(PrinterId printerId, IPrintSpoolerCallbacks callbacks, int sequence) throws RemoteException {
        }

        @Override
        public void clearCustomPrinterIconCache(IPrintSpoolerCallbacks callbacks, int sequence) throws RemoteException {
        }

        @Override
        public void setPrintJobTag(PrintJobId printJobId, String tag, IPrintSpoolerCallbacks callback, int sequence) throws RemoteException {
        }

        @Override
        public void writePrintJobData(ParcelFileDescriptor fd, PrintJobId printJobId) throws RemoteException {
        }

        @Override
        public void setClient(IPrintSpoolerClient client) throws RemoteException {
        }

        @Override
        public void setPrintJobCancelling(PrintJobId printJobId, boolean cancelling) throws RemoteException {
        }

        @Override
        public void pruneApprovedPrintServices(List<ComponentName> servicesToKeep) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

