/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.Context;
import android.content.Loader;
import android.os.Handler;
import android.os.Message;
import android.print.PrintManager;
import android.printservice.PrintServiceInfo;
import com.android.internal.util.Preconditions;
import java.util.List;

public class PrintServicesLoader
extends Loader<List<PrintServiceInfo>> {
    private final int mSelectionFlags;
    private final PrintManager mPrintManager;
    private final Handler mHandler = new MyHandler();
    private PrintManager.PrintServicesChangeListener mListener;

    public PrintServicesLoader(PrintManager printManager, Context context, int selectionFlags) {
        super(Preconditions.checkNotNull(context));
        this.mPrintManager = Preconditions.checkNotNull(printManager);
        this.mSelectionFlags = Preconditions.checkFlagsArgument(selectionFlags, 3);
    }

    @Override
    protected void onForceLoad() {
        this.queueNewResult();
    }

    private void queueNewResult() {
        Message m = this.mHandler.obtainMessage(0);
        m.obj = this.mPrintManager.getPrintServices(this.mSelectionFlags);
        this.mHandler.sendMessage(m);
    }

    @Override
    protected void onStartLoading() {
        this.mListener = new PrintManager.PrintServicesChangeListener(){

            @Override
            public void onPrintServicesChanged() {
                PrintServicesLoader.this.queueNewResult();
            }
        };
        this.mPrintManager.addPrintServicesChangeListener(this.mListener, null);
        this.deliverResult(this.mPrintManager.getPrintServices(this.mSelectionFlags));
    }

    @Override
    protected void onStopLoading() {
        if (this.mListener != null) {
            this.mPrintManager.removePrintServicesChangeListener(this.mListener);
            this.mListener = null;
        }
        this.mHandler.removeMessages(0);
    }

    @Override
    protected void onReset() {
        this.onStopLoading();
    }

    private class MyHandler
    extends Handler {
        public MyHandler() {
            super(PrintServicesLoader.this.getContext().getMainLooper());
        }

        @Override
        public void handleMessage(Message msg) {
            if (PrintServicesLoader.this.isStarted()) {
                PrintServicesLoader.this.deliverResult((List)msg.obj);
            }
        }
    }
}

