/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.content.pm.ParceledListSlice;
import android.os.CancellationSignal;
import android.os.RemoteException;
import android.print.PrinterId;
import android.print.PrinterInfo;
import android.printservice.CustomPrinterIconCallback;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintService;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PrinterDiscoverySession {
    private static final String LOG_TAG = "PrinterDiscoverySession";
    private static int sIdCounter = 0;
    private final int mId;
    private final ArrayMap<PrinterId, PrinterInfo> mPrinters = new ArrayMap();
    private final List<PrinterId> mTrackedPrinters = new ArrayList<PrinterId>();
    private ArrayMap<PrinterId, PrinterInfo> mLastSentPrinters;
    private IPrintServiceClient mObserver;
    private boolean mIsDestroyed;
    private boolean mIsDiscoveryStarted;

    public PrinterDiscoverySession() {
        this.mId = sIdCounter++;
    }

    void setObserver(IPrintServiceClient observer) {
        this.mObserver = observer;
        if (!this.mPrinters.isEmpty()) {
            try {
                this.mObserver.onPrintersAdded(new ParceledListSlice<PrinterInfo>(this.getPrinters()));
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error sending added printers", re);
            }
        }
    }

    int getId() {
        return this.mId;
    }

    public final List<PrinterInfo> getPrinters() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            return Collections.emptyList();
        }
        return new ArrayList<PrinterInfo>(this.mPrinters.values());
    }

    public final void addPrinters(List<PrinterInfo> printers) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            Log.w(LOG_TAG, "Not adding printers - session destroyed.");
            return;
        }
        if (this.mIsDiscoveryStarted) {
            ArrayList<PrinterInfo> addedPrinters = null;
            int addedPrinterCount = printers.size();
            for (int i = 0; i < addedPrinterCount; ++i) {
                PrinterInfo addedPrinter = printers.get(i);
                PrinterInfo oldPrinter = this.mPrinters.put(addedPrinter.getId(), addedPrinter);
                if (oldPrinter != null && oldPrinter.equals(addedPrinter)) continue;
                if (addedPrinters == null) {
                    addedPrinters = new ArrayList<PrinterInfo>();
                }
                addedPrinters.add(addedPrinter);
            }
            if (addedPrinters != null) {
                try {
                    this.mObserver.onPrintersAdded(new ParceledListSlice(addedPrinters));
                }
                catch (RemoteException re) {
                    Log.e(LOG_TAG, "Error sending added printers", re);
                }
            }
        } else {
            if (this.mLastSentPrinters == null) {
                this.mLastSentPrinters = new ArrayMap<PrinterId, PrinterInfo>(this.mPrinters);
            }
            int addedPrinterCount = printers.size();
            for (int i = 0; i < addedPrinterCount; ++i) {
                PrinterInfo addedPrinter = printers.get(i);
                if (this.mPrinters.get(addedPrinter.getId()) != null) continue;
                this.mPrinters.put(addedPrinter.getId(), addedPrinter);
            }
        }
    }

    public final void removePrinters(List<PrinterId> printerIds) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            Log.w(LOG_TAG, "Not removing printers - session destroyed.");
            return;
        }
        if (this.mIsDiscoveryStarted) {
            ArrayList<PrinterId> removedPrinterIds = new ArrayList<PrinterId>();
            int removedPrinterIdCount = printerIds.size();
            for (int i = 0; i < removedPrinterIdCount; ++i) {
                PrinterId removedPrinterId = printerIds.get(i);
                if (this.mPrinters.remove(removedPrinterId) == null) continue;
                removedPrinterIds.add(removedPrinterId);
            }
            if (!removedPrinterIds.isEmpty()) {
                try {
                    this.mObserver.onPrintersRemoved(new ParceledListSlice(removedPrinterIds));
                }
                catch (RemoteException re) {
                    Log.e(LOG_TAG, "Error sending removed printers", re);
                }
            }
        } else {
            if (this.mLastSentPrinters == null) {
                this.mLastSentPrinters = new ArrayMap<PrinterId, PrinterInfo>(this.mPrinters);
            }
            int removedPrinterIdCount = printerIds.size();
            for (int i = 0; i < removedPrinterIdCount; ++i) {
                PrinterId removedPrinterId = printerIds.get(i);
                this.mPrinters.remove(removedPrinterId);
            }
        }
    }

    private void sendOutOfDiscoveryPeriodPrinterChanges() {
        if (this.mLastSentPrinters == null || this.mLastSentPrinters.isEmpty()) {
            this.mLastSentPrinters = null;
            return;
        }
        ArrayList<PrinterInfo> addedPrinters = null;
        for (PrinterInfo printerInfo : this.mPrinters.values()) {
            PrinterInfo sentPrinter = this.mLastSentPrinters.get(printerInfo.getId());
            if (sentPrinter != null && sentPrinter.equals(printerInfo)) continue;
            if (addedPrinters == null) {
                addedPrinters = new ArrayList<PrinterInfo>();
            }
            addedPrinters.add(printerInfo);
        }
        if (addedPrinters != null) {
            try {
                this.mObserver.onPrintersAdded(new ParceledListSlice(addedPrinters));
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error sending added printers", re);
            }
        }
        ArrayList<PrinterId> removedPrinterIds = null;
        for (PrinterInfo sentPrinter : this.mLastSentPrinters.values()) {
            if (this.mPrinters.containsKey(sentPrinter.getId())) continue;
            if (removedPrinterIds == null) {
                removedPrinterIds = new ArrayList<PrinterId>();
            }
            removedPrinterIds.add(sentPrinter.getId());
        }
        if (removedPrinterIds != null) {
            try {
                this.mObserver.onPrintersRemoved(new ParceledListSlice(removedPrinterIds));
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error sending removed printers", remoteException);
            }
        }
        this.mLastSentPrinters = null;
    }

    public abstract void onStartPrinterDiscovery(List<PrinterId> var1);

    public abstract void onStopPrinterDiscovery();

    public abstract void onValidatePrinters(List<PrinterId> var1);

    public abstract void onStartPrinterStateTracking(PrinterId var1);

    public void onRequestCustomPrinterIcon(PrinterId printerId, CancellationSignal cancellationSignal, CustomPrinterIconCallback callback) {
    }

    public abstract void onStopPrinterStateTracking(PrinterId var1);

    public final List<PrinterId> getTrackedPrinters() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            return Collections.emptyList();
        }
        return new ArrayList<PrinterId>(this.mTrackedPrinters);
    }

    public abstract void onDestroy();

    public final boolean isDestroyed() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mIsDestroyed;
    }

    public final boolean isPrinterDiscoveryStarted() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mIsDiscoveryStarted;
    }

    void startPrinterDiscovery(List<PrinterId> priorityList) {
        if (!this.mIsDestroyed) {
            this.mIsDiscoveryStarted = true;
            this.sendOutOfDiscoveryPeriodPrinterChanges();
            if (priorityList == null) {
                priorityList = Collections.emptyList();
            }
            this.onStartPrinterDiscovery(priorityList);
        }
    }

    void stopPrinterDiscovery() {
        if (!this.mIsDestroyed) {
            this.mIsDiscoveryStarted = false;
            this.onStopPrinterDiscovery();
        }
    }

    void validatePrinters(List<PrinterId> printerIds) {
        if (!this.mIsDestroyed && this.mObserver != null) {
            this.onValidatePrinters(printerIds);
        }
    }

    void startPrinterStateTracking(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null && !this.mTrackedPrinters.contains(printerId)) {
            this.mTrackedPrinters.add(printerId);
            this.onStartPrinterStateTracking(printerId);
        }
    }

    void requestCustomPrinterIcon(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null) {
            CustomPrinterIconCallback callback = new CustomPrinterIconCallback(printerId, this.mObserver);
            this.onRequestCustomPrinterIcon(printerId, new CancellationSignal(), callback);
        }
    }

    void stopPrinterStateTracking(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null && this.mTrackedPrinters.remove(printerId)) {
            this.onStopPrinterStateTracking(printerId);
        }
    }

    void destroy() {
        if (!this.mIsDestroyed) {
            this.mIsDestroyed = true;
            this.mIsDiscoveryStarted = false;
            this.mPrinters.clear();
            this.mLastSentPrinters = null;
            this.mObserver = null;
            this.onDestroy();
        }
    }
}

