/*
 * Decompiled with CFR 0.152.
 */
package android.privacy.internal.longitudinalreporting;

import android.privacy.DifferentialPrivacyConfig;
import android.privacy.internal.rappor.RapporConfig;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;

public class LongitudinalReportingConfig
implements DifferentialPrivacyConfig {
    private static final String ALGORITHM_NAME = "LongitudinalReporting";
    private final double mProbabilityF;
    private final double mProbabilityP;
    private final double mProbabilityQ;
    private final RapporConfig mIRRConfig;
    private final String mEncoderId;

    public LongitudinalReportingConfig(String encoderId, double probabilityF, double probabilityP, double probabilityQ) {
        Preconditions.checkArgument(probabilityF >= 0.0 && probabilityF <= 1.0, "probabilityF must be in range [0.0, 1.0]");
        this.mProbabilityF = probabilityF;
        Preconditions.checkArgument(probabilityP >= 0.0 && probabilityP <= 1.0, "probabilityP must be in range [0.0, 1.0]");
        this.mProbabilityP = probabilityP;
        Preconditions.checkArgument(probabilityQ >= 0.0 && probabilityQ <= 1.0, "probabilityQ must be in range [0.0, 1.0]");
        this.mProbabilityQ = probabilityQ;
        Preconditions.checkArgument(!TextUtils.isEmpty(encoderId), "encoderId cannot be empty");
        this.mEncoderId = encoderId;
        this.mIRRConfig = new RapporConfig(encoderId, 1, 0.0, probabilityF, 1.0 - probabilityF, 1, 1);
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM_NAME;
    }

    RapporConfig getIRRConfig() {
        return this.mIRRConfig;
    }

    double getProbabilityP() {
        return this.mProbabilityP;
    }

    double getProbabilityQ() {
        return this.mProbabilityQ;
    }

    String getEncoderId() {
        return this.mEncoderId;
    }

    public String toString() {
        return String.format("EncoderId: %s, ProbabilityF: %.3f, ProbabilityP: %.3f, ProbabilityQ: %.3f", this.mEncoderId, this.mProbabilityF, this.mProbabilityP, this.mProbabilityQ);
    }
}

