/*
 * Decompiled with CFR 0.152.
 */
package android.privacy.internal.rappor;

import android.privacy.DifferentialPrivacyEncoder;
import android.privacy.internal.rappor.RapporConfig;
import com.google.android.rappor.Encoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RapporEncoder
implements DifferentialPrivacyEncoder {
    private static final byte[] INSECURE_SECRET = new byte[]{-41, 104, -103, -109, -108, 19, 83, 84, -2, -48, 126, 84, -2, -48, 126, 84, -41, 104, -103, -109, -108, 19, 83, 84, -2, -48, 126, 84, -2, -48, 126, 84, -41, 104, -103, -109, -108, 19, 83, 84, -2, -48, 126, 84, -2, -48, 126, 84};
    private static final SecureRandom sSecureRandom = new SecureRandom();
    private final RapporConfig mConfig;
    private final Encoder mEncoder;
    private final boolean mIsSecure;

    private RapporEncoder(RapporConfig config, boolean secureEncoder, byte[] userSecret) {
        Random random;
        this.mConfig = config;
        this.mIsSecure = secureEncoder;
        if (secureEncoder) {
            random = sSecureRandom;
        } else {
            random = new Random(this.getInsecureSeed(config.mEncoderId));
            userSecret = INSECURE_SECRET;
        }
        this.mEncoder = new Encoder(random, null, null, userSecret, config.mEncoderId, config.mNumBits, config.mProbabilityF, config.mProbabilityP, config.mProbabilityQ, config.mNumCohorts, config.mNumBloomHashes);
    }

    private long getInsecureSeed(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return ByteBuffer.wrap(bytes).getLong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"Unable generate insecure seed");
        }
    }

    public static RapporEncoder createEncoder(RapporConfig config, byte[] userSecret) {
        return new RapporEncoder(config, true, userSecret);
    }

    public static RapporEncoder createInsecureEncoderForTest(RapporConfig config) {
        return new RapporEncoder(config, false, null);
    }

    @Override
    public byte[] encodeString(String original) {
        return this.mEncoder.encodeString(original);
    }

    @Override
    public byte[] encodeBoolean(boolean original) {
        return this.mEncoder.encodeBoolean(original);
    }

    @Override
    public byte[] encodeBits(byte[] bits) {
        return this.mEncoder.encodeBits(bits);
    }

    @Override
    public RapporConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public boolean isInsecureEncoderForTest() {
        return !this.mIsSecure;
    }
}

