/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

@SystemApi
public final class DeviceConfig {
    public static final Uri CONTENT_URI = Uri.parse("content://settings/config");
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER = "activity_manager";
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER_NATIVE_BOOT = "activity_manager_native_boot";
    @SystemApi
    public static final String NAMESPACE_APP_COMPAT = "app_compat";
    @SystemApi
    public static final String NAMESPACE_ATTENTION_MANAGER_SERVICE = "attention_manager_service";
    @SystemApi
    public static final String NAMESPACE_AUTOFILL = "autofill";
    @SystemApi
    public static final String NAMESPACE_CONNECTIVITY = "connectivity";
    @SystemApi
    public static final String NAMESPACE_CONTENT_CAPTURE = "content_capture";
    @SystemApi
    public static final String NAMESPACE_DEX_BOOT = "dex_boot";
    @SystemApi
    public static final String NAMESPACE_GAME_DRIVER = "game_driver";
    @SystemApi
    public static final String NAMESPACE_INPUT_NATIVE_BOOT = "input_native_boot";
    @SystemApi
    public static final String NAMESPACE_INTELLIGENCE_ATTENTION = "intelligence_attention";
    public static final String NAMESPACE_INTELLIGENCE_CONTENT_SUGGESTIONS = "intelligence_content_suggestions";
    @SystemApi
    public static final String NAMESPACE_MEDIA_NATIVE = "media_native";
    @SystemApi
    public static final String NAMESPACE_NETD_NATIVE = "netd_native";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK = "rollback";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK_BOOT = "rollback_boot";
    @SystemApi
    public static final String NAMESPACE_RUNTIME = "runtime";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE = "runtime_native";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE_BOOT = "runtime_native_boot";
    @SystemApi
    public static final String NAMESPACE_SCHEDULER = "scheduler";
    @SystemApi
    public static final String NAMESPACE_STORAGE = "storage";
    @SystemApi
    public static final String NAMESPACE_SYSTEMUI = "systemui";
    @SystemApi
    public static final String NAMESPACE_TELEPHONY = "telephony";
    @SystemApi
    public static final String NAMESPACE_TEXTCLASSIFIER = "textclassifier";
    public static final String NAMESPACE_CONTACTS_PROVIDER = "contacts_provider";
    public static final String NAMESPACE_SETTINGS_UI = "settings_ui";
    public static final String NAMESPACE_WINDOW_MANAGER = "android:window_manager";
    private static final List<String> PUBLIC_NAMESPACES = Arrays.asList("textclassifier", "runtime");
    @SystemApi
    public static final String NAMESPACE_PRIVACY = "privacy";
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<OnPropertyChangedListener, Pair<String, Executor>> sSingleListeners = new ArrayMap();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<OnPropertiesChangedListener, Pair<String, Executor>> sListeners = new ArrayMap();
    @GuardedBy(value={"sLock"})
    private static Map<String, Pair<ContentObserver, Integer>> sNamespaces = new HashMap<String, Pair<ContentObserver, Integer>>();
    private static final String TAG = "DeviceConfig";

    private DeviceConfig() {
    }

    @SystemApi
    public static String getProperty(String namespace, String name) {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        String compositeName = DeviceConfig.createCompositeName(namespace, name);
        return Settings.Config.getString(contentResolver, compositeName);
    }

    @SystemApi
    public static String getString(String namespace, String name, String defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? value : defaultValue;
    }

    @SystemApi
    public static boolean getBoolean(String namespace, String name, boolean defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @SystemApi
    public static int getInt(String namespace, String name, int defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing integer failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @SystemApi
    public static long getLong(String namespace, String name, long defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing long failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @SystemApi
    public static float getFloat(String namespace, String name, float defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing float failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @SystemApi
    public static boolean setProperty(String namespace, String name, String value, boolean makeDefault) {
        String compositeName = DeviceConfig.createCompositeName(namespace, name);
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        return Settings.Config.putString(contentResolver, compositeName, value, makeDefault);
    }

    @SystemApi
    public static void resetToDefaults(int resetMode, String namespace) {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        Settings.Config.resetToDefaults(contentResolver, resetMode, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void addOnPropertyChangedListener(String namespace, Executor executor, OnPropertyChangedListener onPropertyChangedListener) {
        DeviceConfig.enforceReadPermission(ActivityThread.currentApplication().getApplicationContext(), namespace);
        Object object = sLock;
        synchronized (object) {
            Pair<String, Executor> oldNamespace = sSingleListeners.get(onPropertyChangedListener);
            if (oldNamespace == null) {
                sSingleListeners.put(onPropertyChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            } else if (namespace.equals(oldNamespace.first)) {
                sSingleListeners.put(onPropertyChangedListener, new Pair<String, Executor>(namespace, executor));
            } else {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sSingleListeners.get((Object)onPropertyChangedListener).first);
                sSingleListeners.put(onPropertyChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void addOnPropertiesChangedListener(String namespace, Executor executor, OnPropertiesChangedListener onPropertiesChangedListener) {
        DeviceConfig.enforceReadPermission(ActivityThread.currentApplication().getApplicationContext(), namespace);
        Object object = sLock;
        synchronized (object) {
            Pair<String, Executor> oldNamespace = sListeners.get(onPropertiesChangedListener);
            if (oldNamespace == null) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            } else if (namespace.equals(oldNamespace.first)) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
            } else {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void removeOnPropertyChangedListener(OnPropertyChangedListener onPropertyChangedListener) {
        Preconditions.checkNotNull(onPropertyChangedListener);
        Object object = sLock;
        synchronized (object) {
            if (sSingleListeners.containsKey(onPropertyChangedListener)) {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sSingleListeners.get((Object)onPropertyChangedListener).first);
                sSingleListeners.remove(onPropertyChangedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void removeOnPropertiesChangedListener(OnPropertiesChangedListener onPropertiesChangedListener) {
        Preconditions.checkNotNull(onPropertiesChangedListener);
        Object object = sLock;
        synchronized (object) {
            if (sListeners.containsKey(onPropertiesChangedListener)) {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.remove(onPropertiesChangedListener);
            }
        }
    }

    private static String createCompositeName(String namespace, String name) {
        Preconditions.checkNotNull(namespace);
        Preconditions.checkNotNull(name);
        return namespace + "/" + name;
    }

    private static Uri createNamespaceUri(String namespace) {
        Preconditions.checkNotNull(namespace);
        return CONTENT_URI.buildUpon().appendPath(namespace).build();
    }

    @GuardedBy(value={"sLock"})
    private static void incrementNamespace(String namespace) {
        Preconditions.checkNotNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount != null) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second + 1));
        } else {
            ContentObserver contentObserver = new ContentObserver(null){

                @Override
                public void onChange(boolean selfChange, Uri uri) {
                    if (uri != null) {
                        DeviceConfig.handleChange(uri);
                    }
                }
            };
            ActivityThread.currentApplication().getContentResolver().registerContentObserver(DeviceConfig.createNamespaceUri(namespace), true, contentObserver);
            sNamespaces.put(namespace, new Pair<1, Integer>(contentObserver, 1));
        }
    }

    @GuardedBy(value={"sLock"})
    private static void decrementNamespace(String namespace) {
        Preconditions.checkNotNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount == null) {
            return;
        }
        if ((Integer)namespaceCount.second > 1) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second - 1));
        } else {
            ActivityThread.currentApplication().getContentResolver().unregisterContentObserver((ContentObserver)namespaceCount.first);
            sNamespaces.remove(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleChange(Uri uri) {
        String value;
        Preconditions.checkNotNull(uri);
        List<String> pathSegments = uri.getPathSegments();
        final String namespace = pathSegments.get(1);
        final String name = pathSegments.get(2);
        try {
            value = DeviceConfig.getProperty(namespace, name);
        }
        catch (SecurityException e) {
            Log.e(TAG, "OnPropertyChangedListener update failed: permission violation.");
            return;
        }
        Object object = sLock;
        synchronized (object) {
            int j;
            int i;
            for (i = 0; i < sListeners.size(); ++i) {
                if (!namespace.equals(DeviceConfig.sListeners.valueAt((int)i).first)) continue;
                j = i;
                ((Executor)DeviceConfig.sListeners.valueAt((int)i).second).execute(new Runnable(){

                    @Override
                    public void run() {
                        HashMap<String, String> propertyMap = new HashMap<String, String>(1);
                        propertyMap.put(name, value);
                        ((OnPropertiesChangedListener)sListeners.keyAt(j)).onPropertiesChanged(new Properties(namespace, propertyMap));
                    }
                });
            }
            for (i = 0; i < sSingleListeners.size(); ++i) {
                if (!namespace.equals(DeviceConfig.sSingleListeners.valueAt((int)i).first)) continue;
                j = i;
                ((Executor)DeviceConfig.sSingleListeners.valueAt((int)i).second).execute(new Runnable(){

                    @Override
                    public void run() {
                        ((OnPropertyChangedListener)sSingleListeners.keyAt(j)).onPropertyChanged(namespace, name, value);
                    }
                });
            }
        }
    }

    public static void enforceReadPermission(Context context, String namespace) {
        if (context.checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") != 0 && !PUBLIC_NAMESPACES.contains(namespace)) {
            throw new SecurityException("Permission denial: reading from settings requires:android.permission.READ_DEVICE_CONFIG");
        }
    }

    @SystemApi
    public static class Properties {
        private final String mNamespace;
        private final HashMap<String, String> mMap;

        Properties(String namespace, Map<String, String> keyValueMap) {
            Preconditions.checkNotNull(namespace);
            this.mNamespace = namespace;
            this.mMap = new HashMap();
            if (keyValueMap != null) {
                this.mMap.putAll(keyValueMap);
            }
        }

        public String getNamespace() {
            return this.mNamespace;
        }

        public Set<String> getKeyset() {
            return this.mMap.keySet();
        }

        public String getString(String name, String defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            return value != null ? value : defaultValue;
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            return value != null ? Boolean.parseBoolean(value) : defaultValue;
        }

        public int getInt(String name, int defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing int failed for " + name);
                return defaultValue;
            }
        }

        public long getLong(String name, long defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing long failed for " + name);
                return defaultValue;
            }
        }

        public float getFloat(String name, float defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing float failed for " + name);
                return defaultValue;
            }
        }
    }

    @SystemApi
    public static interface OnPropertiesChangedListener {
        public void onPropertiesChanged(Properties var1);
    }

    @SystemApi
    public static interface OnPropertyChangedListener {
        public void onPropertyChanged(String var1, String var2, String var3);
    }

    public static interface WindowManager {
        public static final String KEY_SYSTEM_GESTURE_EXCLUSION_LIMIT_DP = "system_gesture_exclusion_limit_dp";
        public static final String KEY_SYSTEM_GESTURES_EXCLUDED_BY_PRE_Q_STICKY_IMMERSIVE = "system_gestures_excluded_by_pre_q_sticky_immersive";
    }
}

