/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IntentSender;
import android.content.MimeTypeFilter;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.ParcelableException;
import android.provider.DocumentsContract;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.Objects;
import libcore.io.IoUtils;

public abstract class DocumentsProvider
extends ContentProvider {
    private static final String TAG = "DocumentsProvider";
    private static final int MATCH_ROOTS = 1;
    private static final int MATCH_ROOT = 2;
    private static final int MATCH_RECENT = 3;
    private static final int MATCH_SEARCH = 4;
    private static final int MATCH_DOCUMENT = 5;
    private static final int MATCH_CHILDREN = 6;
    private static final int MATCH_DOCUMENT_TREE = 7;
    private static final int MATCH_CHILDREN_TREE = 8;
    private String mAuthority;
    private UriMatcher mMatcher;

    @Override
    public void attachInfo(Context context, ProviderInfo info) {
        this.registerAuthority(info.authority);
        if (!info.exported) {
            throw new SecurityException("Provider must be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grantUriPermissions");
        }
        if (!"android.permission.MANAGE_DOCUMENTS".equals(info.readPermission) || !"android.permission.MANAGE_DOCUMENTS".equals(info.writePermission)) {
            throw new SecurityException("Provider must be protected by MANAGE_DOCUMENTS");
        }
        super.attachInfo(context, info);
    }

    @Override
    public void attachInfoForTesting(Context context, ProviderInfo info) {
        this.registerAuthority(info.authority);
        super.attachInfoForTesting(context, info);
    }

    private void registerAuthority(String authority) {
        this.mAuthority = authority;
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(this.mAuthority, "root", 1);
        this.mMatcher.addURI(this.mAuthority, "root/*", 2);
        this.mMatcher.addURI(this.mAuthority, "root/*/recent", 3);
        this.mMatcher.addURI(this.mAuthority, "root/*/search", 4);
        this.mMatcher.addURI(this.mAuthority, "document/*", 5);
        this.mMatcher.addURI(this.mAuthority, "document/*/children", 6);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*", 7);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*/children", 8);
    }

    public boolean isChildDocument(String parentDocumentId, String documentId) {
        return false;
    }

    private void enforceTree(Uri documentUri) {
        if (DocumentsContract.isTreeUri(documentUri)) {
            String child;
            String parent = DocumentsContract.getTreeDocumentId(documentUri);
            if (Objects.equals(parent, child = DocumentsContract.getDocumentId(documentUri))) {
                return;
            }
            if (!this.isChildDocument(parent, child)) {
                throw new SecurityException("Document " + child + " is not a descendant of " + parent);
            }
        }
    }

    public String createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Create not supported");
    }

    public String renameDocument(String documentId, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Rename not supported");
    }

    public void deleteDocument(String documentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Delete not supported");
    }

    public String copyDocument(String sourceDocumentId, String targetParentDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Copy not supported");
    }

    public String moveDocument(String sourceDocumentId, String sourceParentDocumentId, String targetParentDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Move not supported");
    }

    public void removeDocument(String documentId, String parentDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public DocumentsContract.Path findDocumentPath(String parentDocumentId, String childDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("findDocumentPath not supported.");
    }

    public IntentSender createWebLinkIntent(String documentId, Bundle options) throws FileNotFoundException {
        throw new UnsupportedOperationException("createWebLink is not supported.");
    }

    public abstract Cursor queryRoots(String[] var1) throws FileNotFoundException;

    public Cursor queryRecentDocuments(String rootId, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Recent not supported");
    }

    public Cursor queryRecentDocuments(String rootId, String[] projection, Bundle queryArgs, CancellationSignal signal) throws FileNotFoundException {
        Preconditions.checkNotNull(rootId, "rootId can not be null");
        Cursor c = this.queryRecentDocuments(rootId, projection);
        Bundle extras = new Bundle();
        c.setExtras(extras);
        extras.putStringArray("android.content.extra.HONORED_ARGS", new String[0]);
        return c;
    }

    public abstract Cursor queryDocument(String var1, String[] var2) throws FileNotFoundException;

    public abstract Cursor queryChildDocuments(String var1, String[] var2, String var3) throws FileNotFoundException;

    public Cursor queryChildDocuments(String parentDocumentId, String[] projection, Bundle queryArgs) throws FileNotFoundException {
        return this.queryChildDocuments(parentDocumentId, projection, DocumentsProvider.getSortClause(queryArgs));
    }

    public Cursor queryChildDocumentsForManage(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        throw new UnsupportedOperationException("Manage not supported");
    }

    public Cursor querySearchDocuments(String rootId, String query, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Search not supported");
    }

    public Cursor querySearchDocuments(String rootId, String[] projection, Bundle queryArgs) throws FileNotFoundException {
        Preconditions.checkNotNull(rootId, "rootId can not be null");
        Preconditions.checkNotNull(queryArgs, "queryArgs can not be null");
        return this.querySearchDocuments(rootId, DocumentsContract.getSearchDocumentsQuery(queryArgs), projection);
    }

    public void ejectRoot(String rootId) {
        throw new UnsupportedOperationException("Eject not supported");
    }

    public Bundle getDocumentMetadata(String documentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Metadata not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentType(String documentId) throws FileNotFoundException {
        Cursor cursor = this.queryDocument(documentId, null);
        try {
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            IoUtils.closeQuietly(cursor);
        }
    }

    public abstract ParcelFileDescriptor openDocument(String var1, String var2, CancellationSignal var3) throws FileNotFoundException;

    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        throw new UnsupportedOperationException("Thumbnails not supported");
    }

    public AssetFileDescriptor openTypedDocument(String documentId, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        throw new FileNotFoundException("The requested MIME type is not supported.");
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        throw new UnsupportedOperationException("Pre-Android-O query format not supported.");
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        throw new UnsupportedOperationException("Pre-Android-O query format not supported.");
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 1: {
                    return this.queryRoots(projection);
                }
                case 3: {
                    return this.queryRecentDocuments(DocumentsContract.getRootId(uri), projection, queryArgs, cancellationSignal);
                }
                case 4: {
                    return this.querySearchDocuments(DocumentsContract.getRootId(uri), projection, queryArgs);
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.queryDocument(DocumentsContract.getDocumentId(uri), projection);
                }
                case 6: 
                case 8: {
                    this.enforceTree(uri);
                    if (DocumentsContract.isManageMode(uri)) {
                        return this.queryChildDocumentsForManage(DocumentsContract.getDocumentId(uri), projection, DocumentsProvider.getSortClause(queryArgs));
                    }
                    return this.queryChildDocuments(DocumentsContract.getDocumentId(uri), projection, queryArgs);
                }
            }
            throw new UnsupportedOperationException("Unsupported Uri " + uri);
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, "Failed during query", e);
            return null;
        }
    }

    private static String getSortClause(Bundle queryArgs) {
        String sortClause = (queryArgs = queryArgs != null ? queryArgs : Bundle.EMPTY).getString("android:query-arg-sql-sort-order");
        if (sortClause == null && queryArgs.containsKey("android:query-arg-sort-columns")) {
            sortClause = ContentResolver.createSqlSortClause(queryArgs);
        }
        return sortClause;
    }

    @Override
    public final String getType(Uri uri) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 2: {
                    return "vnd.android.document/root";
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.getDocumentType(DocumentsContract.getDocumentId(uri));
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, "Failed during getType", e);
            return null;
        }
    }

    @Override
    public Uri canonicalize(Uri uri) {
        Context context = this.getContext();
        switch (this.mMatcher.match(uri)) {
            case 7: {
                this.enforceTree(uri);
                Uri narrowUri = DocumentsContract.buildDocumentUri(uri.getAuthority(), DocumentsContract.getDocumentId(uri));
                int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, uri);
                context.grantUriPermission(this.getCallingPackage(), narrowUri, modeFlags);
                return narrowUri;
            }
        }
        return null;
    }

    private static int getCallingOrSelfUriPermissionModeFlags(Context context, Uri uri) {
        int modeFlags = 0;
        if (context.checkCallingOrSelfUriPermission(uri, 1) == 0) {
            modeFlags |= 1;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 2) == 0) {
            modeFlags |= 2;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 65) == 0) {
            modeFlags |= 0x40;
        }
        return modeFlags;
    }

    @Override
    public final Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    @Override
    public final int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    @Override
    public final int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Update not supported");
    }

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        if (!method.startsWith("android:")) {
            return super.call(method, arg, extras);
        }
        try {
            return this.callUnchecked(method, arg, extras);
        }
        catch (FileNotFoundException e) {
            throw new ParcelableException(e);
        }
    }

    private Bundle callUnchecked(String method, String arg, Bundle extras) throws FileNotFoundException {
        Context context = this.getContext();
        Bundle out = new Bundle();
        if ("android:ejectRoot".equals(method)) {
            Uri rootUri = (Uri)extras.getParcelable("uri");
            this.enforceWritePermissionInner(rootUri, this.getCallingPackage(), null);
            String rootId = DocumentsContract.getRootId(rootUri);
            this.ejectRoot(rootId);
            return out;
        }
        Uri documentUri = (Uri)extras.getParcelable("uri");
        String authority = documentUri.getAuthority();
        String documentId = DocumentsContract.getDocumentId(documentUri);
        if (!this.mAuthority.equals(authority)) {
            throw new SecurityException("Requested authority " + authority + " doesn't match provider " + this.mAuthority);
        }
        this.enforceTree(documentUri);
        if ("android:isChildDocument".equals(method)) {
            this.enforceReadPermissionInner(documentUri, this.getCallingPackage(), null);
            Uri childUri = (Uri)extras.getParcelable("android.content.extra.TARGET_URI");
            String childAuthority = childUri.getAuthority();
            String childId = DocumentsContract.getDocumentId(childUri);
            out.putBoolean("result", this.mAuthority.equals(childAuthority) && this.isChildDocument(documentId, childId));
        } else if ("android:createDocument".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            String mimeType = extras.getString("mime_type");
            String displayName = extras.getString("_display_name");
            String newDocumentId = this.createDocument(documentId, mimeType, displayName);
            Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
            out.putParcelable("uri", newDocumentUri);
        } else if ("android:createWebLinkIntent".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            Bundle options = extras.getBundle("options");
            IntentSender intentSender = this.createWebLinkIntent(documentId, options);
            out.putParcelable("result", intentSender);
        } else if ("android:renameDocument".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            String displayName = extras.getString("_display_name");
            String newDocumentId = this.renameDocument(documentId, displayName);
            if (newDocumentId != null) {
                Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                    int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                    context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                }
                out.putParcelable("uri", newDocumentUri);
                this.revokeDocumentPermission(documentId);
            }
        } else if ("android:deleteDocument".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            this.deleteDocument(documentId);
            this.revokeDocumentPermission(documentId);
        } else if ("android:copyDocument".equals(method)) {
            Uri targetUri = (Uri)extras.getParcelable("android.content.extra.TARGET_URI");
            String targetId = DocumentsContract.getDocumentId(targetUri);
            this.enforceReadPermissionInner(documentUri, this.getCallingPackage(), null);
            this.enforceWritePermissionInner(targetUri, this.getCallingPackage(), null);
            String newDocumentId = this.copyDocument(documentId, targetId);
            if (newDocumentId != null) {
                Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                    int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                    context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                }
                out.putParcelable("uri", newDocumentUri);
            }
        } else if ("android:moveDocument".equals(method)) {
            Uri parentSourceUri = (Uri)extras.getParcelable("parentUri");
            String parentSourceId = DocumentsContract.getDocumentId(parentSourceUri);
            Uri targetUri = (Uri)extras.getParcelable("android.content.extra.TARGET_URI");
            String targetId = DocumentsContract.getDocumentId(targetUri);
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            this.enforceReadPermissionInner(parentSourceUri, this.getCallingPackage(), null);
            this.enforceWritePermissionInner(targetUri, this.getCallingPackage(), null);
            String newDocumentId = this.moveDocument(documentId, parentSourceId, targetId);
            if (newDocumentId != null) {
                Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                    int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                    context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                }
                out.putParcelable("uri", newDocumentUri);
            }
        } else if ("android:removeDocument".equals(method)) {
            Uri parentSourceUri = (Uri)extras.getParcelable("parentUri");
            String parentSourceId = DocumentsContract.getDocumentId(parentSourceUri);
            this.enforceReadPermissionInner(parentSourceUri, this.getCallingPackage(), null);
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            this.removeDocument(documentId, parentSourceId);
        } else if ("android:findDocumentPath".equals(method)) {
            boolean isTreeUri = DocumentsContract.isTreeUri(documentUri);
            if (isTreeUri) {
                this.enforceReadPermissionInner(documentUri, this.getCallingPackage(), null);
            } else {
                this.getContext().enforceCallingPermission("android.permission.MANAGE_DOCUMENTS", null);
            }
            String parentDocumentId = isTreeUri ? DocumentsContract.getTreeDocumentId(documentUri) : null;
            DocumentsContract.Path path = this.findDocumentPath(parentDocumentId, documentId);
            if (isTreeUri) {
                if (!Objects.equals(path.getPath().get(0), parentDocumentId)) {
                    Log.wtf(TAG, "Provider doesn't return path from the tree root. Expected: " + parentDocumentId + " found: " + path.getPath().get(0));
                    LinkedList<String> docs = new LinkedList<String>(path.getPath());
                    while (docs.size() > 1 && !Objects.equals(docs.getFirst(), parentDocumentId)) {
                        docs.removeFirst();
                    }
                    path = new DocumentsContract.Path(null, docs);
                }
                if (path.getRootId() != null) {
                    Log.wtf(TAG, "Provider returns root id :" + path.getRootId() + " unexpectedly. Erase root id.");
                    path = new DocumentsContract.Path(null, path.getPath());
                }
            }
            out.putParcelable("result", path);
        } else {
            if ("android:getDocumentMetadata".equals(method)) {
                return this.getDocumentMetadata(documentId);
            }
            throw new UnsupportedOperationException("Method not supported " + method);
        }
        return out;
    }

    public final void revokeDocumentPermission(String documentId) {
        Context context = this.getContext();
        context.revokeUriPermission(DocumentsContract.buildDocumentUri(this.mAuthority, documentId), -1);
        context.revokeUriPermission(DocumentsContract.buildTreeDocumentUri(this.mAuthority, documentId), -1);
    }

    @Override
    public final ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
    }

    @Override
    public final ParcelFileDescriptor openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
    }

    @Override
    public final AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    @Override
    public final AssetFileDescriptor openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    @Override
    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        return this.openTypedAssetFileImpl(uri, mimeTypeFilter, opts, null);
    }

    @Override
    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        return this.openTypedAssetFileImpl(uri, mimeTypeFilter, opts, signal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDocumentStreamTypes(String documentId, String mimeTypeFilter) {
        Cursor cursor;
        block4: {
            String[] stringArray;
            cursor = null;
            try {
                cursor = this.queryDocument(documentId, null);
                if (!cursor.moveToFirst()) break block4;
                String mimeType = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                long flags = cursor.getLong(cursor.getColumnIndexOrThrow("flags"));
                if ((flags & 0x200L) != 0L || mimeType == null || !MimeTypeFilter.matches(mimeType, mimeTypeFilter)) break block4;
                stringArray = new String[]{mimeType};
            }
            catch (FileNotFoundException e) {
                String[] stringArray2;
                try {
                    stringArray2 = null;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(cursor);
                    throw throwable;
                }
                IoUtils.closeQuietly(cursor);
                return stringArray2;
            }
            IoUtils.closeQuietly(cursor);
            return stringArray;
        }
        IoUtils.closeQuietly(cursor);
        return null;
    }

    @Override
    public String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
        this.enforceTree(uri);
        return this.getDocumentStreamTypes(DocumentsContract.getDocumentId(uri), mimeTypeFilter);
    }

    private final AssetFileDescriptor openTypedAssetFileImpl(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        String documentId = DocumentsContract.getDocumentId(uri);
        if (opts != null && opts.containsKey("android.content.extra.SIZE")) {
            Point sizeHint = (Point)opts.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(documentId, sizeHint, signal);
        }
        if ("*/*".equals(mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        String baseType = this.getType(uri);
        if (baseType != null && ClipDescription.compareMimeTypes(baseType, mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        return this.openTypedDocument(documentId, mimeTypeFilter, opts, signal);
    }
}

